/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: start.S,v 1.2 2004/10/07 17:10:56 honda Exp $
 */

/*
 *	ͥѤΥȥåץ⥸塼PowerPCѡ
 *	
 *	쥸γ
 *		r1 åݥ
 *		SPRG0ߡCPU㳰ͥȥ
 *		SPRG1int_table
 *			ѵ٥ơ֥Ƭɥ쥹
 *		SPRG2exc_table
 *			CPU㳰ѵ٥ơ֥Ƭɥ쥹
 */

#define	_MACRO_ONLY
#include <t_config.h>

	.text
	.globl start
	.globl start_1
start:
	/*
	 *  ץå⡼ɤȥåݥ󥿤ν
	 *ꥻåȻMSRνͤΤޤޤǤ褱С
	 *INIT_MSRʤƤ褤
	 */
#ifdef INIT_MSR
	LI32(r3, INIT_MSR)		/*  MSRν  */
	mtmsr	r3
#endif	/*  INIT_MSR  */
	
	/*
	 * 󥿥ƥȤΥåSTACKTOP˽
	 * STACKTOPϡsys_config.h
	 * 󥰡٥󥷥δط8ХȤ餷Ƥ
	 */
	LI32(sp, STACKTOP - STACK_MARGIN)
	
	/*  ߡCPU㳰ͥȥ󥿤ν  */
	li	r5, 1
	mtspr	SPRG0, r5
	
	/*  ѵ٥ơ֥Ƭɥ쥹  */
	LI32(r6, int_table)
	mtspr	SPRG1, r6
	
	/*  CPU㳰ѵ٥ơ֥Ƭɥ쥹  */
	LI32(r7, exc_table)
	mtspr	SPRG2, r7
	
	/*
	 *  hardware_init_hook θƽФ0 Ǥʤ
	 *
	 *  ϡɥ¸ɬפʽϡ
	 *  hardware_init_hook ȤؿѰդФ褤
	 *  ŪˤROMκݡRAMѲǽˤ뤿
	 *  ХȥνԤ
	 *  sys_support.S  hardware_init_hook Ƥ
	 *  롥
	 */
	LI32(r8, hardware_init_hook)
	mtctr	r8
	cmpwi	crf0, r8, 0
	bnectrl

	/*
	 *  bssΥꥢ
	 */
start_1:
	LI32(r5, __bss_start)
	LI32(r6, _end)
	cmpw	crf0, r5, r6
	beq	start_3
	li	r0, 0
	subi	r5, r5, 4
	subi	r6, r6, 4
start_2:
	stwu	r0, 4(r5)	/*  r5ι1̿Ǽ¹Ԥ  */
	cmpw	crf0, r5, r6
	blt	start_2	

	/*
	 *  dataνROMб
	 *
	 *  __idata_start  __idata_end ޤǤ__data_start ʹߤ
	 *  ԡ롥
	 */
start_3:
	LI32(r7, __idata_start)
	LI32(r8, __idata_end)
	cmpw	crf0, r7, r8
	beq	start_5
	LI32(r9, __data_start)
	subi	r7, r7, 4	/*  lwzu̿Ȥ-4Ƥ  */
	subi	r8, r8, 4
	subi	r9, r9, 4
start_4:
	lwzu	r10, 4(r7)	/*  r7ι1̿Ǽ¹Ԥ  */
	stwu	r10, 4(r9)	/*  r9ι1̿Ǽ¹Ԥ  */
	cmpw	crf0, r7, r8
	blt	start_4

	/*
	 *  software_init_hook ƽФ0 Ǥʤ
	 *
	 *  եȥĶä˥饤֥ˤ˰¸ɬפʽ
	 *  ϡsoftware_init_hook ȤؿѰդ
	 *  褤
	 */
start_5:
	LI32(r4, software_init_hook)
	mtctr	r4
	cmpwi	crf0, r4, 0
	bnectrl

	/*
	 *  ͥư롥
	 */
start_6:
	LI32(r5, kernel_start)
	mtctr	r5
	bctr

/*  end of file  */
