/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: vea_oea_emb.h,v 1.2 2004/10/07 17:10:56 honda Exp $
 */

/*  
 *   PowerPCƥVEA,OEA¸
 *   The IBM PowerPC Embedded Environmentξ
 *   IBMPowerPC40xեߥꤳ˳롣
 *   
 *   PowerPCƥϰʲΣĤΥ٥뤫
 *   USIA:User Instruction Set Architecture
 *   VEA: Virtual Environment Architecture
 *   OEA: Operating Environment Architecture
 *   
 *   USIAˤĤƤﶦ̤Ǥ뤬VEAOEAˤĤƤ
 *   ꥸʥPowerPCƥThe IBM PowerPC 
 *   Embedded Environment줾̤Ƥ뤿ᡢ
 *   VEAOEAϥեʬơ򥤥󥯥롼
 *   Ƥ롣
 */   


#ifndef _VEA_OEA_EMB_H_
#define _VEA_OEA_EMB_H_

/*  
 *  쥸ֹ
 */   

/*
 *  Special Purpose RegisterΥ쥸ֹ
 *  (*)PowerPCƥǤƤʤ쥸
 */

/*
 *  㳰˴ؤ쥸
 */
#define SRR0	  26	/* Save/Restore Register0  */
#define SRR1	  27	/* Save/Restore Register1  */
#define SRR2	 990	/* Save/Restore Register2(*)  */
#define SRR3	 991	/* Save/Restore Register3(*)  */
#define ESR	 980	/* Exception Syndrome Register(*)  */
#define DEAR	 981	/* Data Exception Address Register(*)  */
#define EVPR	 982	/* Exception Vector Prefix Register(*)  */

#define SPRG0	 272	/* SPR General 0  */
#define SPRG1	 273	/* SPR General 1  */
#define SPRG2	 274	/* SPR General 2  */
#define SPRG3	 275	/* SPR General 3  */

/*
 *  ¾Υ쥸
 */
#define DAC	1014	/* Data Address Compare(*) */
#define DBCR	1010	/* Debug Control Register(*) */
#define DBSR	1008	/* Debug Status Register(*) */
#define DCCR	1018	/* Data Cache Cacheability Register(*) */
#define DCWR	 954	/* Data Cache Write-thru Register(*) */

#define IAC	1012	/* Instruction Address Compare(*) */
#define ICCR	1019	/* Instruction Cache Cacheability Register(*) */

#define PID	 945	/* Process ID Register  */
#define PIT	 987	/* Programmable Interval Timer(*) */
#define PVR	 287	/* Processor Version Register  */

#define SGR	 953	/* Storage Guarded Register(*) */
#define SLER	 955	/* Storage Little-Endian Register(*) */
#define SMR	 952	/* Storage Memory-Coherent Register(*) */

/*  VEA  */
#define TBL	 268	/* Time Base Lower(for read)  */
#define TBU	 269	/* Time Base Upper(for read)  */
/*  OEA  */
#define TBLw	 284	/* Time Base Lower(for write)  */
#define TBUw	 285	/* Time Base Upper(for write)  */

#define TCR	 986	/* Timer Control Registe(*) */
#define TSR	 984	/* Timer Status Register(*) */
#define ZPR	 944	/* Zone Protection Register(*) */

/*
 *  MSRΥӥå
 */
/*  0-10:Reserved  */
#define MSR_APE	BIT11_32	/* Auxiliary Processor Exception Enable */
#define MSR_APA	BIT12_32	/* Auxiliary Processor Available */
#define MSR_WE	BIT13_32	/* Wait State Enable */
#define MSR_CE	BIT14_32	/* Critical Enable */
#define MSR_ILE	BIT15_32	/* Interrupt Little Endian */
#define MSR_EE	BIT16_32	/* External Enable */
#define MSR_PR	BIT17_32	/* Problem State */
#define MSR_FP	BIT18_32	/* Floating Point Available */
#define MSR_ME	BIT19_32	/* Machine Check Enable */
#define MSR_FE0	BIT20_32	/* Floating Point Exception Mode 0 */
/*  21:Reserved  */
#define MSR_DE	BIT22_32	/* Debug Interrupts Enable */
#define MSR_FE1	BIT23_32	/* Floating Point Exception Mode 1 */
/*  23-25:Reserved  */
#define MSR_IR	BIT26_32	/* Instruction Relocate */
#define MSR_DR	BIT27_32	/* Data Relocate */
/*  28-30:Reserved  */
#define MSR_LE	BIT31_32	/* Little Endian */


/*
 *  ESR(Exception Syndrome Register)Υӥå
 */
#define ESR_PIL	BIT4_32	 /* Program - Illegal Instruction exception */
#define ESR_PPR	BIT5_32	 /* Program - Privileged Instruction exception */
#define ESR_PTR	BIT6_32	 /* Program - Trap exception */
#define ESR_PFE	BIT7_32	 /* Program - Floating Point Enabled exception */
#define ESR_DST	BIT8_32	 /* Data Storage / Data TLB Miss - Store Operations */
#define ESR_DIZ	BIT9_32	 /* Data / Instruction Storage - Zone exception */
	/* Program - Auxiliary Processor Unavailable exception */
#define ESR_PAU	BIT12_32
	/* Program - Floating Point Enabled but Unimplemented exception */
#define ESR_PFEU BIT13_32
	/* Program - Auxiliary Processor Enabled exception */
#define ESR_PAE	BIT14_32


/*  
 *   CPU㳰װ
 *   ֹ椬Ϣ³ʤΤCPU㳰٥ơ֥˰̵̤뤬
 *   PowerPCƥ˹碌ͥ褷
 */   
#define EXC_NO_CRITICAL_INPUT           	0x1
#define EXC_NO_MACHINE_CHECK            	0x2
#define EXC_NO_DATA_STORAGE             	0x3
#define EXC_NO_INSTRUCTION_STORAGE      	0x4
#define EXC_NO_EXTERNAL_INTERRUPT       	0x5   /*    */
#define EXC_NO_ALIGNMENT                	0x6
			/*  ץ㳰װ*/
#define EXC_NO_PROGRAM                  	0x7
#define EXC_NO_FLOATING_POINT_UNAVAILABLE 	0x8
/*  APUPowerPC405440Τߡ  */

/*  0x900Reserved  */
/*  0xa00Reserved  */
/*  0xb00Reserved  */
#define EXC_NO_SYSTEM_CALL              	0xc	/*  ƥॳ  */
/*  0xd00Reserved  */
/*  0xe00Reserved  */
/*  0xe10-0xff0Reserved  */
/* 0x1000Programmable Interval Timer  */
/* 0x1010Fixed Interval Timer  */
/* 0x1020Watchdog Timer  */
/* 0x1030-0x10f0Reserved  */
/* 0x1100Data TLB miss  */
/* 0x1110-0x11f0Reserved  */
/* 0x1200Instruction TLB miss  */
/* 0x1210-0x1ff0Reserved  */
/* 0x2000Debugװ   */
/* 0x2010-0x2ff0Implementation Specific  */

/*  
 *   㳰μ̿
 *   ߤ⣱Ĥȿ
 *   0֤̤
 *   㳰٥ΥեåȤб
 *   ߤ⣱Ĥȿ
 *   Τᡢ+1Ƥ
 */   

#define TMAX_EXCNO       ( 0x20 + 1 + NUM_IMPLEMENT_EXCEPTION )


/*
 *  DCRؤΥ
 *     DCR:Device Control Register
 *     ʲΥ롼ϥǥХɥ饤и˺Ƥ롣
 *     DCRζŪ̾Τ䵡ǽϥǥХ¸Ǥ롣
 *     
 *     
 *     mfdcr,mtdcr̿DCRֹѥ쥸ǤϤʤ
 *     ¨ͤǻꤹ뤿ᡢ饤ؿˤǤʤ
 */

/*
 *  DCRθͤɽФ
 *     reg:쥸ֹ
 *     val:ɤ߽ФͤǼѿUW
 */
#define _sil_rew_dcr(reg, val)	Asm("mfdcr %0," #reg : "=r"(val))
#define sil_rew_dcr(reg, val)	_sil_rew_dcr(reg, val)

/*
 *  DCRθͤѹ
 *     reg:쥸ֹ
 *     val:ꤹͤǼ줿ѿUW
 */
#define _sil_wrw_dcr(reg, val)	Asm("mtdcr "#reg",%0" : : "r"(val) )
#define sil_wrw_dcr(reg, val)	_sil_wrw_dcr(reg, val)


#endif /* _VEA_OEA_EMB_H_ */
/*  end of file  */
