/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_serial.h,v 1.6 2015/06/28 16:46:37 ssuzuki Exp $
 */

/*
 *	ꥢI/OǥХSIO˥ɥ饤СGR-SAKURAѡ
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>
#ifndef _MACRO_ONLY
#include <rx63n.h>
#include <rx63nsci.h>
#endif /* _MACRO_ONLY */

/*
 *  SIOγߥϥɥΥ٥ֹ
 */
#define INHNO_SIO_RXI	214
#define INHNO_SIO_TXI	215
#define INHNO_SIO_TEI	216
#define INHNO_SIO_ERI	114

#ifndef _MACRO_ONLY

/*
 *  SIOɥ饤Фν롼
 */
#define	sio_initialize	rx63nsci_initialize

/*
 *  ꥢI/OݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;
	BOOL	openflag;

	/*
	 *  ץ󤷤ݡȤ뤫 openflag ɤǤ
	 */
	openflag = rx63nsci_openflag(siopid);

	/*
	 *  ǥХ¸Υץ
	 */
	siopcb = rx63nsci_opn_por(siopid, exinf);

	/*
	 *  ꥢI/Oߤγߥ٥ꤷޥ롥
	 */
	if (!openflag) {
		/* RXITXITEIERIγƳߤͥ٤1ꤹ */
		sil_wrb_mem((VP) RX63N_IPR214, 0x01);	/* RXI, TXI and TEI */
		sil_wrb_mem((VP) RX63N_IPR114, 0x01);	/* ERI */

		/* RXI׵Ĥ */
		bitset((VP) RX63N_IER1A, 6);
		/* TXI׵Ĥ */
		bitset((VP) RX63N_IER1A, 7);
		/* TEI׵Ĥ */
		bitset((VP) RX63N_IER1B, 0);
	
		/* 롼12ߤĤ */
		bitset((VP) RX63N_IER0E, 2);
	
		/* ERI׵Ĥ */
		bitset((VP) RX63N_GEN12, 0);
		sil_wrw_mem((VP) RX63N_GEN12,
				sil_rew_mem((VP) RX63N_GEN12)
				| (0x00000001 << 0));
	}
	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  ǥХ¸Υ
	 */
	rx63nsci_cls_por(siopcb);

	/*
	 *  ꥢI/Oߤޥ롥
	 */
	/* ERI׵ػߤ */
	sil_wrw_mem((VP) RX63N_GEN12,
			sil_rew_mem((VP) RX63N_GEN12) & ~(0x00000001 << 0));

	/* 롼12ߤػߤ */
	bitclr((VP) RX63N_IER0E, 2);

	/* TEI׵ػߤ */
	bitclr((VP) RX63N_IER1B, 0);
	/* TXI׵ػߤ */
	bitclr((VP) RX63N_IER1A, 7);
	/* RXI׵ػߤ */
	bitclr((VP) RX63N_IER1A, 6);

	/* RXITXITEIERIγƳߤͥ٤0ꤹ */
	sil_wrb_mem((VP) RX63N_IPR114, 0x00);	/* ERI */
	sil_wrb_mem((VP) RX63N_IPR220, 0x00);	/* RXI, TXI and TEI */
}

/*
 *  SIOγߥϥɥ
 */
#define	sio_handler_rxi	rx63nsci_isr_rxi_1
#define	sio_handler_txi	rx63nsci_isr_txi_1
#define	sio_handler_tei	rx63nsci_isr_tei_1
#define	sio_handler_eri	rx63nsci_isr_eri

/*
 *  ꥢI/OݡȤؤʸ
 */
#define	sio_snd_chr	rx63nsci_snd_chr

/*
 *  ꥢI/OݡȤʸ
 */
#define	sio_rcv_chr	rx63nsci_rcv_chr

/*
 *  ꥢI/OݡȤΥХåε
 */
#define	sio_ena_cbr	rx63nsci_ena_cbr

/*
 *  ꥢI/OݡȤΥХåζػ
 */
#define	sio_dis_cbr	rx63nsci_dis_cbr

/*
 *  ꥢI/OݡȤǽХå
 */
#define	sio_ierdy_snd	rx63nsci_ierdy_snd

/*
 *  ꥢI/OݡȤμΥХå
 */
#define	sio_ierdy_rcv	rx63nsci_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
