/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.c,v 1.16 2005/11/14 08:00:44 honda Exp $
 */

/*
 *	ץå¸⥸塼SH1ѡ
 *ͥǻѤ
 *Cؿμ
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"
#include <sil.h>

/*
 *  ƥȤǤγߥޥ
 */
#ifdef SUPPORT_CHG_IPM
UW	task_intmask;
#endif /* SUPPORT_CHG_IPM */

/*
 *  󥿥ƥȤǤγߥޥ
 */
UW	int_intmask;

/*
 *  ߡCPU㳰ͥȥ
 */
UW	intnest;

/*
 *  ꥸʥΥ٥١쥸¸ΰ
 */
#ifdef KERNEL_HAS_A_VECTOR_TABLE
static VP org_vbr;
#endif /* KERNEL_HAS_A_VECTOR_TABLE */

#ifdef SUPPORT_CPU_EXC_ENTRY_CHECK

/*
 *  CPU㳰װ
 */
#ifndef NUM_EXC
#define NUM_EXC	(6 + 2)
#endif	/*  NUM_EXC  */

/*
 *  Ͽ줿CPU㳰װ
 */
static UW num_exc;

/*
 *  CPU㳰Ƭɥ쥹
 */
static FP exc_entries[NUM_EXC];

#endif /* SUPPORT_CPU_EXC_ENTRY_CHECK */

/*
 *  ץå¸ν
 */
void
cpu_initialize(void)
{
	/*
	 *  ƥȤǤγߥޥν
	 */
#ifdef SUPPORT_CHG_IPM
	task_intmask = 0x0000u;
#endif /* SUPPORT_CHG_IPM */

	/*
	 *  ߡCPU㳰ͥȥ󥿤ν
	 */
	intnest = 1u;

#ifndef GDB_STUB

	/*
	 * ߥȥν
	 */
	sil_wrh_mem(IPRA, 0x0000);
	sil_wrh_mem(IPRB, 0x0000);
	sil_wrh_mem(IPRC, 0x0000);
	sil_wrh_mem(IPRD, 0x0000);
	sil_wrh_mem(IPRE, 0x0000);

#endif	/*  GDB_STUB  */

#ifdef KERNEL_HAS_A_VECTOR_TABLE
	/*
	 *  ٥ơ֥ϽդѿˤˤΤǡ
	 *  ȥåץ롼data򥳥ԡݤ
	 *  롣
	 *  ʤǽɬפϤʤ
	 */
	
	/*
	 *  ٥١쥸ν
	 */
	org_vbr = current_vbr();
	set_vbr((VP)vector_table);
#endif /* KERNEL_HAS_A_VECTOR_TABLE */

#ifdef SUPPORT_CPU_EXC_ENTRY_CHECK
	num_exc = 0;
#endif /* SUPPORT_CPU_EXC_ENTRY_CHECK */

}

/*
 *  ץå¸νλ
 */
void
cpu_terminate(void)
{
#ifdef KERNEL_HAS_A_VECTOR_TABLE
	set_vbr(org_vbr);
#endif /* KERNEL_HAS_A_VECTOR_TABLE */
}

/*
 *  CPU㳰ϥɥ
 *
 *  ٥ȥֹ excno CPU㳰ϥɥεưϤ exchdr ꤹ롥
 */
void
define_exc(EXCNO excno, FP exchdr)
{
	/*  SH1ϳߤCPU㳰Ʊ  */
	define_inh((INHNO)excno, exchdr);

#ifdef SUPPORT_CPU_EXC_ENTRY_CHECK
#if 0
	CHECK_PAR(num_exc < NUM_EXC);
#endif
	exc_entries[num_exc++] = exchdr;
#endif /* SUPPORT_CPU_EXC_ENTRY_CHECK */
}

#ifdef SUPPORT_CPU_EXC_ENTRY_CHECK
/*
 *  CPU㳰ǳ߶ػߤޤǤ̿
 */
#define NUM_INST_DIS_INT	5


/*
 *  ߤΥå
 *
 *  
 *  VP pcåѤޤ줿
 *  
 *  TRUE褬CPU㳰ʳ߶ػߤ
 *  FALSE褬嵭ʳ
 *  
 *  ߤνиǳ߶ػߤǸƤФ롣
 */

/* cpu_support.Sret_intƤФΤ 	*/
/* إåեˤϴޤʤ 		*/
BOOL check_cpu_exc_entry(VP pc)   throw();

BOOL check_cpu_exc_entry(VP pc)
{
	UW i;
	UH *entry;	/* 2ХĹ̿ؤΥݥ */
	
	for(i = 0; i < num_exc; i++) {
		entry = (UH *)exc_entries[i];
		if (((UW)entry <= (UW)pc) &&
		     ((UW)pc <= (UW)(entry + NUM_INST_DIS_INT)) ) {
			return TRUE;
		}
	}
	return FALSE;
}


#endif /* SUPPORT_CPU_EXC_ENTRY_CHECK */



#ifdef SUPPORT_CHG_IPM

/*
 *  ߥޥѹ
 *
 *  chg_ipm Ȥä IPM 0xfNMI ʳΤ٤Ƥγߤػߡˤѹ
 *  뤳ȤϤǤʤNMI ʳΤ٤Ƥγߤػߤˤϡ
 *  loc_cpu ˤCPUå֤ˤФ褤
 *  IPM  0 ʳλˤ⡤ǥѥåαʤIPM ϡ
 *  ǥѥåˤäơ¹Ծ֤ˤʤäذѤ
 *  롥Τᡤ¹ˡ̤Υˤä IPM ѹ
 *  礬롥JSPͥǤϡIPM ѹϥ㳰롼
 *  ˤäƤⵯ뤬ˤäư񤷤ʤϾʤ
 *  פ롥IPM ͤˤäƥǥѥåػߤˤϡ
 *  dis_dsp ʻѤФ褤
 */
SYSCALL ER
chg_ipm(IPM ipm)
{
	ER	ercd;

	LOG_CHG_IPM_ENTER(ipm);
	CHECK_TSKCTX_UNL();
	CHECK_PAR(0 <= ipm && ipm <= (MAX_IPM - 1) );

	t_lock_cpu();
	task_intmask = (ipm << 4);
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_CHG_IPM_LEAVE(ercd);
	return(ercd);
}

/*
 *  ߥޥλ
 */
SYSCALL ER
get_ipm(IPM *p_ipm)
{
	ER	ercd;

	LOG_GET_IPM_ENTER(p_ipm);
	CHECK_TSKCTX_UNL();

	t_lock_cpu();
	*p_ipm = (task_intmask >> 4);
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_GET_IPM_LEAVE(ercd, *p_ipm);
	return(ercd);
}

#endif /* SUPPORT_CHG_IPM */

/*
 * ϿƤʤ㳰ȯȸƤӽФ
 */
void cpu_experr(EXCSTACK *sp)
{
    syslog(LOG_EMERG, "Exception error occurs.");

    syslog(LOG_EMERG, "PC = 0x%08x SR = 0x%08x PR = 0x%08x",
    			sp->pc, sp->sr, sp->pr);

    syslog(LOG_EMERG, "r0 = 0x%08x r1 = 0x%08x r2 = 0x%08x",
    			sp->r0, sp->r1, sp->r2);
    syslog(LOG_EMERG, "r3 = 0x%08x r4 = 0x%08x r5 = 0x%08x",
    			sp->r3, sp->r4, sp->r5);
    syslog(LOG_EMERG, "r6 = 0x%08x r7 = 0x%08x r8 = 0x%08x",
    			sp->r6, sp->r7, sp->r8);
    syslog(LOG_EMERG, "r9 = 0x%08x r10 = 0x%08x r11 = 0x%08x",
    			sp->r9, sp->r10, sp->r11);
    syslog(LOG_EMERG, "r12 = 0x%08x r13 = 0x%08x r14 = 0x%08x",
    			sp->r12, sp->r13, sp->r14);
    			/*  㳰ȯľΥåݥ󥿤  */
    syslog(LOG_EMERG, "r15 = 0x%08x", (sp->r15)+19*4);

    while(1);
}


/*
 *  ֥å饤֥
 *	(ItIsή)
 *
 *  ؿλͤϡANSI C 饤֥λͤƱɸ饤֥ΤΤ
 *  ȤäΨɤǽ롥
 *
 */
void *
_dummy_memcpy(void *dest, const void *src, size_t len)
{
	VB	*d = (VB *)dest;
	VB	*s = (VB *)src;

	while (len-- > 0) {
		*d++ = *s++;
	}
	return(dest);
}

