/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: start.S,v 1.12 2004/09/22 08:47:52 honda Exp $
 */

/*
 *	ͥѤΥȥåץ⥸塼SH1ѡ
 */

#define	_MACRO_ONLY
#include <t_config.h>



/*
 *㳰٥SH1ѡ
 *ǤϥꥻåȻɬפʺ¤Υ٥Ѱդʤ
 *cpu_initialize()㳰٥ΰưVBRν񤭴ˤԤ
 */
#ifdef KERNEL_HAS_A_VECTOR_TABLE

/*
 *   ʲ㳰װǥǥեȤȤϰۤʤ㳰٥
 *   ϡsys_config.hǳޥ롣
 */
	.section ".vector","ax"
	.align 2
	.long   TO_ASM(RESET_VECTOR)	/*   0:ѥꥻå  */
	.long   INIT_STACK		/*       SPν        */
	.long   TO_ASM(RESET_VECTOR)	/*   2:ޥ˥奢ꥻå  */
	.long   INIT_STACK		/*       SPν        */
	.long   TO_ASM(GII_VECTOR)	/*   4:̿        */
	.long   TO_ASM(RESERVED_VECTOR)	/*   5:ƥͽ        */
	.long   TO_ASM(SII_VECTOR)	/*   6:å̿    */
	.long   TO_ASM(RESERVED_VECTOR)	/*   7:ƥͽ        */
	.long   TO_ASM(RESERVED_VECTOR)	/*   8:ƥͽ        */
	.long   TO_ASM(CAE_VECTOR)	/*   9:CPUɥ쥹顼   */
	.long   TO_ASM(DAE_VECTOR)	/*  10:DMAɥ쥹顼   */
	.long   TO_ASM(NMI_VECTOR)	/*  11:MNI                 */
#endif /* KERNEL_HAS_A_VECTOR_TABLE */

/*
 *   SH1ѥȥåץ⥸塼
 */
	.global	_start
	.section .text
	.align 2
_start:
	/*
	 *  SR롣ʳ߶ػߡ
	 *  IPM=0xe
	 *  stub¹ԻΤIPM=0xfȤʤ롣
	 */
	mov.l _init_sr,r0
	ldc   r0,sr
	/*
	 * 󥿥ƥȤΥåSTACKTOP˽
	 * STACKTOPϡsys_config.h
	 */
	mov.l  _stack_k, r15

	/*
	 *  _hardware_init_hook ƤӽФ(0Ǥʤ)
	 *
	 *  ϡɥ¸ɬפʽϡ
	 *  hardware_init_hook ȤؿѰդФ褤
	 *  ŪˤROMκݡRAMѲǽˤ뤿
	 *  ХȥνԤ
	 *  sys_support.S  hardware_init_hook Ƥ
	 *  롥
	 */
start_0:
	/*
	 *  ץå¢RAMѤǤϤΥɥ쥹
	 *  INNER_RAM_ADDRESSޥȤsys_config.hޤ
	 *  ѥ顦ץ롣
	 *¢RAMƬɥ쥹ǤϤʤå
	 *ա
	 *
	 *  ξ硢hardware_init_hook()ؿC
	 *  ҤƤ褤
	 *  ̤CδؿƤӽФϥåѤΤ
	 *  ХȥνˤǤʤ
	 */
#ifdef INNER_RAM_ADDRESS
	mov.l  _inner_ram_address_k, r15
#endif /* INNER_RAM_ADDRESS */
	mov.l   _hardware_init_k, r0
	tst    r0,r0
	bt     start_1
	jsr    @r0
        nop


	/*
         * bss򥯥ꥢ
	 */
start_1:
	/*
         * åݥ󥿤RAM˺ꤹ롣ʾ嵭ȡ
	 */
#ifdef INNER_RAM_ADDRESS
	mov.l  _stack_k, r15
#endif /* INNER_RAM_ADDRESS */

	mov.l	_bss_start_k,r0
	mov.l	_end_k,r1
	cmp/eq  r0,r1
	bt      start_3
	mov	#0,r2
start_2:
	/*
	 *  r0Υ󥯥ȤĹ˸뤬
	 *  mov.l r4,@r0+̿Ϥʤ
	 *	ǥƥ͡Υɥ쥹ϥǥȤΤ
	 */
        mov.l	r2,@r0
	add	#4,r0
 	cmp/hi	r0,r1
	bt	start_2

	/*
	 *  dataROMбˡ
	 *
	 *  __idata_start  __idata_end ޤǤ__data_start ʹߤ
	 *  ԡ롥
	 *
	 *ǥХåĶˤäƤdataǧԶ礬ꡢ
	 *__idata_startϤ˥ɤ٤ǡ__data_start
	 *Ϥ˥ɤƤޤΤ롣ξ
	 *OMIT_DATA_SECTION_COPYޥƤ뤳ȤǤΥԡ
	 *Ȥά롣
	 */
start_3:
#ifndef OMIT_DATA_SECTION_COPY	/*  dataΥԡԤ  */
	mov.l   __idata_start_k,r1
	mov.l   __idata_end_k,r2
	cmp/eq  r1,r2
	bt      start_5
	mov.l   __data_start_k,r0
start_4:
	mov.l   @r1+,r4
	mov.l   r4,@r0
	cmp/hi  r1,r2
	add     #4,r0
	bt      start_4
#endif 	/* OMIT_DATA_SECTION_COPY */

	/*
	 *  software_init_hook ƤӽФ0 Ǥʤˡ
	 *
	 *  եȥĶä˥饤֥ˤ˰¸ɬפʽ
	 *  ϡsoftware_init_hook ȤؿѰդ
	 *  褤
	 */
start_5:
	mov.l  _software_init_hook_k, r0
	tst    r0,r0
	bt     start_6
	jsr    @r0
	nop


start_6:
	/*
         *  ͥư
	 */
	! call the mainline
	mov.l	_kernel_start_k,r0
	jsr	@r0
	nop


	.align 2
_intnest_k:
	.long	_intnest
_init_sr:
	.long	MAX_IPM << 4
_stack_k:
	.long   STACKTOP

#ifdef INNER_RAM_ADDRESS
_inner_ram_address_k:
	.long   INNER_RAM_ADDRESS
#endif /* INNER_RAM_ADDRESS */

_bss_start_k:
	.long   __bss_start

#ifdef FILL_STACK_WITH_0  /*  ǥХåǥåΰѻפ  */
			  /*  뤿ᡢ󥿥ƥȤ    */
			  /*  åΰ            */
_end_k:
	.long   STACKTOP
#else			/*  åΰʤ  */
_end_k:			/*  bss  */
	.long  	_end
#endif	/* FILL_STACK_WITH_0  */


#ifndef OMIT_DATA_SECTION_COPY	/*  dataΥԡԤ  */
__idata_start_k:
	.long 	__idata_start
__idata_end_k:
	.long   __idata_end
__data_start_k:
	.long  	__data_start
#endif 	/* OMIT_DATA_SECTION_COPY */

_kernel_start_k:
	.long	_kernel_start
_hardware_init_k:
	.long   _hardware_init_hook
_software_init_hook_k:
	.long   _software_init_hook

