/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 *  Copyright (C) 2006 by GJ Business Division RICOH COMPANY,LTD. JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *	åȥƥ¸⥸塼CRB_H3ѡ
 *ͥǻѤ
 *ǡޥؿΥץȥ
 *
 *  Υ󥯥롼ɥեϡt_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
 */

#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_

/*
 *  桼
 */
#include <user_config.h>

/*
 *  ͥ̾Υ͡
 */
#include <sys_rename.h>

/*
 *  åȥƥΥϡɥ񸻤
 */
#include "crb_h3.h"

/*
 *  ͥǡʸѥޥ
 */
#include <util.h>

/*
 *  ưåΥåȥƥ̾
 */
#define	TARGET_NAME	"crb_h3"

/*
 *󥿥ƥѥåν
 */
#define str_STACKTOP	TO_STRING(STACKTOP)

/*
 *  ԤΤ
 *  ϥåȿ˰¸롣
 */
#define	SIL_DLY_TIM1	2286
#define	SIL_DLY_TIM2	1664

/*
 *  SIO쥸
 */
#define DEFAULT_SPEED   38400
#define DEFAULT_SMR     0x00	/* Async, 8 bits, No parity, 1 stop bit, no MP, 1/1 */
#define DEFAULT_BRR		(CLOCK_RATE / 32 / DEFAULT_SPEED)

#ifndef _MACRO_ONLY

/*
 *  åȥƥ¸ν
 */
extern void	sys_initialize(void);

/*
 *  åȥƥνλ
 *
 *  ƥλ˻Ȥ
 */
extern void	sys_exit(void);

/*
 *  åȥƥʸ
 *
 *  ƥ٥ʸϥ롼
 */
extern void	sys_putc(char c) throw();

#endif /* _MACRO_ONLY */

/*
 *  㳰٥ơ֥ϢΥޥ
 *  ޥ
 *  KERNEL_HAS_A_VECTOR_TABLE
 *  ͥ뤬㳰٥ơ֥
 *  SIO_RESERVED
 *  ꥢǥХǥХåˤäƻѤƤ
 */
/*
 *  ROMξ
 *  ꥻåȻROMˤ㳰٥ơ֥򻲾Ȥ
 *  塧RAMˤ㳰٥ơ֥򻲾Ȥ
 */
#define KERNEL_HAS_A_VECTOR_TABLE


#endif /* _SYS_CONFIG_H_ */
