/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_serial.h,v 1.5 2005/07/06 00:45:07 honda Exp $
 */

/*
 *ꥢI/OǥХSIO/SCIF˥ɥ饤СHSB7615ITѡ
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>
#ifndef _MACRO_ONLY
#include "sh7615scif.h"
#endif /* _MACRO_ONLY */

/*
 *  SIO/SCIFγߥϥɥΥ٥ֹ
 */
/* ϥݡȤsys_config.c */
/* ߥ٥ֹhw_serial.h */
/* ֥åsh7615scif.c */

#ifndef GDB_STUB

#define INHNO_SERIAL_IN	 RXI1
#define INHNO_SERIAL_OUT TXI1
#define INHNO_SERIAL_ERROR ERI1
#define INHNO_SERIAL_BRK BRI1
#if TNUM_PORT >= 2
#define INHNO_SERIAL2_IN	 RXI2
#define INHNO_SERIAL2_OUT TXI2
#define INHNO_SERIAL2_ERROR ERI2
#define INHNO_SERIAL2_BRK BRI2
#endif /* TNUM_PORT >= 2 */

#else	/*  GDB_STUB  */

#define INHNO_SERIAL_IN	 RXI2
#define INHNO_SERIAL_OUT TXI2
#define INHNO_SERIAL_ERROR ERI2
#define INHNO_SERIAL_BRK BRI2

#endif	/*  GDB_STUB  */

/*
 * SCIγߥ٥
 * ߥϥɥ̡ϿǤ뤬ߥ٥
 * Ʊ٥ˤǤʤ
 */
#define LEVEL0		0			/*  ߲Υ٥  */

#ifndef _MACRO_ONLY

/*
 *  SIOɥ饤Фν롼
 */
#define	sio_initialize	sh2scif_initialize

/*
 *  ꥢI/OݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;
	BOOL	openflag;

	/*
	 *  ץ󤷤ݡȤ뤫 openflag ɤǤ
	 */
	openflag = sh2scif_openflag (siopid);

	/*
	 *  ǥХ¸Υץ
	 */
	siopcb = sh2scif_opn_por(siopid, exinf);

	/*
	 *  ߥȥ¸
	 *  ꥢI/Oߤγߥ٥ꤹ
	 */
	if (!openflag) {
		if (siopcb->siopinib->reg_base == 0xfffffcc0)
			define_int_plevel (IPRD, siopcb->siopinib->int_level, 0);
		if ((siopcb->siopinib->reg_base) == 0xfffffce0)
			define_int_plevel (IPRE, siopcb->siopinib->int_level, 12);
	}
	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  ǥХ¸Υ
	 */
	sh2scif_cls_por(siopcb);

	/*
	 *  ꥢI/Oߥ٥٥ˤ
	 */
		if (siopcb->siopinib->reg_base == 0xfffffcc0)
			define_int_plevel (IPRD, LEVEL0, 0);
		if ((siopcb->siopinib->reg_base) == 0xfffffce0)
			define_int_plevel (IPRE, LEVEL0, 12);

}

/*
 *  SIO/SCIFγߥϥɥ
 */
#define	sio_handler_in	sh2scif_isr_in	/*  ߥϥɥ  */
#define	sio_handler_out	sh2scif_isr_out	/*  ߥϥɥ  */
#define	sio_handler_error sh2scif_isr_error	/*  顼ߥϥɥ  */
#define	sio_handler_brk	sh2scif_isr_brk	/*  ֥졼гߥϥɥ  */
#if TNUM_PORT >= 2
#define	sio_handler2_in		sh2scif_isr2_in	/*  ߥϥɥ  */
#define	sio_handler2_out	sh2scif_isr2_out	/*  ߥϥɥ  */
#define	sio_handler2_error	sh2scif_isr2_error	/*  顼ߥϥɥ  */
#define	sio_handler2_brk	sh2scif_isr2_brk	/*  ֥졼гߥϥɥ  */
#endif /* TNUM_PORT >= 2 */

/*
 *  ꥢI/OݡȤؤʸ
 */
#define	sio_snd_chr	sh2scif_snd_chr

/*
 *  ꥢI/OݡȤʸ
 */
#define	sio_rcv_chr	sh2scif_rcv_chr

/*
 *  ꥢI/OݡȤΥХåε
 */
#define	sio_ena_cbr	sh2scif_ena_cbr

/*
 *  ꥢI/OݡȤΥХåζػ
 */
#define	sio_dis_cbr	sh2scif_dis_cbr

/*
 *  ꥢI/OݡȤǽХå
 *  jsp/systask/serial.cˤΤ͡षƤ
 *  ʰȡ
 */
#define	sio_ierdy_snd	sh2scif_ierdy_snd

/*
 *  ꥢI/OݡȤμΥХå
 *  jsp/systask/serial.cˤΤ͡षƤ
 *  ʰȡ
 */
#define	sio_ierdy_rcv	sh2scif_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
