/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_defs.h,v 1.7 2004/05/27 08:30:41 honda Exp $
 */

/*
 *  åȥƥ˰¸MS7717CP01ѡ
 *
 *  Υ󥯥롼ɥեϡkernel.h  sil.h ǥ󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤ뤳ȤϤʤΥե򥤥
 *  롼ɤˡt_stddef.h  itron.h 󥯥롼ɤΤǡ
 *  ˰¸Ƥ褤
 */

/*
 *  ƥ˰¸
 */

#ifndef _SYS_DEFS_H_
#define _SYS_DEFS_H_

/*
 *  ưåΥå̾
 */
#define	TARGET_NAME	"MS7727CP01(SH7727 T-Engine)"

/*
 * ץåμ(DSPˤбƤʤ)
 */
#define SH3
#define SH7727

/*
 *  ץåΥǥ
 */
#define SIL_ENDIAN  SIL_ENDIAN_LITTLE  /* ȥ륨ǥ */


/*
 *  JSPͥưΥޥå
 *      0x8c000000 - 0x8c000000 ٥ơ֥
 *      0x8c000500 - 0x8c001fff T-Monitorΰ
 *      0x8c002000 - 0x8cffffff ΰ(1MB)
 *      0x8c100000 -            ǡΰ(3MB)
 *                 - 0x8c3fffff Ωѥå
 *                 - 0x8e000000 꽪λ
 *
 */

/*
 *   åΰ
 */
#define STACKTOP    0x8c400000    /* Ωѥåν */

/*
 *  ƥå
 */
#define	TIC_NUME	1		/* ƥåμʬ */
#define	TIC_DENO	1		/* ƥåμʬ */

/*
 *  ޡγߥ٥
 */
#define KTIM_INT_LV   4

/*
 *  ͤɽ msec ñ̤ȤѴ
 *  MS7727CP01ǤϡPå24MHz
 *  ʬ /4,/16,/64/256 Τ줫
 *  /4:  6Mhz     tick 6000   0.16 sec
 *  /16: 1.5Mhz   tick 1500   0.6 sec
 *  /64: 0.375Mhz tick 375    2.6 sec
 *  /256:0.097Mhz tick 97     10 sec
 *
 *  /16 
 *  TMUΥåξ¤2Mhz
 */

#define TCR0_TPSC  0x0001


/*
 *  ͤɽȥߥñ̤ȤѴ
 */
#define TIMER_CLOCK     1600

/*
 *  ԤΤ
 */
#define	SIL_DLY_TIM1	 90
#define	SIL_DLY_TIM2	 50


#ifndef _MACRO_ONLY


Inline void
kernel_abort()
{
    UW sr = 0x10000000;
    
    /*
     * Ū˥ꥻåȤȯ
     */
    /*
     * BLӥåȤΩƤ
     */
	Asm("ldc %0, sr" : : "r"(sr) );
    
    /*
     * 㳰
     */
    *((volatile int *) 0xFFFFFEC1) = 0;
}
#endif /* _MACRO_ONLY */


#endif /* _SYS_DEFS_H_ */













