/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_serial.h,v 1.4 2003/12/11 00:52:12 honda Exp $
 */

/*
 *  ꥢI/OǥХSIO˥ɥ饤СSolution Engineѡ
 *  ѡI/O(FDC37C935A)Υꥢ1
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>
#include <solution_engine.h>
#include <fdc37c935a.h>

/*
 *  ꥢγߥϥɥΥ٥ֹ(ͥ)
 */
#define INHNO_SIO   UART_IRQ0

/*
 * ߥ٥ϸǤ롥
 */
#define SCI1INTLVL   8

/*
 *  SIOɥ饤Фν롼
 */
#define sio_initialize  smsc_sci0_initialize

#ifndef _MACRO_ONLY

/*
 *  ꥢI/OݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
    SIOPCB  *siopcb;
    BOOL    openflag;

    /*
     *  ץ󤷤ݡȤ뤫 openflg ɤǤ
     */
    openflag = smsc_sci0_openflag();
    
    
    /*
     *  ǥХ¸Υץ
     */
    siopcb = smsc_sci0_opn_por(siopid, exinf);

      
    /*
     * ߴϢ
     * 顼ϥɥϿ٤
     */
    if(!openflag){
        define_int_plevel(INHNO_SIO,SCI1INTLVL);
    }

    return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
    /*
     *  ǥХ¸Υ
     */
    smsc_sci0_cls_por(siopcb);
}


/*
 *  SIOγߥϥɥ
 */
#define sio_handler smsc_sci0_isr

/*
 *  ꥢI/OݡȤؤʸ
 */
#define sio_snd_chr smsc_sci0_snd_chr

/*
 *  ꥢI/OݡȤʸ
 */
#define sio_rcv_chr smsc_sci0_rcv_chr

/*
 *  ꥢI/OݡȤΥХåε
 */
#define sio_ena_cbr smsc_sci0_ena_cbr

/*
 *  ꥢI/OݡȤΥХåζػ
 */
#define sio_dis_cbr smsc_sci0_dis_cbr

/*
 *  ꥢI/OݡȤǽХå
 */
#define sio_ierdy_snd   smsc_sci0_ierdy_snd

/*
 *  ꥢI/OݡȤμΥХå
 */
#define sio_ierdy_rcv   smsc_sci0_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
