/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2002 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005 by Freelines CO.,Ltd 
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_support.S,v 1.4 2007/01/05 02:10:17 honda Exp $
 */

/*
 *	åȥƥ¸⥸塼 ֥TK-850ES/KJ1+ѡ
 */

#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "v850asm.inc"

#define Set(x,y,z) Lea x, r6; Lea y, r7; st.##z r7, 0[r6]

/*
 *  ٥Υåȥƥ¸ν
 *
 *  ȥåץ⥸塼ǡν˸ƤӽФ롥
 */

	.text
	.globl hardware_init_hook
hardware_init_hook:

	/* ƥ०ȥȥ쥸5MHz4=20MHz */
	Set(VSWC,  0x01,   b)
	/* ݸ줿쥸ؤΥ
	   ץååȥ쥸ᥤ󥯥åfxx(PCC=0) */
	lea	PRCMD, r6
	lea	PCC, r7
	st.b	r0, 0[r6]
	st.b	r0, 0[r7]
	nop
	nop
	nop
	nop
	nop
	Set(PLLCTL,0x03,   h)   /* PLLȥ쥸PLLư */
	Set(WDTM2, 0x07,   b)   /* WDTM2 stop */
#if 0
	/* Хꡧ
	     CS0˳SRAMߤλ͡ǤϥХϥѥ졼ȥХǡ
	     12nsʤSRAM0waitư뤳Ȥꤷꡣ
	 */
	Set(EXIMC, 0x01,   b)	/* Х󥿡ե⡼ɥ쥸ѥ졼ȥХ */
	Set(PMC9,  0xFFFF, h)	/* P9⡼ɥȥ쥸A0-A15 */
	Set(PMCCS, 0x01,   b)	/* PCS⡼ɥȥ쥸C0 */
	Set(PMCCT, 0x53,   b)	/* PCT⡼ɥȥ쥸RD/WR/ASTB */
	Set(PMCDH, 0xFF,   b)	/* PDH⡼ɥȥ쥸A16-A23 */
	Set(PMCDL, 0xFFFF, h)	/* PDL⡼ɥȥ쥸AD0-AD15 */
	Set(DWC0,  0x7770, h)	/* ǡ쥸CS0wait=0 */
	Set(AWC,   0xFFFC, h)	/* ɥ쥹쥸CS0wait=0 */
	Set(BCC,   0xAAA8, h)	/* Х쥸CS0wait=0 */
#endif

	jmp		r31



	/* ɸ߽ȥڡ */
	.macro StandardInterruptEntry name
	.globl \name
\name:
	jr	vector_handler
	nop;nop;nop;nop;nop;nop
	.endm

	.macro ReservedInterruptEntry
	nop;nop;nop;nop;nop;nop;nop;nop
	.endm

/*
 * ߥϥɥʬ
 * 		Ȥꤢս˽롣
 */

	.section	".vectors","ax"
	.align      4
	.globl      __reset
__reset:
	jr	start
	nop;nop;nop;nop;nop;nop

	StandardInterruptEntry NMI
	StandardInterruptEntry INTWDT1
	StandardInterruptEntry INTWDT2
	StandardInterruptEntry TRAP0
	StandardInterruptEntry TRAP1
	StandardInterruptEntry DBG
/*#-------------------------------------------------------------------
  #	SECURITY_ID
  #-------------------------------------------------------------------*/
/*	.section	"SECURITY_ID" */
	.word	0xffffffff	/* --0-3 byte code,Address is 0x70-0x73 */
	.word	0xffffffff	/* --4-7 byte code,Address is 0x74-0x77 */
	.hword	0xffff		/* --8-9 byte code,Address is 0x78-0x79 */
/*#-------------------------------------------------------------------
  #	OPTION_BYTES
  #-------------------------------------------------------------------*/
/*	.section	"OPTION_BYTES" */
	.hword	0x0000		/* --0-1 byte code,Address is 0x7a-0x7b */
	.hword	0x0000		/* --2-3 byte code,Address is 0x7c-0x7d */
	.hword	0x0000		/* --4-5 byte code,Address is 0x7e-0x7f */

	StandardInterruptEntry INTWDTM1
	StandardInterruptEntry INTP0
	StandardInterruptEntry INTP1
	StandardInterruptEntry INTP2
	StandardInterruptEntry INTP3
	StandardInterruptEntry INTP4
	StandardInterruptEntry INTP5
	StandardInterruptEntry INTP6
	StandardInterruptEntry INTTM000
	StandardInterruptEntry INTTM001
	StandardInterruptEntry INTTM010
	StandardInterruptEntry INTTM011
	StandardInterruptEntry INTTM50
	StandardInterruptEntry INTTM51
	StandardInterruptEntry INTCSI00
	StandardInterruptEntry INTCSI01
	StandardInterruptEntry INTSRE0
	StandardInterruptEntry INTSR0
	StandardInterruptEntry INTST0
	StandardInterruptEntry INTSRE1
	StandardInterruptEntry INTSR1
	StandardInterruptEntry INTST1
	StandardInterruptEntry INTTMH0
	StandardInterruptEntry INTTMH1
	StandardInterruptEntry INTCSIA0
	StandardInterruptEntry INTIIC0
	StandardInterruptEntry INTAD
	StandardInterruptEntry INTKR
	StandardInterruptEntry INTWTI
	StandardInterruptEntry INTWT
	StandardInterruptEntry INTBRG
	StandardInterruptEntry INTTM020
	StandardInterruptEntry INTTM021
	StandardInterruptEntry INTTM030
	StandardInterruptEntry INTTM031
	StandardInterruptEntry INTCSIA1
	StandardInterruptEntry INTTM040
	StandardInterruptEntry INTTM041
	StandardInterruptEntry INTTM050
	StandardInterruptEntry INTTM051
	StandardInterruptEntry INTCSI02
	StandardInterruptEntry INTSRE2
	StandardInterruptEntry INTSR2
	StandardInterruptEntry INTST2
	StandardInterruptEntry INTIIC1
	ReservedInterruptEntry 
	ReservedInterruptEntry 
	ReservedInterruptEntry 
	ReservedInterruptEntry 
	ReservedInterruptEntry 
	StandardInterruptEntry INTTP0OV
	StandardInterruptEntry INTTP0CC0
	StandardInterruptEntry INTTP0CC1

/*
 * ɾѹǽ?
 *  (ɾѥե꡼˥󥰥ޤ餺ľܥޥ󥿤Τ)
 */
Function _vxget_tim
	Lea	TM00, r7
	ld.h	0[r7], r8
	st.w	r8, 0[r6]
	mov	r0, r10
	jmp	r31
