/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: debugout.c,v 1.10 2003/12/15 07:19:22 takayuki Exp $
 */

#include <debugout.h>
#include <hal_msg.h>
#include <resource.h>

#ifdef DEBUG_ENABLE

#define DBG_SIZE_STRINGBUFFER 512

static HANDLE DebugConsole;     //ǥХåʸɽƥȥܥå
static HWND   DialogHandle;     //ǥХåϥ

extern void FatalAssertion(int exp, LPCSTR format, ... );

/*
 * ǥХåѥΥåϥɥ
 */
static LRESULT CALLBACK DebugOutDialogProc(HWND hDlg,UINT Msg,WPARAM wParam,LPARAM lParam)
{
	switch(Msg)
	{
	case WM_INITDIALOG:
		DebugConsole = GetDlgItem(hDlg,IDC_DEBUGOUT);       //ƥȥܥå
		ShowWindow(hDlg,SW_SHOW);

	case WM_SIZE:
		{
			RECT client;
			GetClientRect(hDlg,&client);
			MoveWindow(DebugConsole,0,0,client.right,client.bottom,TRUE);
			break;
		}

	case WM_CLOSE:
			/* Never let this dialog close by pressing of the close button. */
		break;

	case WM_DESTROY:
		DialogHandle = 0;
		break;

	case WM_QUIT:
		DestroyWindow(hDlg);
		break;
	
	default:
		return FALSE;
	}
	return TRUE;
}

    /* 2ؿꤹ뤿ι¤ */
struct tagInitializeDebugServicesParam {
    HINSTANCE hInstance;
    HWND      hDlg;
};

    /* ǥХå롼Ȥ */
void FinalizeDebugServices(void)
{
    if(DialogHandle != 0l) {
		DestroyWindow(DialogHandle);
    }
}

    /* åɤ¹Ԥ륦ɥ롼 */
static void _initializeDebugServices(void * _param)
{
    struct tagInitializeDebugServicesParam * param = (struct tagInitializeDebugServicesParam *)_param;
    DialogHandle = CreateDialog(param->hInstance, MAKEINTRESOURCE(DEBUGOUTDIALOG), param->hDlg, DebugOutDialogProc);
    FatalAssertion(DialogHandle != NULL, "DebugService could not create its own dialog.");     
}

    /* ǥХå롼ν ʴåɤ˥äƤ餦) */
void InitializeDebugServices(HINSTANCE hinst,HWND dlg)
{
    struct tagInitializeDebugServicesParam param;
    param.hInstance = hinst;
    param.hDlg      = dlg;

    HALExecuteProcedure(_initializeDebugServices, (void *)&param);      //
    HALAddDestructionProcedure(FinalizeDebugServices, 0);               //˴롼Ͽ
}

    /* ǥХåprintf */
int _debugOut(const char * format, ... )
{
	int result;
	int i;
	char buffer[DBG_SIZE_STRINGBUFFER*2];
	char * scope;
	const char * work;
	va_list vl;

	if(format == 0l)
		return 0;

	va_start(vl, format);

		/* format˴ޤޤ '\n'  '\r\n' ִ */
	scope = buffer;
	work  = format;

	while(*format != '\0')
	{
		if(*format == '\n')
		{
			i = format - work;
			lstrcpyn(scope, work, i);
			
			scope += i;
			work = format;

			*(scope++) = '\r';
		}
		format ++;
	}

	i = format - work + 1;
	lstrcpyn(scope, work, i);		//+1'\x0'⥳ԡ
	scope += i;

	if((result = wvsprintf(scope, buffer, vl)) > 0)
	{
			//Ϥ龯å
		i = GetWindowTextLength(DebugConsole);
		if(i > DEBUG_LIMITTERUPPERBOUND)
		{
			SendMessage(DebugConsole, EM_SETSEL, 0, i - DEBUG_LIMITTERUPPERBOUND);
			SendMessage(DebugConsole, EM_REPLACESEL, (WPARAM)FALSE, (LPARAM)"");
		}

		SendMessage(DebugConsole,EM_SETSEL,i,i);
		SendMessage(DebugConsole,EM_REPLACESEL,(WPARAM)FALSE,(LPARAM)scope);
	}

	return result;
}

#endif


