/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: fdc37c935a.h,v 1.1 2003/12/11 06:47:39 honda Exp $
 */

/*
 * I/O FDC37C935A ѥɥ饤
 */
#ifndef _FDC37C935A_H_
#define _FDC37C935A_H_

#include <t_config.h>

/*
 * ١ɥ쥹 
 */
//#define SMSC_BASE_ADDR 0xB0400000

#define SMSC_CONFIG_PORT (SMSC_BASE_ADDR + 0x7E0)  /* H */
#define SMSC_INDEX_PORT  (SMSC_BASE_ADDR + 0x7E0)  /* H */
#define SMSC_DATA_PORT   (SMSC_BASE_ADDR + 0x7E2)  /* H */


#ifndef _MACRO_ONLY

Inline void
smsc_config_write(UH index, UH data)
{
    sil_wrh_mem((VP)SMSC_INDEX_PORT, (index << 8));
    sil_wrh_mem((VP)SMSC_DATA_PORT, (data << 8));
}

Inline UH
smsc_config_read(UH index)
{
    sil_wrh_mem((VP)SMSC_INDEX_PORT, (index << 8));
    return(sil_reh_mem((VP)SMSC_DATA_PORT) >> 8);
}

/*
 *  
 */
extern void smsc_init(void);



#endif /*  _MACRO_ONLY */


/*
 * SCI0
 */
#define SMSC_SCI0_BASE_ADDR  0x03f8

#define SMSC_SCI0_RBR (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0x0)  /* H */
#define SMSC_SCI0_THR (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0x0)  /* H */
#define SMSC_SCI0_DLL (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0x0)  /* H */
#define SMSC_SCI0_IER (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0x2)  /* H */
#define SMSC_SCI0_DLM (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0x2)  /* H */
#define SMSC_SCI0_IIR (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0x4)  /* H */
#define SMSC_SCI0_FCR (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0x4)  /* H */
#define SMSC_SCI0_LCR (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0x6)  /* H */
#define SMSC_SCI0_MCR (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0x8)  /* H */
#define SMSC_SCI0_LSR (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0xA)  /* H */
#define SMSC_SCI0_MSR (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0xC)  /* H */
#define SMSC_SCI0_SCR (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0xE)  /* H */

/*
 *  ѡI/O(FDC37C935A) ʰSIOɥ饤
 */

#ifndef _MACRO_ONLY

/*
 *  ߰ʳν
 *  ͥ뵯ưѤν(sys_putcѤ뤿)
 */
extern void fdc37c935a_init(void);


/*
 *  ꥢI/Oݡȴ֥å
 */
typedef struct sio_port_control_block   SIOPCB;

/*
 *  Хå롼μֹ
 */
#define SIO_ERDY_SND    1u      /* ǽХå */
#define SIO_ERDY_RCV    2u      /* ΥХå */


/*
 *  SIOɥ饤Фν롼
 */
extern void smsc_sci0_initialize(void);


/*
 *  ץ󤷤ƤݡȤ뤫
 */
extern BOOL smsc_sci0_openflag(void);


/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB   *smsc_sci0_opn_por(ID siopid, VP_INT exinf);


/*
 *  ꥢI/OݡȤΥ
 */
extern void smsc_sci0_cls_por(SIOPCB *siopcb);


/*
 *  ꥢI/OݡȤؤʸ
 */
extern BOOL smsc_sci0_snd_chr(SIOPCB *siopcb, char c);


/*
 *  ꥢI/OݡȤʸ
 */
extern INT  smsc_sci0_rcv_chr(SIOPCB *siopcb);


/*
 *  ꥢI/OݡȤΥХåε
 */
extern void smsc_sci0_ena_cbr(SIOPCB *siopcb, UINT cbrtn);


/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void smsc_sci0_dis_cbr(SIOPCB *siopcb, UINT cbrtn);


/*
 *  SIOγߥӥ롼
 */
extern void smsc_sci0_isr(void);


/*
 *  ꥢI/OݡȤǽХå
 */
extern void smsc_sci0_ierdy_snd(VP_INT exinf);


/*
 *  ꥢI/OݡȤμΥХå
 */
extern void smsc_sci0_ierdy_rcv(VP_INT exinf);




#endif /* _MACRO_ONLY */


#endif /* _FDC37C935A_H_ */
