/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003      by Advanced Data Controls, Corp
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *                2009 by Suikan
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 */

/*
 *    åȥƥ¸⥸塼CQ-FRK-NXP-ARM
 */

#include "jsp_kernel.h"
#include <lpc2388.h>



/*
 * OSCν(ƥͭ). 4MHz 졼Ȥ
 */
static void
init_clock()
{
	/* 1. ⤷PLLѤƤʤ顢ǥͥȤեɡ󥹤Ƨ */
	PLLCON &= 0xFFFFFFFD;	/* Clear bit 1, PLL bypassed */
	PLLFEED = 0xAA;
	PLLFEED = 0x55;

	/* 2. PLLǥ֥뤷եɡ󥹤Ƨࡣ */
	PLLCON = 0;		/* Disable PLL */
	PLLFEED = 0xAA;
	PLLFEED = 0x55;

	/* 3. CPUåǥХPLLʤǤ٤ʤꤹʤ褦ꤹ롣 */
	CCLKCFG = 0;	/* CCLK = PCLK / 1 */

	/* 4. PLLΥåѹ롣 */
	CLKSRCSEL = 0;	/* Select 4MHz internal oscillator*/
//	CLKSRCSEL = 1;	/* Select 12MHz main oscillator*/

	/* 5. PLLCFGؤν񤭹ߤԤեɡ󥹤Ƨͭ롣
	 * PLLCFGϡPLLǥ֥ΤȤˤѹǤ롣 */
	PLLCFG = 35;	/* Divide by 1, Multiply by 72, PCLK = 4*72 = 288MHz */
//	PLLCFG = 11;	/* Divide by 1, Multiply by 24, PCLK = 12*24 = 288MHz */
	PLLFEED = 0xAA;
	PLLFEED = 0x55;

	/* 6. PLL򥤥֥͡ˤեɡ󥹤Ƨ. */
	PLLCON = 1;		/* Enable PLL */
	PLLFEED = 0xAA;
	PLLFEED = 0x55;

	/* 7. CPUåǥХͤPLLưѤѹ롣
	 * ɬPLL򥯥åȤ³˹Ԥ */
	CCLKCFG = 3;	/* CCLK = PCLK/4 = 288/4 = 72MHz */

	/* 8. PLLSTAT쥸PLOCK bitĴ٤ơPLLåޤԤġ
	 * 뤤PLOCKߤѤƤ⤤뤤ϡPLLϥå(32kHzʤ)ʤ顢
	 * ñ˥ȡ롼פ󤷤Ƥ⤤*/
	while ( !(PLLSTAT & (1<<26)))
		;

	/* 9. PLL򥷥ƥ³եɥ󥹤¹Ԥ */
	PLLCON = 3;		/* Select PLL as CPU clock source */
	PLLFEED = 0xAA;
	PLLFEED = 0x55;
}




/*
 *  åȥƥ¸ν
 */
void
sys_initialize()
{
    int i;

    init_vector();			/* SRAMΥޥåסLPC2388 */

    init_clock();			/* PLLꡣƥͭ */

    init_uart0();			/* UART0νƥͭ */

    init_IRQ();				/* VIC롣LPC2388 */

    		/* ɬפʥڥեŸ(ƥͭ) */
			/* ʤUART0TIMER3LPC2388̤ɬ */
	PCONP |= 0x00800008;	/* bit3:UART0, bit23:TIMER3 */

			/* UART0Υԥ (LPC2388) */
	PINSEL0 &= ~0xF0;			/* bit 4-7򥯥ꥢ */
	PINSEL0 |= 0x50;			/* UARTϤ */

    /*
     *  ARMΥ٥ơ֥سߥϥɥϿʤɤARMv4ƥǤ׵ᤵ
     */
    arm_install_handler(IRQ_Number,IRQ_Handler);

}





