/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id$
 */

#define _MACRO_ONLY
#include "jsp_kernel.h"
#include <ezarm7.h>
        




/*
 *
 *  ݂̏o
 *         
 */        
        .text
        .align 4    
        .global IRQ_Handler
IRQ_Handler:

        /* 
         * ݃[h 
         * 
         * cpsrspsr_irqɕA悪r14_irq(lp)ɓC
         * spsr_irqr14_irqr13(sp)_irq r14,r13ƂȂD
         */

        /* 
         *  ^XN̓쎞[h(X[p[oCU[[h)
         */
	mov   sp,#(CPSR_SVC | CPSR_FIQ_BIT | CPSR_IRQ_BIT) 
        msr   cpsr_all, sp
        stmfd sp!, {r0-r3,ip,lr,pc} /* pc̓_~[ */


  
        /*
         * spsrƖ߂Ԓn擾邽߂IRQ[h
         */
	mov   r0,#(CPSR_IRQ | CPSR_FIQ_BIT | CPSR_IRQ_BIT)
        msr   cpsr,r0
        sub   r0,lr,#4
        mrs   r1,spsr
   
        /*
         *  X[p[oCU[[h
         */
        msr   cpsr_all, sp
        str   r0, [sp,#0x18] /* Store pc */
        stmfd sp!,{r1}       /* spsr */


        /*
         *  d荞݂
         */
        ldr     r2, =interrupt_count
        ldr     r3, [r2]
        add     r0,r3,#1
        str     r0, [r2]
        cmp     r3, #0x00

	moveq   r2,sp            /* lXg荞݂łȂꍇ */
        ldreq   sp,=STACKTOP     /* X^bN̕ύX    */
        stmeqfd sp!,{r2}         /* ^XNX^bN̕ۑ */

	
	/*
         *  ݃nhAhX擾Ƃ̕ۑ
         */
	ldr	r2, vic_vect_addr
	ldr	r0, [r2]
	ldr	r2, =handler_address
	str	r0, [r2]
	
	/* 
         * 荞݋ 
         */                
        mov     r2,#(CPSR_SVC|CPSR_FIQ_BIT)
        msr     cpsr,r2

        /* 
         * Call Handler  
         */
	mov     lr, pc
        mov     pc, r0

        /* 
         * 荞݋֎~ 
         */
        mov     r2,#(CPSR_SVC|CPSR_FIQ_BIT|CPSR_IRQ_BIT) 
        msr     cpsr,r2

	/*
         *  EOIs
         */
	ldr	r2, =handler_address
	ldr	r0, [r2]
	ldr	r2, vic_vect_addr
	str	r0, [r2]

	/* 
         * ݃lXg(interrupt_count) fNg 
         */
        ldr     r2, =interrupt_count
        ldr     r1, [r2]        
        sub     r3, r1, #1                        
        str     r3, [r2]
        cmp     r3, #0x00        
        bne     return_to_task_irq
        
        /* 
         * ^XNX^bN̕A 
         */
        ldmfd   sp!,{r0}         
        mov     sp, r0        
                
        ldr     r1, =reqflg    /* Check reqflg */
        ldr     r0, [r1]
        cmp     r0, #0
        beq     return_to_task_irq
        mov     r0, #0
        str     r0, [r1]       /* Clear reqflg */
        b       ret_int

return_to_task_irq:
        /*
         *  A
         *  荞݋ƂȂ邪^XNReLXgɕۑĂ邽߁C
         *  ͂Ȃ
         */
        ldmfd   sp!,{r1}           /* CPSR̕A */
        msr     spsr, r1           /* 荞݋   */
        ldmfd   sp!,{r0-r3,ip,lr,pc}^ /*^XNA + ݋ */

        /*
         *  `݂̊ƂɌĂяo
         */    
undefined_interrupt:
         b      undef_interrupt
    
vic_int_enable:
	.long	0xfffff010
vic_inten_clear:
	.long	0xfffff014
vic_vect_addr:
	.long	0xfffff030
vic_vect_def_addr:
	.long	0xfffff034
vic_vect_addr_15:
	.long	0xfffff13c

	.section .bss
handler_address:
	.long	0
