/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 *  Copyright (C) 2007 by KURUSUGAWA Electronics Industry Inc, JAPAN
 *  Copyright (C) 2008 by Takahisa Yokota
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: mcfuart.c,v 1.3 2005/07/06 00:45:07 honda Exp $
 */

/*
 *   COLDFIRE¢UART ʰץɥ饤
 */

#include <s_services.h>
#include "mcfuart.h"

/*
 *  ꥢI/Oݡȴ֥å
 */
/* ϥݡȤsys_config.c */
/* ߥ٥ֹhw_serial.h */
/* ֥åmcfuart.c */

#ifndef GDB_STUB

const SIOPINIB siopinib_table[TNUM_PORT] = {
	{IPSBAR + 0x00000200, BRR9600, 0x0, 0x27}, /* UART0 */
#if TNUM_PORT >= 2
	{IPSBAR + 0x00000240, BRR9600, 0x0, 0x27}, /* UART1 */
#endif /* TNUM_PORT >= 2 */
};

#else /* GDB_STUB */

const SIOPINIB siopinib_table[TNUM_PORT] = {
	{IPSBAR + 0x00000200, BRR9600, 0x0, 6}, /* SCIF2 */
};

#endif /* GDB_STUB */

#if defined(TTM)
/*
 *  ꥢI/Oݡȴ֥å
 *  2chݡȤ˳ĥϽѤΥǡޤ
 */
struct sio_port_control_block
{
	VP_INT exinf;				/* ĥ */
	BOOL openflag;				/* ץѤߥե饰 */
};
#endif
/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 */
static SIOPCB siopcb_table[TNUM_PORT];

/*
 *  ꥢI/OݡID֥åФΥޥ
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  ʸǤ뤫
 */
Inline BOOL
mcfuart_getready (SIOPCB * siopcb)
{
  return (sil_reb_mem((VB *) (siopcb->siopinib->reg_base + MCF_UART_USR)) & MCF_UART_USR_RXRDY);
}

/*
 *  ʸǤ뤫
 */
Inline BOOL
mcfuart_putready (SIOPCB * siopcb)
{
  /* Wait until space is available in the FIFO */
  return (sil_reb_mem((VB*)(siopcb->siopinib->reg_base + MCF_UART_USR)) & MCF_UART_USR_TXRDY);
}

/*
 *  ʸμФ
 */
Inline char
mcfuart_getchar (SIOPCB * siopcb)
{
	VB data;
        data = sil_reb_mem ((VB*)(siopcb->siopinib->reg_base + MCF_UART_URB));
	return data;
}

/*
 *  ʸν
 */
Inline void
mcfuart_putchar (SIOPCB * siopcb, char c)
{
    /* Send the character */
    sil_wrb_mem ((VB*)(siopcb->siopinib->reg_base + MCF_UART_UTB), c);
}

/*
 *  SIOɥ饤Фν롼
 */
void
mcfuart_initialize ()
{
	SIOPCB *siopcb;
	UINT i;
        /*
	 *  륢I/Oݡȴ֥åν
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_PORT; siopcb++, i++) {
		siopcb->openflag = FALSE;
		siopcb->siopinib = (&siopinib_table[i]);
	}
}

/*
 *  ץ󤷤ƤݡȤ뤫
 */
BOOL
mcfuart_openflag (ID siopid)
{
	return (siopcb_table[siopid -1].openflag);
}

/*
 *  ꥢI/OݡȤΥץ
 */
SIOPCB *
mcfuart_opn_por (ID siopid, VP_INT exinf)
{
        volatile int i;
	SIOPCB *siopcb = get_siopcb(siopid);
        // 
  	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + MCF_UART_UCR), (VB) (MCF_UART_UCR_MISC_RR));
    	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + MCF_UART_UCR), (VB) (MCF_UART_UCR_MISC_RT));
      	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + MCF_UART_UCR), (VB) (MCF_UART_UCR_MISC_RRC));

        sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + MCF_UART_UMR1), 0x93);
        sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + MCF_UART_UMR2), 0x07);
        sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + MCF_UART_UCSR), 0xDD);

        sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + MCF_UART_UBG1), (VB) (siopcb->siopinib->brr >> 8));
    	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + MCF_UART_UBG2), (VB) (siopcb->siopinib->brr & 0x00ff));

         /*  ߵ  */
        siopcb->imr = (VB)MCF_UART_UIMR_RXRDY;
    	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + MCF_UART_UIMR), (VB) (siopcb->imr));

        /*    */
  	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + MCF_UART_UCR), (VB) (MCF_UART_UCR_TC_EN | MCF_UART_UCR_RC_EN));

	siopcb->exinf = exinf;
        siopcb->openflag = TRUE;
        if (siopcb->siopinib->reg_base == (IPSBAR + 0x00000200)) {  
          sil_wrw_mem ((VW*)MCF_INTC_IMRL(MCF_INTC0), sil_rew_mem((VW*)MCF_INTC_IMRL(MCF_INTC0)) & (~(1 << (TBIT_GP0))));
        } else if (siopcb->siopinib->reg_base == (IPSBAR + 0x00000240)) {
          sil_wrw_mem ((VW*)MCF_INTC_IMRL(MCF_INTC0), sil_rew_mem((VW*)MCF_INTC_IMRL(MCF_INTC0)) & (~(1 << (TBIT_GP1))));
        }
        for (i = 0; i < 1000;i++);
	return (siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
void
mcfuart_cls_por (SIOPCB * siopcb)
{
	/*  ػ  */
  	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + MCF_UART_UCSR),
				 (VB) (MCF_UART_UCR_TC_DIS | MCF_UART_UCR_RC_DIS));
	/*  ߶ػ  */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + MCF_UART_UIMR), 0);
        if (siopcb->siopinib->reg_base == (IPSBAR + 0x00000200)) {    
          sil_wrw_mem (MCF_INTC_IMRL(MCF_INTC0), sil_rew_mem(MCF_INTC_IMRL(MCF_INTC0)) | (1 << TBIT_GP0));
        }  else if (siopcb->siopinib->reg_base == (IPSBAR + 0x00000240)) {
          sil_wrw_mem (MCF_INTC_IMRL(MCF_INTC0), sil_rew_mem(MCF_INTC_IMRL(MCF_INTC0)) | (1 << TBIT_GP1));
        }
	siopcb->openflag = FALSE;
}

/*
 *  ꥢI/OݡȤؤʸ
 */
BOOL
mcfuart_snd_chr (SIOPCB * siopcb, char c)
{
	if (mcfuart_putready (siopcb)) {
		mcfuart_putchar (siopcb, c);
		return (TRUE);
	}
	return (FALSE);
}

/*
 *  ꥢI/OݡȤʸ
 */
INT
mcfuart_rcv_chr (SIOPCB * siopcb)
{
	if (mcfuart_getready (siopcb)) {
		return ((INT) (UB) mcfuart_getchar (siopcb));
	}
	return (-1);
}

/*
 *  ꥢI/OݡȤΥХåε
 */
void
mcfuart_ena_cbr (SIOPCB * siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:			/* ׵ */
                siopcb->imr |= MCF_UART_UIMR_TXRDY;
		break;
	case SIO_ERDY_RCV:			/* ׵ */
                siopcb->imr |= MCF_UART_UIMR_RXRDY;
		break;
	}
        sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + MCF_UART_UIMR), siopcb->imr);
}

/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
mcfuart_dis_cbr (SIOPCB * siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:			/* ׵ػ */
                siopcb->imr &= ~MCF_UART_UIMR_TXRDY;
		break;
	case SIO_ERDY_RCV:			/* ׵ػ */
                siopcb->imr &= ~MCF_UART_UIMR_RXRDY;
		break;
	}
        sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + MCF_UART_UIMR), siopcb->imr);
}

/*
 * ݡ󥰤ˤʸ
 */
void
mcfuart_putc_pol (ID portid, char c)
{
	while (!mcfuart_putready (&siopcb_table[portid - 1]));
	mcfuart_putchar (&siopcb_table[portid - 1], c);
}

/*
 *  ꥢI/OݡȤФ߽
 */
Inline void
mcfuart_isr_siop (SIOPCB * siopcb)
{
	VB uisr = sil_reb_mem ((VB *) (siopcb->siopinib->reg_base + MCF_UART_UISR));
        uisr &= siopcb->imr;
	if ((uisr & MCF_UART_UISR_TXRDY) && mcfuart_putready (siopcb)) {
		/*
		 *  ΥХå롼ƤӽФ
		 */
		mcfuart_ierdy_snd (siopcb->exinf);
	}
	else if ((uisr & MCF_UART_UISR_RXRDY) && mcfuart_getready (siopcb)) {
		/*
		 *  ΥХå롼ƤӽФ
		 */
		mcfuart_ierdy_rcv (siopcb->exinf);
        }
}

/* ߸ */
void
mcfuart_isr (void)
{
  if (siopcb_table[0].openflag) {
    mcfuart_isr_siop (get_siopcb (1));
  }
}

#if TNUM_PORT >= 2
/* ߸ */
void
mcfuart_isr2 (void)
{

  if (siopcb_table[1].openflag) {
    mcfuart_isr_siop (get_siopcb (2));
  }
}
#endif
