/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2010 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Katsuhiro Amano
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.c,v 1.18 2007/03/23 07:22:15 honda Exp $
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"

#include <hw_serial.h>

/*
 *  ץå¸⥸塼H8ѡ
 */

#ifdef SUPPORT_CHG_IPM
/*
 *  ƥȤǤγߥޥ
 */
volatile UB task_intmask = 0;
#endif /* SUPPORT_CHG_IPM */

/*
 *  󥿥ƥȤǤγߥޥ
 */

volatile UB int_intmask = 0;

/*
 *  ߥͥȥ
 */

volatile UB intnest = 0;

/*
 *  CPUå֤ɽե饰
 *TRUE CPUå
 *FALSECPUå
 */
volatile BOOL iscpulocked = TRUE;

/*
 *  ޤΥץ饤ƥ٥ѤΥǡ
 *      hw_timer.h˵Ҥ٤
 *      hw_timer.h򥤥󥯥롼ɤեǤ٤Ƽβ
 *ΰͭƤޤᡢΤϤ˵Ҥ롣
 */
const IRC TIMER_IRC = {(UB*)SYSTEM_TIMER_IPR,
                        SYSTEM_TIMER_IP_BIT,
                        SYSTEM_TIMER_IPM
                      };

/*
 *  ٥ơ֥νfor RedBoot
 */
#ifdef REDBOOT

/*  VECTOR_TABLE_ADDRsys_config.h  */
extern void	vector(void);

static void
copy_vector_table(void)
{
	UW n;
	UW *dst = (UW *)VECTOR_TABLE_ADDR;	/* ٥ơ֥륳ԡ */
	UW *src = (UW *)vector;			/* ٥ơ֥륳ԡ */
	TMP_VECTOR tmp_vector;

	load_vector(&tmp_vector);
	for (n = 0; n < VECTOR_SIZE; n++) {
		*dst = JMP_OPECODE | (*src);	/* jmp̿ղ */
		++dst;
		++src;
	}
	save_vector(&tmp_vector);
}
#endif	/* of #ifdef REDBOOT */

/*
 *  ץå¸ν
 */

#ifndef H8IPRA_INI
#define H8IPRA_INI	0
#endif  /*  H8IPRA_INI  */

#ifndef H8IPRB_INI
#define H8IPRB_INI	0
#endif  /*  H8IPRB_INI  */

void
cpu_initialize(void)
{
	/* 
	 *CCR UIӥåȤߥޥӥåȤȤƻѤ롣
	 *SYSCR.UE0
	 */
	bitclr((UB*)H8SYSCR, H8SYSCR_UE_BIT);
	
	/* 
	 *٤Ƥγߥץ饤ƥ٥룰ˤ
	 *
	 *˥䥹֤ߤѤ
	 *H8IPRA_INIH8IPRB_INIơƤݻ롣
	 *IER쥸ϥͥ¦ѹƤʤΤǡΤޤޤ
	 *褤
	 */
	sil_wrb_mem((VP)H8IPRA, H8IPRA_INI);
	sil_wrb_mem((VP)H8IPRB, H8IPRB_INI);
	
	SCI_initialize(SYSTEM_PORTID);

#ifdef REDBOOT
	copy_vector_table();
#endif	/* of #ifdef REDBOOT */
}

/*
 *  ץå¸νλ
 */

void
cpu_terminate(void)
{
}

#ifdef SUPPORT_CHG_IPM
/*
 *  ߥޥѹ
 *
 *IPMǤͤȤIPM_LEVEL0IPM_LEVEL1IPM_LEVEL2ޥ
 *Ƥ롣
 *
 *
 *IPM_LEVEL0٥룰٤Ƥγߤդ
 *IPM_LEVEL1٥룱NMIӥץ饤ƥ٥룱γߤΤߤ
 *դ
 *IPM_LEVEL2٥룲NMIʳγߤդʤ
 *
 *  IPM ٥0ʳλˤ⡤ǥѥåαʤIPM ϡ
 *  ǥѥåˤäơ¹Ծ֤ˤʤäذѤ
 *  롥Τᡤ¹ˡ̤Υˤä IPM ѹ
 *  礬롥JSPͥǤϡIPM ѹϥ㳰롼
 *  ˤäƤⵯΤǡ̤Υˤä IPM ѹ뤳Ȥ
 *  äơ񤷤ʤϾʤȻפ롥IPM ͤˤäƥ
 *  ǥѥåػߤˤϡdis_dsp ʻѤФ褤
 */
SYSCALL ER
chg_ipm(IPM ipm)
{
        ER      ercd = E_OK;

        LOG_CHG_IPM_ENTER(ipm);
        CHECK_TSKCTX_UNL();
        CHECK_PAR( (ipm == IPM_LEVEL0) || (ipm == IPM_LEVEL1) || (ipm == IPM_LEVEL2) );

        t_lock_cpu();
        task_intmask = ipm;
        t_unlock_cpu();
        
    exit:
        LOG_CHG_IPM_LEAVE(ercd)
        return(ercd);
}

/*
 *  ߥޥλ
 */
SYSCALL ER
get_ipm(IPM *p_ipm)
{
        ER      ercd = E_OK;

        LOG_GET_IPM_ENTER(p_ipm);
        CHECK_TSKCTX_UNL();

        t_lock_cpu();
        *p_ipm = task_intmask;
        t_unlock_cpu();

    exit:
        LOG_GET_IPM_LEAVE(ercd, *p_ipm);
        return(ercd);
}

#endif /* SUPPORT_CHG_IPM */

/*****ʲȤΥ󥿡ե˴ޤޤʤʬ*********/

/*
 * ̤ȯΥ顼
 * ϿƤʤߤȯȸƤӽФ
 * 
 * å¤
 * +0:er0
 * +4:er1
 * +8:er2
 *+12:er3
 *+16:er4
 *+20:er5
 *+24:er6
 *+28:crr
 *+29:pc
 *+32:˻ѤƤåΰ
 */

/*
 * ȯľΥåݥ󥿤ޤǤΥեå
 */
#define OFFSET_SP	32u

void cpu_experr(EXCSTACK *sp)
{
    UW sp2, pc, ccr, tmp;
    
    sp2 = (UW)sp + OFFSET_SP;
    tmp = sp->pc;
    ccr = (tmp >> 24u) & 0xffu;	/*  1Х  */
    pc = tmp & 0x00ffffffu;	/*  3Х  */
    
    syslog(LOG_EMERG, "Unexpected interrupt.");
    syslog(LOG_EMERG, "PC  = 0x%08x SP  = 0x%08x CCR  = 0x%02x",
                       pc, sp2, ccr);
    syslog(LOG_EMERG, "ER0 = 0x%08x ER1 = 0x%08x ER2 = 0x%08x ER3 = 0x%08x",
                       sp->er0, sp->er1, sp->er2, sp->er3);
    syslog(LOG_EMERG, "ER4 = 0x%08x ER5 = 0x%08x ER6 = 0x%08x",
                       sp->er4, sp->er5, sp->er6);
    while(1)
    	;
}


/*
 *   HEWI/Oߥ졼
 *   ׸Ƥɥ쥹˰¸24ӥåȥɥ쥹ꤷƼ
 */
#ifdef HEW_SIMULATOR

/*  ǽɡ2Хȡ  */
#define GETC	0x0111
#define PUTC	0x0112

/*  HEWI/Oߥ졼ǽƤӽФ  */
void hew_io_sim(UH code, void *adr);

void hew_io_sim_putc(char c)
{
	UB buf = (UB)c;			/*  Хåե  */
	UB *parmblk = &buf;		/*  ѥ᡼֥å  */
	UB **p = &parmblk;		/*  Ƭɥ쥹  */
	UH code = PUTC;			/*  ǽ  */
	
	hew_io_sim(code, p);
}

extern BOOL hew_io_sim_snd_chr(char c);

BOOL hew_io_sim_snd_chr(char c)
{
	hew_io_sim_putc(c);
	return TRUE;
}

extern INT hew_io_sim_rcv_chr(void);

INT hew_io_sim_rcv_chr(void) {
	UB buf;					/*  Хåե  */
	UB *parmblk = &buf;		/*  ѥ᡼֥å  */
	UB **p = &parmblk;		/*  Ƭɥ쥹  */
	UH code = GETC;			/*  ǽ  */
	
	hew_io_sim(code, p);
	return(buf);
}

#endif /* HEW_SIMULATOR */

/*
 *   ƥʸλ
 */
#ifdef HEW_SIMULATOR
#define CPU_PUT_CHAR(c) hew_io_sim_putc(c)

#else	/* HEW_SIMULATOR */
#define CPU_PUT_CHAR(c) SCI_wait_putchar(SYSTEM_SCI, c)

#endif	/* HEW_SIMULATOR */

void
cpu_putc(char c)
{
    if (c == '\n') {
        CPU_PUT_CHAR('\r');
    }
    CPU_PUT_CHAR(c);
}

/*
 *  local_memcpy
 *
 *    ɸ C 饤֥ memcpy Ʊॳԡؿ
 *    󥯻˥顼ȯ뤿ᡢ̾ѤƤ롣
 *    ޤ󥯥ץȤκǸιԤ
 *
 *       PROVIDE(_memcpy = _local_memcpy);
 *
 *    ɲä
 *
 *    eepmov.w̿ȤΨŪǡžϡĹ֡
 *    ߶ػߤˤʤäƤޤΤǡѤƤʤ
 */

void *
local_memcpy (void *out, const void *in, size_t n)
{
    char *o = out;
    const char *i = in;

    while (n > 0) {
        *o = *i;
        ++o;
        ++i;
        --n;
    }
    return out;
}

