/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

/*
 *  ץå¸⥸塼(H8S)
 *
 *  Υ󥯥롼ɥեϡt_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */
#include <cpu_rename.h>

/*
 *  ץåϢ
 */
#include <h8s.h>
#include <h8s_sil.h>

/*
 *  ǽʥͥκǹĳߥӥåȥѥ
 *  (ƥɥ쥸;cpu_insn.h ѤΤǡ롣)
 */
#ifndef GDB_STUB
#define  MAX_IPM	7	/* = EXR_I2|EXR_I1|EXR_I0 (ǹ٥) */
#else  /* GDB_STUB */
#define  MAX_IPM	6	/* ٥룷γߤϡGDB_STUB Ѥ */
#endif /* GDB_STUB */

#define  str_MAX_IPM	TO_STRING(MAX_IPM)
			/* INTHDR_ENTRYޥ (cpu_config.h) */

/*
 *  ץåü̿Υ饤ؿ
 *    ǡMAX_IPMѤƤΤǡɤ߹
 */
#include <cpu_insn.h>

/*
 *  chg_ipm/get_ipm 򥵥ݡȤ뤫ɤ
 */
#define	SUPPORT_CHG_IPM

/*
 *  ƥȥ֥å
 */
#ifndef _MACRO_ONLY

typedef struct task_context_block {
	VP	sp;		/* åݥ */
	FP	pc;		/* ץ५ */
} CTXB;

#endif /* _MACRO_ONLY */

/*
 *  ƥֻ
 */
#ifndef _MACRO_ONLY

/*
 *  ߥͥȥ
 *    ͥȥ󥿤ͤǥƥȤȽǤԤΤǡƥȻȻ
 *    Ѥ롣
 */

extern UW	intnest;

/*
 *  ƥȻ
 *    ߥͥȥ󥿤ɤ߽Фľ˳ߤȯƤ⡢äȤˤ
 *    ƥȤ⸵äƤ
 */

Inline BOOL
sense_context(void)
{
	return( intnest > 0 );
}

Inline BOOL
sense_lock(void)
{
	return( current_intmask() == MAX_IPM );
}

#endif /* _MACRO_ONLY */

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

#ifndef _MACRO_ONLY

/*
 *  CPUåȤβʥƥѡ
 *
 *  task_intmask ϡchg_ipm 򥵥ݡȤ뤿ѿchg_ipm 򥵥ݡ
 *  ʤˤϡt_unlock_cpu  task_intmask  0 ֤Ƥ褤
 */

#ifdef SUPPORT_CHG_IPM
extern IPM	task_intmask;	/* ƥȤǤγߥޥ */
#endif /* SUPPORT_CHG_IPM */

Inline void
t_lock_cpu(void)
{
	disint();		/* cpu_insn.h */
}

Inline void
t_unlock_cpu(void)
{
#ifdef SUPPORT_CHG_IPM
	/*
	 *  t_unlock_cpu ƤӽФΤ CPUå֤ΤߤǤ뤿ᡣ
	 *   task_intmask 񤭴뤳ȤϤʤ
	 */
	set_intmask(task_intmask);
#else /* SUPPORT_CHG_IPM */
	enaint();		/* cpu_insn.h */
#endif /* SUPPORT_CHG_IPM */
}

/*
 *  CPUåȤβ󥿥ƥѡ
 */

extern IPM	int_intmask;	/* 󥿥ƥȤǤγߥޥ */

Inline void
i_lock_cpu(void)
{
	IPM	intmask;

	/*
	 *  ѿ intmask ȤäƤΤϡcurrent_intmask()Ƥľ
	 *  ߤȯư줿ߥϥɥ int_intmask ѹ
	 *  ǽ뤿Ǥ롣
	 */
	intmask = current_intmask();
	disint();		/* cpu_insn.h */
	int_intmask = intmask;
}

Inline void
i_unlock_cpu(void)
{
	set_intmask(int_intmask);
}

/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥåcpu_support.S
 *    dispatch ϡƥȤƤӽФ줿ӥǡ
 *    CPUå֤ǸƤӽФʤФʤʤ
 */
extern void	dispatch(void);

/*
 *  ߤΥƥȤΤƤƥǥѥåcpu_support.S
 *    exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	exit_and_dispatch(void);

/*
 *  ߥϥɥ
 *    H8SǤϡߥϥɥơ֥ROMľܹԤѤʤ
 */

Inline void define_inh(INHNO inhno, FP inthdr) {
}

/*
 *  CPU㳰ϥɥ
 *    H8SǤϡߥϥɥơ֥ROMľܹԤѤʤ
 */

Inline void define_exc(EXCNO excno, FP exchdr) {
}

#endif /* _MACRO_ONLY */

/*
 *  ߥϥɥν
 */

/*
 *  ߥϥɥ
 *    νޤǤˡϡɥˤơߥ٥ޤǤγߤ
 *    ػߤԤƤ롣
 *    entryΥ٥
 *    inthdrC롼Ƭɥ쥹
 */
#define	_INTHDR_ENTRY(entry, inthdr)		    \
asm("	.text					\n" \
"	.align 2				\n" \
"	.global _"#entry"			\n" \
"						\n" \
"_"#entry":					\n" \
"	push.l	er0				\n" \
			/* CPUåɬפʥ쥸򥿥å */ \
"	stc.b	exr, r0l			\n" \
			/* exr  r0l (er0) ˥ԡ \
"			  (_kernel_ret_main ǡ߶ػߵ˻Ȥ) */ \
"						\n" \
"	ldc.b	#"str_MAX_IPM", exr		\n" \
			/* lock_cpu  (߶ػ) */ \
"						\n" \
"	push.l	er1				\n" \
			/* er1 򥿥å */ \
"	mov.l	#_"#inthdr", er1		\n" \
			/* er1 = ߥϥɥΥɥ쥹 */ \
"	jmp	_kernel_ret_main		\n" \
			/* إ */ \
)

/*
 *  ߥϥɥνޥ
 */
#define INTHDR_ENTRY(inthdr)			\
	extern void inthdr##_entry(void);	\
	_INTHDR_ENTRY(inthdr##_entry, inthdr)	/* νϾ嵭ޥ */
#define	INT_ENTRY(inthdr)	inthdr##_entry

/* ٥ơ֥(sys_support.S)ѥ٥ޥ */
#define	__INT_ENTRY(inthdr)	_##inthdr##_entry
#define	_INT_ENTRY(inthdr)	__INT_ENTRY(inthdr)

/*
 *  CPU㳰ϥɥνޥ
 */
#define	EXCHDR_ENTRY(exchdr)	INTHDR_ENTRY(exchdr)
#define	EXC_ENTRY(exchdr)	exchdr##_entry

/* ٥ơ֥(sys_support.S)ѥ٥ޥ */
#define	__EXC_ENTRY(exchdr)	_##exchdr##_entry
#define	_EXC_ENTRY(exchdr)	__EXC_ENTRY(exchdr)

/*
 *  CPU㳰ȯΥƥ֤λ
 */
#ifndef _MACRO_ONLY

/*
 *  CPU㳰ȯΥƥȽ
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	return(intnest > 1);
		/* 1ӤΤϡ߼¹CPU㳰ʬߥͥ
		   󥿤󥯥ȤƤ뤿 */
}

/*
 *  CPU㳰ȯCPUå֤λ
 *    H8SǤǤϡƤФ뤳Ȥ̵Ӥꤹ롣
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return(TRUE);
}

/*
 *  ץå¸ν
 */
extern void	cpu_initialize(void);

/*
 *  ץå¸νλ
 */
extern void	cpu_terminate(void);

#endif /* _MACRO_ONLY_ */

/*============================================================================*/
/*  ̥ɥȤˤϤʤȼʬ  */

/*
 *  ߥ٥ѥޥʤ⤷ϡ饤ؿ
 *  x : 󥿥ץȥץ饤ƥ쥸	( IPRA - IPRK )
 *  y : IPRѥޥʾ̤̤	( IPR_UPR, IPR_LOW )
 *  z : ߥ٥				( 0 - 7 )
 */
#ifndef _MACRO_ONLY

Inline void icu_set_ilv( VP ipr, BOOL mask, INT level ) {

	if( mask == IPR_UPR ) {
		h8s_wrb_mem( ipr, ( h8s_reb_mem( ipr ) & ~IPR_UPR_MASK ) | TO_HI4((UB) level) );
	} else if( mask == IPR_LOW ) {
		h8s_wrb_mem( ipr, ( h8s_reb_mem( ipr ) & ~IPR_LOW_MASK ) | TO_LO4((UB) level) );
	}
}

#endif /* _MACRO_ONLY_ */

#ifndef _MACRO_ONLY
/*
 *  ̤ȯΥ顼 (cpu_config.c, cpu_support.S)
 *    ¤ EXCSTACK ϡh8s.h 
 */
extern void	cpu_experr(EXCSTACK *sp);

#endif /* _MACRO_ONLY_ */

#endif /* _CPU_CONFIG_H_ */
