/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#define _MACRO_ONLY

#include "jsp_kernel.h"
#include "offset.h"

	.h8300s
	.text
	.align 2

/*
 *  ǥѥå
 *  dispatch ϡߥͥȥ = 0CPUå֡ʳ߶ػ߾֡ˤ
 *    ƤӽФʤФʤʤ
 *  exit_and_dispatch ϡߥͥȥ = 0CPUå֡ʳ߶ػ
 *    ֡ˤǸƤӽФΤ§Ǥ롣ͥ뵯ưб뤿ᡤ
 *    ߥͥȥ = 1 ǸƤӽФˤбƤ롣
 */

	.global _dispatch
	.global	_exit_and_dispatch

/* ǥѥåŪ˸ƤӽФ */
_dispatch:
	push.l	er2			/* er26 ¸ */
	push.l	er3
	push.l	er4
	push.l	er5
	push.l	er6

	mov.l	@_runtsk, er0		/* er0 = runtsk */
	mov.l	sp, @(TCB_sp, er0)	/* runtsk->sp = sp
					   (åݥ󥿤¸) */
	mov.l	#dispatch_r, er1
	mov.l	er1, @(TCB_pc, er0)	/* runtsk->pc = dispatch_r
					   (μ¹ԺƳϤ¸) */

	bra     dispatcher_1

/* ߼¹ΥƥȤΤƤơǥѥåƤӽФ */
_exit_and_dispatch:
	sub.l	er0, er0
	mov.l	er0, @_intnest		/* ߥͥȥ = 0 */

dispatcher_1:
	/* ˤ CPUåʳ߶ػߡˤ뤳 */
	mov.l	@_schedtsk, er0		/* er0 = schedtsk */
	or.l	er0, er0		/* Ƚʬ (¹Բǽ̵ͭ) */
	beq	dispatcher_2		/* schedtsk ̵ʤ顢Ԥ */

	mov.l	er0, @_runtsk		/* runtsk = er0 (= schedtsk)
					   (åμ¹) */
	mov.l	@(TCB_sp, er0), sp	/* sp = runtsk->sp
					   (åݥ) */
	mov.l	@(TCB_pc, er0), er0	/* er0 = runtsk->pc
					   (μ¹ԺƳϤμ) */
					/* ¹ԺƳϤϰʲ3̤
					   ǥѥåνи  dispatch_r
					   ߡ㳰νи    ret_int_r
					   ưľ        activate_r
					 */

	jmp	@er0			/* μ¹ԺƳϤإ */

	/*
	 *  ¹Ԥ٤ޤԤĽ
	 *    ǥƥȤڤ괹Τϡ
	 *      ȯ߽ˤɤΥåȤȤβ
	 *      ߥϥɥǤΥǥѥåɻ
	 *    ȤĤΰ̣롥
	 */ 
dispatcher_2:
	sub.l	er0, er0
	mov.l	er0, @_runtsk		/* runtsk = NULL */

	mov.l	#STACKTOP, sp		/* ߥå */

	sub.l	er0, er0
	inc.l	#1, er0
	mov.l	er0, @_intnest		/* ߥͥȥ = 1 */

dispatcher_2_enable_interrupt:
#ifdef SUPPORT_CHG_IPM
	ldc.b	@_task_intmask, exr	/* unlock_cpu(ߵ) */
#else /* SUPPORT_CHG_IPM */
	ldc.b	#0, exr			/* unlock_cpu(ߵ) */
#endif /* SUPPORT_CHG_IPM */
	sleep				/* Ԥ */
	ldc.b	#MAX_IPM, exr		/* lock_cpu  (߶ػ) */

	mov.l	@_reqflg, er0		/* er0 = reqflg  */
	or.l	er0, er0		/* Ƚʬ (ǥѥå׵) */
	beq	dispatcher_2_enable_interrupt
					/* ǥѥå׵᤬̵
					   롼פƬإ */

	sub.l	er0, er0		/* er0 = 0 (= NULL) */
	mov.l	er0, @_reqflg		/* reqflg = NULL (reqflg򥯥ꥢ) */
	mov.l	er0, @_intnest		/* ߥͥȥ = 0 */

	bra	dispatcher_1		/* ǥѥåإ */

/*
 *  ƥȤؤʥǥѥåи
 */
dispatch_r:
	pop.l	er6			/* er26  */
	pop.l	er5
	pop.l	er4
	pop.l	er3
	pop.l	er2

	/* 㳰׵Υå */
	mov.l	@_runtsk, er0		/* er0 = runtsk */

	mov.b	@(TCB_enatex, er0), r1l	/* r1l = runtsk->enatex */
	btst	#TCB_enatex_bit, r1l	/* TCB_enatex == 1  */
	beq	dispatch_r_1		/* 㳰ػߤλ */

	mov.l	@(TCB_texptn, er0), er1	/* er1 = runtsk->texptn */
	beq	dispatch_r_1		/* 㳰׵᤬̵ */

	jmp	@_call_texrtn		/* 㳰롼θƽ */

dispatch_r_1:
        rts				/* dispatch ƤӽФĽ */

/*============================================================================*/

/*
 *  ߥϥɥ
 *    ȤϡCPU å֤ǡ
 *      er0(r0l) : ׵γߥ٥
 *      er1      : ߥϥɥΥɥ쥹
 *    Ƥ롣er0, er1 ϥå¸Ѥߡ
 */

	.global ret_main
	.global	_ret_int_r	/* monitor  */

ret_main:
	push.l	er2			/* ĤΥ쥸¸ */
	push.l  er3
	push.l	er4
	push.l	er5
	push.l	er6
		/* ⤷ȡH8S/2600 ˤ macl, mach 쥸¸
		   ǹԤɬפ뤫Τޤ󡣡Ʊ͡
		   ȯĶ¤ˤꡢǧǤƤޤ */

	mov.l	@_intnest, er2		/* er2 = intnest */
	mov.l	er2, er3		/* er3(= er2)ϡνѤ롣 */
	inc.l	#1, er2			/* ߥͥȥ += 1 */
	mov.l	er2, @_intnest

	or.l	er3, er3		/* Ƚʬ
					   (ȯΥƥ) */
	beq	first_exception		/* ʤγߤλ */

/* ¿ųߤν */
multipul_exception:
	ldc.b	r0l, exr		/* (ߤγߥ٥ʾ)ߵ */

	jsr	@er1			/* ߥϥɥƽ */

	ldc.b	#MAX_IPM, exr		/* lock_cpu  (߶ػ) */

	mov.l	@_intnest, er0		/* er0 = intnest */
	dec.l	#1, er0			/* ߥͥȥ -= 1 */
	mov.l	er0, @_intnest

	jmp	ret_to_task_int

/* ʤγߤξ */
first_exception:

	mov.l	sp, er2			/* er2 = åݥ */
	mov.l	#STACKTOP, sp		/* ߥå */
	push.l	er2			/* åݥ󥿤
					   ߥå */

	ldc.b	r0l, exr		/* (ߤγߥ٥ʾ)ߵ */

	jsr	@er1			/* ߥϥɥƽ */

	ldc.b	#MAX_IPM, exr		/* lock_cpu  (߶ػ) */

	mov.l	@sp, sp			/* å */

	mov.l	@_intnest, er0		/* er0 = intnest */
	dec.l	#1, er0			/* ߥͥȥ -= 1 */
	mov.l	er0, @_intnest

	/* ǥѥå׵/㳰׵(reqflg)Ƚ */
	mov.l	@_reqflg, er0		/* er0 = reqflg */
	or.l	er0, er0		/* Ƚʬ */
	bne	occur_dispatch_or_tsk_exception
					/* reqflg = TRUE λ */
					/* ξ郎OR Ωλ
					   ٱǥѥåȯ
					   㳰׵᤬ȯ */

	/* 쥸 */
ret_to_task_int:
	pop.l	er6			/*  +0:er6 */
	pop.l	er5			/*  +4:er5 */
	pop.l	er4			/*  +8:er4 */
	pop.l	er3			/* +12:er3 */
	pop.l	er2			/* +16:er2 */
	pop.l	er1			/* +20:er1 */
	pop.l	er0			/* +24:er0 */
					/* +28:EXR -> EXR_offset = 28 */
	rte				/* ȯ */
			/* EXR (unlock_cpu )ϥϡɥԤ */

/*
 *  ߽ˤٱǥѥå/㳰˴ؤ
 */
occur_dispatch_or_tsk_exception:

/* ȯĽȽ */
	mov.b	@(EXR_offset, sp), r0l	/* r01 = åEXR */
	and.b	#EXR_I_MASK, r0l	/* r01 = åγߥޥ */

#ifdef SUPPORT_CHG_IPM			/* r1l = ƥȤ
					         ߥޥ */
	mov.b	@_task_intmask, r1l
#else /* SUPPORT_CHG_IPM */
	mov.b	#0, r1l
#endif /* SUPPORT_CHG_IPM */

	cmp.b	r0l, r1l		/* Ƚʬ (ȯĽ) */

	bne	ret_to_task_int		/* ȯ꤬ƥ
					   Ǥʤ */
		/* Ūʬϡto_int_routine ˤ SUPPORT_CHG_IPM
		   ޥǰϤޤ줿ĽľǤ롣Ȥ꤫顢ܼŪ
		   ƱʤΤǡret_to_task_int ȵҤ */

	sub.l	er0, er0		/* er0 = NULL (= 0) */
	mov.l	er0, @_reqflg		/* reqflg = NULL (reqflg򥯥ꥢ) */

/* ٱǥѥå˴ؤȽ */
	/* ǥѥåػ/ĤȽ */
	mov.l	@_enadsp, er0		/* er0 = enadsp */
	or.l	er0, er0		/* Ƚʬ */
	beq	to_tsk_exc		/* ǥѥåػߤʤ饸 */

	/* 塼󥰷̤Ƚ */
	mov.l	@_runtsk, er0		/* er0 = runtsk	*/
	mov.l	@_schedtsk, er1		/* er1 = schedtsk */
	cmp.l	er0, er1		/* Ƚʬ */
	beq	to_tsk_exc		/* runtsk == schedtsk ʤ饸 */

/* ٱǥѥåȯ */
occur_dispatch:
#ifdef H8S_2600				/* H8S_2600ϥѥ륪ץ */
	/* ¥쥸 */
	/* er0 ϲˤѤΤ˲Ǥʤ */
	stmac	mach, er1
	push.l	er1
	stmac	macl, er1
	push.l	er1
#endif /* H8S_2600 */

	mov.l	sp, @(TCB_sp, er0)	/* runtsk->sp = sp
					   (åݥ󥿤¸) */

	mov.l	#ret_int_r, er1
	mov.l	er1, @(TCB_pc, er0)	/* runtsk->pc = ret_int_r
					   (μ¹ԺƳϤ¸) */

	jmp	dispatcher_1		/* ǥѥåƥƽ */

/* ٱǥѥåˤäƥǥѥåƥȤγ */
_ret_int_r:	/* monitor  */
ret_int_r:

#ifdef H8S_2600				/* H8S_2600ϥѥ륪ץ */
	/* ¥쥸 */
	pop.l	er0
	ldmac	er0, macl
	pop.l	er0
	ldmac	er0, mach
#endif /* H8S_2600 */

/* ٱǥѥåȯʤäγ */

/* 㳰˴ؤȽ */
to_tsk_exc:
	mov.l	@_runtsk, er0		/* er0 = runtsk */

	/* 㳰ػ/ĤȽ */
	mov.b	@(TCB_enatex, er0), r1l	/* r1l = runtsk->enatex */
	btst	#TCB_enatex_bit, r1l	/* TCB_enatex == 1  */
	beq	to_int_routine		/* 㳰ػߤλ */

	/* 㳰׵̵ͭȽ */
	mov.l	@(TCB_texptn, er0), er1	/* er1 = runtsk->texptn */
	beq	to_int_routine		/* 㳰׵᤬̵ */

	jsr	@_call_texrtn		/* 㳰롼θƽ */

to_int_routine:

/* chg_ipm äϡٱǥѥåΥʤΤǡ˵Ҥ롣 */
#ifdef SUPPORT_CHG_IPM
	/* ߥϥɥ齪λ̤ΥإåȤˡ
	   ߥޥ礵 */
	/* 㡧ǥѥå
		->ߥϥɥ->->
	       ư
		λ˥ǡߥޥѹԤ줿ˡ
		γߥޥ˴ؤ򡢥¤饿ؤ
		Ѥɬס*/
	mov.b	@_task_intmask, r1l	/* r1l = task_intmask */
		/* task_intmaskCHG_IPM ˤѹ줿ǽΤ
				 ߥޥ */
	mov.b	r1l, @(EXR_offset, sp)
		/* å EXR ˾񤭤򤹤롣 */
		/* »ࡧEXR Υȥ졼ӥå T ¸ʤ */
#endif /* SUPPORT_CHG_IPM */

	jmp	ret_to_task_int		/* ƥȤؤ */

/*============================================================================*/

/*
 *  ư
 */

	.global _activate_r

_activate_r:
	/* ȤϡCPUåˤʤäƤ롣 */

	mov.l	#_ext_tsk, er0
	push.l	er0				/* Ϥ */

	/* ط */
	mov.l	@_runtsk, er2			/* er2 = runtsk */
	mov.l	@(TCB_tinib, er2), er2		/* er2 = runtsk->tinib */

	/* ưϤ */
	mov.l	@(TINIB_task, er2), er1		/* er1 = runtsk->tinib->task */

	/* ؤΰʳĥ */
	mov.l	@(TINIB_exinf, er2), er0	/* er0 = runtsk->tinib->exinf */

#ifdef SUPPORT_CHG_IPM
	ldc.b	@_task_intmask, exr		/* unlock_cpu(ߵ) */
#else /* SUPPORT_CHG_IPM */
	ldc.b	#0, exr				/* unlock_cpu(ߵ) */
#endif /* SUPPORT_CHG_IPM */

	jmp	@er1				/* ư */

/*============================================================================*/
/*  ̥ɥȤˤϤʤȼʬ  */

/*
 *  no_reg_exception()
 *    CPU㳰ȤϿƤʤ㳰ȯȸƤӽФ롣
 *    㳰ȯ PCer07 Ϥƥͥߤ롣
 */
	.global no_reg_exception

no_reg_exception:

	push.l	er0			/* er06¸	*/
	push.l	er1
	push.l	er2
	push.l	er3
	push.l	er4
	push.l	er5
	push.l	er6

	mov.l	sp, er0			/* ˥åݥ󥿤	*/
	/* CPU㳰ȯ SP ϡ
	   34(= 4*7(er) + 1(exr) + 1(ͽ) + 1(ccr) + 3(pc) )  */

	jsr	@_cpu_experr		/* cpu_experr()θƤӽФ */

