/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000,2001 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2002 by Monami software, Limited Partners.
 *  Copyright (C) 2008-     by Monami Software Limited Partnership, JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id: cpu_defs.h,v 1.1 2004/07/21 02:49:36 monaka Exp $
 */

/*
 *	ץå˰¸i386ѡ
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

#define IA32

#ifndef _MACRO_ONLY

typedef	UINT		EXCNO;		/* CPU㳰ϥɥֹ */

#define SIL_ENDIAN SIL_ENDIAN_LITTLE

#define SIL_REV_ENDIAN_H(data) ((VH)((((UH)(data) & 0xff) << 8) | (((UH)(data) >> 8) & 0xff)))

#define SIL_REV_ENDIAN_W(data) ((VW)((((UW)(data) & 0xff) << 24) | (((UW)(data) & 0xff00) << 8) | (((UW)(data) >> 8) & 0xff00) | (((UW)(data) >> 24) & 0xff)))

Inline VB sil_reb_iop(VP iop) {
	VB data;
	Asm("inb %%dx, %%al" : "=a"(data) : "d"(iop));
	return data;
}

Inline VH sil_reh_iop(VP iop) {
	VH data;
	Asm("inw %%dx, %%ax" : "=a"(data) : "d"(iop));
	return data;
}

Inline VW sil_rew_iop(VP iop) {
	VW data;
	Asm("inl %%dx, %%eax" : "=a"(data) : "d"(iop));
	return data;
}

#define sil_reh_lep(iop) sil_reh_iop(iop)
#define sil_rew_lep(iop) sil_rew_iop(iop)

Inline VH sil_reh_bep(VP iop) {
	return SIL_REV_ENDIAN_H(sil_reh_iop(iop));
}

Inline VW sil_rew_bep(VP iop) {
	return SIL_REV_ENDIAN_W(sil_rew_iop(iop));
}

Inline void sil_wrb_iop(VP iop, VB data) {
	Asm("outb %%al, %%dx" : : "a"(data), "d"(iop));
}

Inline void sil_wrh_iop(VP iop, VH data) {
	Asm("outw %%ax, %%dx" : : "a"(data), "d"(iop));
}

Inline void sil_wrw_iop(VP iop, VW data) {
	Asm("outl %%eax, %%dx" : : "a"(data), "d"(iop));
}

#define sil_wrh_lep(iop, data) sil_wrh_iop(iop, data)
#define sil_wrw_lep(iop, data) sil_wrw_iop(iop, data)

Inline void sil_wrh_bep(VP iop, VH data) {
	sil_wrh_iop(iop, SIL_REV_ENDIAN_H(data));
}

Inline void sil_wrw_bep(VP iop, VW data) {
	sil_wrw_iop(iop, SIL_REV_ENDIAN_W(data));
}

#endif /* _MACRO_ONLY */
#endif /* _CPU_DEFS_H_ */
