/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.14 2007/07/27 11:28:44 honda Exp $
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include <lm32.h>

#ifndef _MACRO_ONLY

typedef UW    CLOCK;

#define TO_CLOCK(nume, deno) (TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)       ((clock) * 1000 / TIMER_CLOCK)

#define MAX_CLOCK    ((CLOCK) 0xffffffff)

#define GET_TOLERANCE    100
#define BEFORE_IREQ(clock) \
        ((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

#define CLOCK_PER_TICK		((CLOCK) TO_CLOCK(TIC_NUME, TIC_DENO))

Inline void
hw_timer_initialize()
{
	UW sr;
		
    sil_wrw_mem((VP)TIMER_CONTROL, TIMER_CONTROL_STOP);
    sil_wrw_mem((VP)TIMER_STATUS, 0);
    
    sil_wrw_mem((VP)TIMER_PERIOD, CLOCK_PER_TICK);

    Asm("rcsr %0, im" : "=r"(sr));
    sr |= (1 << INHNO_TIMER);
    Asm("wcsr im, %0" : : "r"(sr) );
    
    sil_wrw_mem((VP)TIMER_CONTROL, 
        TIMER_CONTROL_ITO | TIMER_CONTROL_CONT | TIMER_CONTROL_START);
        
}

Inline void
hw_timer_int_clear()
{
    sil_wrw_mem((VP)TIMER_STATUS, 0);
}

Inline void
hw_timer_terminate()
{
    sil_wrw_mem((VP)TIMER_CONTROL, TIMER_CONTROL_STOP);
    sil_wrw_mem((VP)TIMER_STATUS, 0);
}

Inline CLOCK
hw_timer_get_current(void)
{
    return(CLOCK_PER_TICK - sil_rew_mem((VP)TIMER_SNAPSHOT));
}

Inline BOOL
hw_timer_fetch_interrupt(void)
{
    return(sil_rew_mem((VP)TIMER_STATUS) & TIMER_STATUS_TO);
}
#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
