/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

/*
 *	ꥢI/OǥХSIO˥ɥ饤СVR4131¢DSIUѡ
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <vr4131_dsiu.h>		/* siopcb, vr4131_dsiu_openflag */

/*
 *  SIOγߥϥɥΥ٥ֹ
 */
#define INHNO_SIO		INTNO_DSIU

/*
 *  SIOɥ饤Фν롼
 */
#define	sio_initialize		vr4131_dsiu_initialize

/*
 *  ͥ뵯ưѤν (sys_putc)
 */
#define sio_init		vr4131_dsiu_init

#ifndef _MACRO_ONLY

/*
 *  ꥢI/OݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;
	BOOL	openflag;

	/*
	 *  ץ󤷤ݡȤ뤫 openflag ɤǤ
	 */
	openflag = vr4131_dsiu_openflag();

	/*
	 * DSIUؤΥå볫
	 */
	vr4131_orh( (VP) CMUCLKMSK, (MSKDSIU | MSKSSIU | MSKSIU) );

	/*
	 *  ǥХ¸Υץ
	 */
	siopcb = vr4131_dsiu_opn_por(siopid, exinf);

	/*
	 *  ꥢI/Oߤγߥ٥ꤷޥ롥
	 */
	if (!openflag) {
		/* ߥ٥ */
		all_set_ilv( (UINT) INTNO_DSIU, &((IPM) IPM_DSIU) );

		/* ޥ(٥룱) */
		vr4131_orh( (VP) MSYSINT2REG, DSIUINTR );

		/* ޥ(٥룲) */
		vr4131_orh( (VP) MDSIUINTREG, INTDSIU );
	}

	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  ꥢI/Oߤޥ롥
	 */
	if (!vr4131_dsiu_openflag) {
		/* ޥ(٥룱) */
		vr4131_andh( (VP) MSYSINT2REG, ~DSIUINTR );

		/* ޥ(٥룲) */
		vr4131_andh( (VP) MDSIUINTREG, ~INTDSIU );
	}

	/*
	 *  ǥХ¸Υ
	 */
	vr4131_dsiu_cls_por(siopcb);

	/*
	 *  DSIUؤΥå
	 */
	vr4131_andh( (VP) CMUCLKMSK, ~(MSKDSIU | MSKSSIU | MSKSIU) );

}

#endif /* _MACRO_ONLY */

/*
 *  SIOγߥϥɥ
 */
#define	sio_handler		vr4131_dsiu_isr

/*
 *  ꥢI/OݡȤؤʸ
 */
#define	sio_snd_chr		vr4131_dsiu_snd_chr

/*
 *  ꥢI/OݡȤؤʸʥݡ󥰡
 */
#define	sio_snd_chr_pol		vr4131_dsiu_putchar_pol

/*
 *  ꥢI/OݡȤʸ
 */
#define	sio_rcv_chr		vr4131_dsiu_rcv_chr

/*
 *  ꥢI/OݡȤΥХåε
 */
#define	sio_ena_cbr		vr4131_dsiu_ena_cbr

/*
 *  ꥢI/OݡȤΥХåζػ
 */
#define	sio_dis_cbr		vr4131_dsiu_dis_cbr

/*
 *  ꥢI/OݡȤǽХå
 */
#define	sio_ierdy_snd		vr4131_dsiu_ierdy_snd

/*
 *  ꥢI/OݡȤμΥХå
 */
#define	sio_ierdy_rcv		vr4131_dsiu_ierdy_rcv

#endif /* _HW_SERIAL_H_ */
