/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#define _MACRO_ONLY

#include "jsp_kernel.h"

	.set noreorder
	.align 2

/*
 *  åȥϡɥ¸ (reset.S ƤӽФ)
 */
#ifndef GDB_STUB

	.section .reset
	.global	hardware_init_hook

hardware_init_hook:

	/*
	 *  Хȥ˥å(BCU)طν
	 */
	li	t0, ASM_SIL( ROMSIZEREG )
	lh	t1, (t0)
	ori	t1, t1, (SIZE3_4 | SIZE2_4 | SIZE1_4 | SIZE0_4)
	sh	t1, (t0)

	li	t0, ASM_SIL( ROMSPEEDREG )
	lh	t1, (t0)
	ori	t1, t1, (ROM4_WAIT_5VTClock | ROM2_WAIT_8VTClock)
	sh	t1, (t0)

	li	t0, ASM_SIL( BCUCNTREG3 )
	lh	t1, (t0)
	ori	t1, t1, (EXT_ROMCS_3ROM_2ROM | IO32 | LCDSEL1_BUFFER | LCDSEL0_BUFFER)
	sh	t1, (t0)

	/*
	 * SDRAMȥ˥å(SDRAMU)طν
	 */

	li	t0, ASM_SIL( SDRAMMODEREG )
	lh	t1, (t0)
	ori	t1, t1, (SCLK | LTMODE_2)
	sh	t1, (t0)

	li	t0, ASM_SIL( SDRAMCNTREG )
	lh	t1, (t0)
	ori	t1, t1, (TRC_3VTClock | TDAL_2VTClock | TRCD_2VTClock)
	sh	t1, (t0)

	li	t0, ASM_SIL( BCURFCNTREG )
	lh	t1, (t0)
	ori	t1, t1, 0x3ec
	sh	t1, (t0)

	li	t0, ASM_SIL( BCURFCNTREG )
	lh	t1, (t0)
	ori	t1, t1, 0x3ec
	sh	t1, (t0)

	li	t0, ASM_SIL( RAMSIZEREG )
	lh	t1, (t0)
	ori	t1, t1, (SIZE3_64 | SIZE2_64 | SIZE1_64 | SIZE0_64)
	sh	t1, (t0)

	/*
	 *  Хȥ˥å(BCU)طν
	 */
	li	t0, ASM_SIL( IO0SPEEDREG )
	lh	t1, (t0)
	ori	t1, t1, IO0_1_WAIT_4
	sh	t1, (t0)

	li	t0, ASM_SIL( IO1SPEEDREG )
	lh	t1, (t0)
	ori	t1, t1, IO1_3_WAIT_11
	sh	t1, (t0)

	/*
	 *  HALTimeråȥΥꥢ
	 *  CPUư塢4ð˹ԤʤФʤʤ
	 *  PMUȥ쥸HALTimerꥻåȥӥåȤˣ񤭹
	 */
	li	t0, ASM_SIL( PMUCNTREG )
	lh	t1, (t0)
	ori	t1, t1, HALTIMERRST
	sh	t1, (t0)

	/*
	 *  HALTimerꥻåȤΥꥢ
	 *  PMUߡơ쥸TIMOUTRSTӥåȤˣ񤭹
	 */
	li	t0, ASM_SIL( PMUINTREG )
	lh	t1, (t0)
	ori	t1, t1, TIMOUTRST
	sh	t1, (t0)

	/*
	 * TLBν
	 */
tlb_initialize:
	mtc0	zero, PageMask
	mtc0	zero, EntryLo0
	mtc0	zero, EntryLo1

	li	t0, TMAX_TLB
	li	t1, 0xA0000000		/* kseg1 DRAMν */
loop_TLB_clear:
	mtc0	t0, Index
	mtc0	t1, EntryHi
	addiu	t0, t0, -1
	addiu	t1, t1, TLB_VPN2	/* 1ڡ4kХȤǡ2ڡʬޥå
					   󥰤뤿 */
	tlbwi
	bgez	t0, loop_TLB_clear
	nop

	/*
	 * åν
	 */
cache_initialize:
	mtc0	zero, TagLo
	mtc0	zero, TagHi

	li	t0, 0x80001ff0	/* 512 line ʬ (1 line = 16 byte) */
	li	t1, 0x80000000
loop_I_cache_clear:
	cache	Index_Invalidate_I, 0x0000(t0)
	cache	Index_Invalidate_I, 0x2000(t0)
	bne	t0, t1, loop_I_cache_clear
	addiu	t0, t0, -I_CACHE_LINE_SIZE

	li	t0, 0x80001ff0	/* 512 line ʬ (1 line = 16 byte) */
	li	t1, 0x80000000
loop_D_cache_clear:
	cache	Index_Store_Tag_D, 0x0000(t0)
	cache	Index_Store_Tag_D, 0x2000(t0)
	bne	t0, t1, loop_D_cache_clear
	addiu	t0, t0, -D_CACHE_LINE_SIZE

	/*
	 * ƤӽФإ꥿
	 */
return_to_common:
	j	ra
	nop

#endif /* GDB_STUB */
