/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _VR4131_H_
#define _VR4131_H_

/*
 *  VR4131 ϡɥ
 */

/* CP0ϥɤΤλֲԤ NOP_FOR_CP0_HAZARD  */
/* VR4131Ǥmtc0̿ľ夫߶ػߤˤʤäƤΤnop̿ʤƤ
    */
#define NOP_FOR_CP0_HAZARD

/* Config쥸  */
#define BP		BIT16	/* ʬͽ¬ */

/* TLB Υȥκ  */
#define TMAX_TLB	31

/* TLBޥ */
#define TLB_VPN2	0x800

/* å̿ */
#define Index_Invalidate_I	(0x0+0x0)
#define Index_Store_Tag_I       (0x8+0x0)
#define Index_Store_Tag_D       (0x8+0x1)

/* åΥ饤󥵥(Хñ)  */
#define D_CACHE_LINE_SIZE 	0x10	/* 16Х */
#define I_CACHE_LINE_SIZE 	0x10	/* 16Х */

/*============================================================================*/

#ifndef _MACRO_ONLY

Inline void
vr4131_exit() {
	while(1);
	/* GDB_STUB ѻˤϡSTUBƬֽɬפ⡣ */
}

#endif /* _MACRO_ONLY */

/*============================================================================*/
/* ʲϡƥ˥åȤȤˡvr4131_xxx.hȤƤޤȤ뤳Ȥɬפ⡣ */

/*
 * åޥ˥å(CMU)ط
 */
#define CMUCLKMSK	0x0f000060

#define MSKSIU		BIT1	/* SIU, DSIUؤTClock */
#define MSKSSIU		BIT8	/* SIUؤ18.432MHzå */
#define MSKDSIU		BIT11	/* DSIUؤ18.432MHzå */

/*
 * ѥޥ͡ȥ˥å(PMU)ط
 */
#define PMUINTREG	0x0f0000c0	/* PMU ߡơ쥸 */
#define PMUCNTREG	0x0f0000c2	/* PMU ȥ쥸 */
#define PMUTCLKDIVREG	0x0f0000cc

/* for PMUINTREG */
#define TIMOUTRST	BIT5		/* HALTimerꥻåȸ */

/* for PMUCNTREG */
#define HALTIMERRST	BIT2		/* HALTimerꥻå*/

/* for PMUTCLKDIVREG */
#define VTDIV_3		(BIT1 | BIT0)

/*
 * Хȥ˥å(BCU)ط
 */
#define BCUCNTREG1	0x0f000000
#define ROMSIZEREG	0x0f000004
#define ROMSPEEDREG	0x0f000006
#define IO0SPEEDREG	0x0f000008
#define IO1SPEEDREG	0x0f00000a
#define BCUCNTREG3	0x0f000016

/* for ROMSIZEREG */
#define SIZE3_4			BIT12
#define SIZE2_4			BIT8
#define SIZE1_4			BIT4
#define SIZE0_4			BIT0

/* for ROMSPEEDREG */
#define ROM4_WAIT_5VTClock	(BIT13 | BIT12)
#define ROM2_WAIT_8VTClock	(BIT2 | BIT0)

/* for IO0SPEEDREG */
#define IO0_1_WAIT_4		(BIT1 | BIT0)

/* for IO1SPEEDREG */
#define IO1_3_WAIT_11		BIT11

/* for BCUCNTREG3 */
#define EXT_ROMCS_3ROM_2ROM	(BIT13 | BIT12)
#define IO32			BIT7
#define LCDSEL1_BUFFER		BIT1
#define LCDSEL0_BUFFER		BIT0

/*
 * SDRAMȥ˥å(SDRAMU)ط
 */
#define SDRAMMODEREG	0x0f000400
#define SDRAMCNTREG	0x0f000402
#define BCURFCNTREG	0x0f000404
#define BCURFCOUNTREG	0x0f000406
#define RAMSIZEREG	0x0f000408

/* for SDRAMMODEREG */
#define SCLK		BIT15
#define LTMODE_2	BIT5

/* for SDRAMCNTREG */
#define TRC_3VTClock	(BIT9 | BIT8)
#define TDAL_2VTClock	BIT5
#define TRCD_2VTClock	BIT1

/* for RAMSIZEREG */
#define SIZE3_64	(BIT14 | BIT12)
#define SIZE2_64	(BIT10 | BIT8)
#define SIZE1_64	(BIT6 | BIT4)
#define SIZE0_64	(BIT2 | BIT0)

/*
 * ꥢ륤󥿥ե˥å(SIU)ط
 */
#define SIURESET	0x0f000809

/* for SIURESET */
#define DSIURESET	BIT1	/*  DSIUꥻåȤե饰  */

#endif /* _VR4131_H_ */
