/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 *  Copyright (C) 2010 by Cronus Computer Works, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id
 */

/*
 *  եץ AP-SH2A-1A
 *  ܡɸͭ
 */

#ifndef _APSH2A1A_H_
#define _APSH2A1A_H_

#ifndef _MACRO_ONLY

extern void sh2scif_putc_pol (ID portid, char c);	/*  sh726xscif.c  */

#ifdef GDB_STUB

/*
 *  GDB STUBƽФ롼
 */

#define sh2_exit	gdb_stub_exit
#define sh2_putc	gdb_stub_putc

Inline void
gdb_stub_exit (void)
{
	/* ƥȤƤʤ */
	Asm ("trapa #0x20"::);
}

/*
 *  gdb stubˤ
 */
Inline int
gdb_stub_putc (ID portid, int c)
{
	sh2scif_putc_pol (portid, c);
	return (c);
}

#else /* GDB_STUB */

/*
 *  ROMξ
 */

Inline void
sh2_exit ()
{
	while (1);
}

Inline void
sh2_putc (ID portid, char c)
{
	sh2scif_putc_pol (portid, c);
}

#endif /* GDB_STUB */
#endif /* _MACRO_ONLY */
#endif /* _APSH2A1A_H_ */
