/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 *  Copyright (C) 2010 by Cronus Computer Works, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id
 */

/*
 *	åȥƥ˰¸APSH2A1Aѡ
 *ץꥱɬפȤ
 *
 *  Υ󥯥롼ɥեϡkernel.h  sil.h ǥ󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤ뤳ȤϤʤΥե򥤥
 *  롼ɤˡt_stddef.h  itron.h 󥯥롼ɤΤǡ
 *  ˰¸Ƥ褤
 */

#ifndef _SYS_DEFS_H_
#define _SYS_DEFS_H_

#define APSH2A1A			/* ƥά */

#define COPYRIGHT_SYS \
"Copyright (C) 2010 by Cronus Computer Works, JAPAN\n\n"

#ifndef _MACRO_ONLY

/*
 *  ֹηȳߤζػߡ
 */
#if 0 /* ǤϥݡȤƤʤ */

typedef	UINT	INTNO;		/* ֹ */

extern ER	dis_int(INTNO intno) throw();
extern ER	ena_int(INTNO intno) throw();

#endif /* 0 */

#endif /* _MACRO_ONLY */

/*
 *  å⡼ɤ
 */
//#define CCR_MODE      0x00000101    /* 饤ȥХå⡼ */
#define CCR_MODE      0x00000103    /* 饤ȥ롼⡼ */

/*
 *  ե⥸塼ؤζ륯åμȿ
 *  APSH2A1AǤϡPå33.333MHz
 */
#define PCLOCK          33333000

/*
 *  ƥå
 */
#define	TIC_NUME	1u	/* ƥåμʬ */
#define	TIC_DENO	1u	/* ƥåμʬ */

/*
 *   ޤؤϥåʬ
 *
 *   APSH2A1AǤϡPå33.333Mhz
 *   0: P/8   4.166MHz  tick 4166  0.24 sec
 *   1: P/32  1.041MHz  tick 1041  0.96 sec
 *   2: P/128 260.4KHz  tick 260   3.84 sec
 *   3: P/512 65.103KHz tick 65    15.36 sec
 */
#define TCR_CKS         0

/*
 *  SDRAM⡼ɥ쥸Υɥ쥹
 *  ɥ쥹⡼
 */
#define SDRAM_MODE  ((VH *)0xfffc58c0)


#ifndef _MACRO_ONLY

/*
 *  ƥ߽
 */
#ifdef GDB_STUB

Inline void
kernel_abort()
{
	/* ƥȤƤʤ */
	Asm("trapa #0x20"::);
}

#else /* GDB_STUB */

Inline void
kernel_abort()
{
	while(1);
}

#endif /* GDB_STUB */
#endif /* _MACRO_ONLY */
#endif /* _SYS_DEFS_H_ */
