/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 *  Copyright (C) 2006 by GJ Business Division RICOH COMPANY,LTD. JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *  SH7047¢ꥢ륳ߥ˥󥤥󥿡եSCI ʰץɥ饤
 */

#ifndef _SH7047SCIF_H_
#define _SH7047SCIF_H_

#include <t_config.h>

#define sh2scif_DELAY 105000

#ifndef _MACRO_ONLY

/*
 *  ꥢI/OݡȽ֥å
 */
typedef struct sio_port_initialization_block {
	UW	cntrl;		/* ȥ쥸 */
	UW  intctl;		/* ߥ쥸 */
	UH	level;		/* ߥ٥ */
	UH	shift;		/* ߥե */
} SIOPINIB;

/*
 *  ꥢI/Oݡȴ֥å
 *    2chݡȤ˳ĥϽѤΥǡޤ
 */
typedef struct sio_port_control_block
{
	const SIOPINIB	*siopinib;	/* ꥢI/OݡȽ֥å */
	VP_INT	exinf;				/* ĥ */
	BOOL	openflag;			/* ץѤߥե饰 */
} SIOPCB;

/*
 *  Хå롼μֹ
 */
#define SIO_ERDY_SND	1u		/* ǽХå */
#define SIO_ERDY_RCV	2u		/* ΥХå */

/*
 *  SIOɥ饤Фν롼
 */
extern void sh7047scif_initialize (void);

/*
 *  ץ󤷤ƤݡȤ뤫
 */
extern BOOL sh7047scif_openflag (ID siopid);

/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB *sh7047scif_opn_por (ID siopid, VP_INT exinf);

/*
 *  ꥢI/OݡȤΥ
 */
extern void sh7047scif_cls_por (SIOPCB * siopcb);

/*
 *  ꥢI/OݡȤؤʸ
 */
extern BOOL sh7047scif_snd_chr (SIOPCB * siopcb, char c);

/*
 *  ꥢI/OݡȤʸ
 */
extern INT sh7047scif_rcv_chr (SIOPCB * siopcb);

/*
 *  ꥢI/OݡȤΥХåε
 */
extern void sh7047scif_ena_cbr (SIOPCB * siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void sh7047scif_dis_cbr (SIOPCB * siopcb, UINT cbrtn);

/*
 *  SIOγߥӥ롼
 */
extern void sh7047scif_isr (void);

/*
 *  ꥢI/OݡȤǽХå
 */
extern void sh7047scif_ierdy_snd (VP_INT exinf);

/*
 *  ꥢI/OݡȤμΥХå
 */
extern void sh7047scif_ierdy_rcv (VP_INT exinf);

#endif /* _MACRO_ONLY */

#endif /* _SH7047SCIF_H_ */
