/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 *  Copyright (C) 2006 by GJ Business Division RICOH COMPANY,LTD. JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id$
 */

#include "jsp_kernel.h"
#include <sil.h>
#include <s_services.h>
#include "sh7047.h"

#define SCI3_BASE   (IOREG_SCI_WINDOW*1) + IOREG_SCI_BASE
#define SCI4_BASE   (IOREG_SCI_WINDOW*2) + IOREG_SCI_BASE

/*
 *  åȥƥ¸ν
 */
void
sys_initialize ()
{
	unsigned char  dummy;
												/* Initialize SCR, SMR and BRR */
	sil_wrb_mem((VP)(SCI3_BASE+IOREG_SCR_OFFSET), 0x00);
	sil_wrb_mem((VP)(SCI3_BASE+IOREG_SMR_OFFSET), DEFAULT_SMR);
	sil_wrb_mem((VP)(SCI3_BASE+IOREG_BRR_OFFSET), DEFAULT_BRR);

	sil_dly_nse(5000L);
	sil_wrb_mem((VP)(SCI3_BASE+IOREG_SCR_OFFSET), SCR_RIE|SCR_TE|SCR_RE);
	dummy = sil_reb_mem((VP)(SCI3_BASE+IOREG_SSR_OFFSET));		/* Dummy read */
	sil_wrb_mem((VP)(SCI3_BASE+IOREG_SSR_OFFSET), SSR_TDRE);	/* Clear error flags */
}

/*
 *  åȥƥνλ
 */
void
sys_exit()
{
	sh2_exit();
}

/*
 *  åȥƥʸ
 */
void
sys_putc(char c)
{
	if (c == '\n') {
		sh2_putc (LOGTASK_PORTID, '\r');
	}
	sh2_putc (LOGTASK_PORTID, c);
}

