/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000,2001 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002 by Hokkaido Industrial Research Institute, JAPAN
 *  Copyright (C) 2010 by Cronus Computer Works, JAPAN
 *
 *  嵭ԤϡFree Software Foundation ˤäƸɽƤ
 *  GNU General Public License  Version 2 ˵ҤƤ狼
 *  ξΤ줫˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥѲǽʥХʥꥳɡʥ֥륪
 *      ȥե饤֥ʤɡˤηѤˤϡ
 *      ȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭ɽ
 *      Ѿ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥԲǽʥХʥꥳɤηޤϵ
 *      ߹ѤˤϡΤ줫ξȡ
 *    (a) ѤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) Ѥη֤̤ˡˤäơ嵭Ԥ𤹤
 *        ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭Ԥդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥϡ
 *  ܥեȥ˴ؤơŬѲǽޤơʤݾڤԤ
 *  ʤޤܥեȥѤˤľŪޤϴŪ
 *  ʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id
 */

#ifndef _SH7262_H_
#define _SH7262_H_

#include <sil.h>

/*
 *  ߥ٥ֹ
 */
#define INT_IRQ0        64          /* IRQ0 () */
#define INT_IRQ1        65          /* IRQ1 () */
#define INT_IRQ2        66          /* IRQ2 () */
#define INT_IRQ3        67          /* IRQ3 () */
#define INT_IRQ4        68          /* IRQ4 () */
#define INT_IRQ5        69          /* IRQ5 () */
#define INT_IRQ6        70          /* IRQ6 () */
#define INT_IRQ7        71          /* IRQ7 () */
#define INT_PINT0       80          /* PINT0 () */
#define INT_PINT1       81          /* PINT1 () */
#define INT_PINT2       82          /* PINT2 () */
#define INT_PINT3       83          /* PINT3 () */
#define INT_PINT4       84          /* PINT4 () */
#define INT_PINT5       85          /* PINT5 () */
#define INT_PINT6       86          /* PINT6 () */
#define INT_PINT7       87          /* PINT7 () */
#define INT_DEI0        108         /* DMACͥ0 ȥ󥹥ե */
#define INT_HEI0        109         /* DMACͥ0 ϡե */
#define INT_DEI1        112         /* DMACͥ1 ȥ󥹥ե */
#define INT_HEI1        113         /* DMACͥ1 ϡե */
#define INT_DEI2        116         /* DMACͥ2 ȥ󥹥ե */
#define INT_HEI2        117         /* DMACͥ2 ϡե */
#define INT_DEI3        120         /* DMACͥ3 ȥ󥹥ե */
#define INT_HEI3        121         /* DMACͥ3 ϡե */
#define INT_DEI4        124         /* DMACͥ4 ȥ󥹥ե */
#define INT_HEI4        125         /* DMACͥ4 ϡե */
#define INT_DEI5        128         /* DMACͥ5 ȥ󥹥ե */
#define INT_HEI5        129         /* DMACͥ5 ϡե */
#define INT_DEI6        132         /* DMACͥ6 ȥ󥹥ե */
#define INT_HEI6        133         /* DMACͥ6 ϡե */
#define INT_DEI7        136         /* DMACͥ7 ȥ󥹥ե */
#define INT_HEI7        137         /* DMACͥ7 ϡե */
#define INT_DEI8        140         /* DMACͥ8 ȥ󥹥ե */
#define INT_HEI8        141         /* DMACͥ8 ϡե */
#define INT_DEI9        144         /* DMACͥ9 ȥ󥹥ե */
#define INT_HEI9        145         /* DMACͥ9 ϡե */
#define INT_DEI10       148         /* DMACͥ10 ȥ󥹥ե */
#define INT_HEI10       149         /* DMACͥ10 ϡե */
#define INT_DEI11       152         /* DMACͥ11 ȥ󥹥ե */
#define INT_HEI11       153         /* DMACͥ11 ϡե */
#define INT_DEI12       156         /* DMACͥ12 ȥ󥹥ե */
#define INT_HEI12       157         /* DMACͥ12 ϡե */
#define INT_DEI13       160         /* DMACͥ13 ȥ󥹥ե */
#define INT_HEI13       161         /* DMACͥ13 ϡե */
#define INT_DEI14       164         /* DMACͥ14 ȥ󥹥ե */
#define INT_HEI14       165         /* DMACͥ14 ϡե */
#define INT_DEI15       168         /* DMACͥ15 ȥ󥹥ե */
#define INT_HEI15       169         /* DMACͥ15 ϡե */
#define INT_USBI        170         /* USBȥ */
#define INT_VIVSYNCJ    171         /* ӥǥǥץ쥤ȥ3 VSYNC측 */
#define INT_VBUFFER     172         /* ӥǥǥץ쥤ȥ3 Хåե顼 */
#define INT_VIFIELDE    173         /* ӥǥǥץ쥤ȥ3 եɽ񤭹ߴλ */
#define INT_VOLINE      174         /* ӥǥǥץ쥤ȥ3 饤 */
#define INT_CMI0        175         /* CMTͥ0 ڥޥå */
#define INT_CMI1        176         /* CMTͥ1 ڥޥå */
#define INT_CMI         177         /* BSC եå奿ޥڥޥå */
#define INT_ITI         178         /* WDT 󥿡Х륿޳ */
#define INT_TGI0A       179         /* MTU2 TGRA0 ץåȥץ㡿ڥޥå */
#define INT_TGI0B       180         /* MTU2 TGRB0 ץåȥץ㡿ڥޥå */
#define INT_TGI0C       181         /* MTU2 TGRC0 ץåȥץ㡿ڥޥå */
#define INT_TGI0D       182         /* MTU2 TGRD0 ץåȥץ㡿ڥޥå */
#define INT_TGI0V       183         /* MTU2 TCNT0 Хե */
#define INT_TGI0E       184         /* MTU2 TGRE0 ڥޥå */
#define INT_TGI0F       185         /* MTU2 TGRF0 ڥޥå */
#define INT_TGI1A       186         /* MTU2 TGRA1 ץåȥץ㡿ڥޥå */
#define INT_TGI1B       187         /* MTU2 TGRB1 ץåȥץ㡿ڥޥå */
#define INT_TGI1V       188         /* MTU2 TCNT1 Хե */
#define INT_TGI1U       189         /* MTU2 TCNT1 ե */
#define INT_TGI2A       190         /* MTU2 TGRA2 ץåȥץ㡿ڥޥå */
#define INT_TGI2B       191         /* MTU2 TGRA2 ץåȥץ㡿ڥޥå */
#define INT_TGI2V       192         /* MTU2 TCNT2 Хե */
#define INT_TGI2U       193         /* MTU2 TCNT2 ե */
#define INT_TGI3A       194         /* MTU2 TGRA3 ץåȥץ㡿ڥޥå */
#define INT_TGI3B       195         /* MTU2 TGRB3 ץåȥץ㡿ڥޥå */
#define INT_TGI3C       196         /* MTU2 TGRC3 ץåȥץ㡿ڥޥå */
#define INT_TGI3D       197         /* MTU2 TGRD3 ץåȥץ㡿ڥޥå */
#define INT_TGI3V       198         /* MTU2 TCNT3 Хե */
#define INT_TGI4A       199         /* MTU2 TGRA4 ץåȥץ㡿ڥޥå */
#define INT_TGI4B       200         /* MTU2 TGRB4 ץåȥץ㡿ڥޥå */
#define INT_TGI4C       201         /* MTU2 TGRC4 ץåȥץ㡿ڥޥå */
#define INT_TGI4D       202         /* MTU2 TGRD4 ץåȥץ㡿ڥޥå */
#define INT_TGI4V       203         /* MTU2 TCNT4 Хեե */
#define INT_CMF1        204         /* PWMͥ1 ڥޥåե饰 */
#define INT_CMF2        205         /* PWMͥ2 ڥޥåե饰 */
#define INT_ADI         206         /* A/DѴ Ѵλ */
#define INT_SSIF0       207         /* SSIͥ0 SSIF0 */
#define INT_SSIRXI0     208         /* SSIͥ0 SSIRXI0 */
#define INT_SSITXI0     209         /* SSIͥ0 SSITXI0 */
#define INT_SSII1       210         /* SSIͥ1 SSII1 */
#define INT_SSIRTI1     211         /* SSIͥ1 SSIRTI1 */
#define INT_SSII2       212         /* SSIͥ2 SSII2 */
#define INT_SSIRTI2     213         /* SSIͥ2 SSIRTI2 */
#define INT_SSII3       214         /* SSIͥ3 SSII2 */
#define INT_SSIRTI3     215         /* SSIͥ3 SSIRTI2 */
#define INT_SPDIFI      216         /* SPDIF󥿡ե */
#define INT_IIC3STPI0   217         /* IIC3ͥ0 ߾︡ */
#define INT_IIC3NAKI0   218         /* IIC3ͥ0 NACK  */
#define INT_IIC3RXI0    219         /* IIC3ͥ0 ǡե */
#define INT_IIC3TXI0    220         /* IIC3ͥ0 ǡץƥ */
#define INT_IIC3TEI0    221         /* IIC3ͥ0 λ */
#define INT_IIC3STPI1   222         /* IIC3ͥ1 ߾︡ */
#define INT_IIC3NAKI1   223         /* IIC3ͥ1 NACK  */
#define INT_IIC3RXI1    224         /* IIC3ͥ1 ǡե */
#define INT_IIC3TXI1    225         /* IIC3ͥ1 ǡץƥ */
#define INT_IIC3TEI1    226         /* IIC3ͥ1 λ */
#define INT_IIC3STPI2   227         /* IIC3ͥ2 ߾︡ */
#define INT_IIC3NAKI2   228         /* IIC3ͥ2 NACK  */
#define INT_IIC3RXI2    229         /* IIC3ͥ2 ǡե */
#define INT_IIC3TXI2    230         /* IIC3ͥ2 ǡץƥ */
#define INT_IIC3TEI2    231         /* IIC3ͥ2 λ */
#define INT_BRI0        232         /* SCIFͥ0 ֥졼 */
#define INT_ERI0        233         /* SCIFͥ0 顼 */
#define INT_RXI0        234         /* SCIFͥ0 ǡե */
#define INT_TXI0        235         /* SCIFͥ0 FIFOǡץƥ */
#define INT_BRI1        236         /* SCIFͥ1 ֥졼 */
#define INT_ERI1        237         /* SCIFͥ1 顼 */
#define INT_RXI1        238         /* SCIFͥ1 ǡե */
#define INT_TXI1        239         /* SCIFͥ1 FIFOǡץƥ */
#define INT_BRI2        240         /* SCIFͥ2 ֥졼 */
#define INT_ERI2        241         /* SCIFͥ2 顼 */
#define INT_RXI2        242         /* SCIFͥ2 ǡե */
#define INT_TXI2        243         /* SCIFͥ2 FIFOǡץƥ */
#define INT_BRI3        244         /* SCIFͥ3 ֥졼 */
#define INT_ERI3        245         /* SCIFͥ3 顼 */
#define INT_RXI3        246         /* SCIFͥ3 ǡե */
#define INT_TXI3        247         /* SCIFͥ3 FIFOǡץƥ */
#define INT_BRI4        248         /* SCIFͥ4 ֥졼 */
#define INT_ERI4        249         /* SCIFͥ4 顼 */
#define INT_RXI4        250         /* SCIFͥ4 ǡե */
#define INT_TXI4        251         /* SCIFͥ4 FIFOǡץƥ */
#define INT_BRI5        252         /* SCIFͥ5 ֥졼 */
#define INT_ERI5        253         /* SCIFͥ5 顼 */
#define INT_RXI5        254         /* SCIFͥ5 ǡե */
#define INT_TXI5        255         /* SCIFͥ5 FIFOǡץƥ */
#define INT_BRI6        256         /* SCIFͥ6 ֥졼 */
#define INT_ERI6        257         /* SCIFͥ6 顼 */
#define INT_RXI6        258         /* SCIFͥ6 ǡե */
#define INT_TXI6        259         /* SCIFͥ6 FIFOǡץƥ */
#define INT_BRI7        260         /* SCIFͥ7 ֥졼 */
#define INT_ERI7        261         /* SCIFͥ7 顼 */
#define INT_RXI7        262         /* SCIFͥ7 ǡե */
#define INT_TXI7        263         /* SCIFͥ7 FIFOǡץƥ */
#define INT_SIOFI       264         /* SIOF */
#define INT_SPEI0       265         /* SPIͥ0 顼 */
#define INT_SPRI0       266         /* SPIͥ0 Хåեե */
#define INT_SPTI0       267         /* SPIͥ0 ץƥ*/
#define INT_SPEI1       268         /* SPIͥ1 顼 */
#define INT_SPRI1       269         /* SPIͥ1 Хåեե */
#define INT_SPTI1       270         /* SPIͥ1 ץƥ*/
#define INT_ERS0        271         /* RCANͥ0 ERSװ */
#define INT_OVR0        272         /* RCANͥ0 OVRװ */
#define INT_RM00        273         /* RCANͥ0 ǡե졼 */
#define INT_RM10        274         /* RCANͥ0 ⡼ȥե졼 */
#define INT_SLE0        275         /* RCANͥ0 å */
#define INT_ERS1        276         /* RCANͥ1 ERSװ */
#define INT_OVR1        277         /* RCANͥ1 OVRװ */
#define INT_RM01        278         /* RCANͥ1 ǡե졼 */
#define INT_RM11        279         /* RCANͥ1 ⡼ȥե졼 */
#define INT_SLE1        280         /* RCANͥ1 å */
#define INT_IEBI        281         /* IEBusȥ */
#define INT_ISY         282         /* CD-ROMǥ Ʊɰ۾勵ߥ */
#define INT_IERR        283         /* CD-ROMǥ ECC顼 */
#define INT_IARG        284         /* CD-ROMǥ ITARG顼 */
#define INT_ISEC        285         /* CD-ROMǥ ڤؤ */
#define INT_IBUF        286         /* CD-ROMǥ Хåեǡž */
#define INT_IREDAY      287         /* CD-ROMǥ Хåեǡž׵ */
#define INT_FLSTEI      288         /* NANDեå女ȥ STEIװ */
#define INT_FLTENDI     289         /* NANDեå女ȥ žλ */
#define INT_FLTREQ0I    290         /* NANDեå女ȥ FIFO0ž׵ */
#define INT_FLTREQ1I    291         /* NANDեå女ȥ FIFO0ž׵ */
#define INT_SDHI3       292         /* SDۥȥ󥿡ե SDHI3 */
#define INT_SDHI0       293         /* SDۥȥ󥿡ե SDHI0 */
#define INT_SDHI1       294         /* SDۥȥ󥿡ե SDHI1 */
#define INT_ARM         296         /* RTC 顼 */
#define INT_PRD         297         /* RTC  */
#define INT_CUP         298         /* RTC 夲 */
#define INT_OVF0        299         /* SRCͥ0 ϥǡFIFOС饤 */
#define INT_UDF0        300         /* SRCͥ0 ϥǡFIFOե */
#define INT_CEF0        301         /* SRCͥ0 Ѵλ */
#define INT_ODFI0       302         /* SRCͥ0 ϥǡFIFOե */
#define INT_IDEI0       303         /* SRCͥ0 ϥǡFIFOץƥ */
#define INT_OVF1        304         /* SRCͥ1 ϥǡFIFOС饤 */
#define INT_UDF1        305         /* SRCͥ1 ϥǡFIFOե */
#define INT_CEF1        306         /* SRCͥ1 Ѵλ */
#define INT_ODFI1       307         /* SRCͥ1 ϥǡFIFOե */
#define INT_IDEI1       308         /* SRCͥ1 ϥǡFIFOץƥ */
#define INT_DCUEI       310         /* ǥץå˥å DCUEI */
#define INT_OFFI        311         /* ǥץå˥å OFFI */
#define INT_IFEI        312         /* ǥץå˥å IFEI */

#ifndef _MACRO_ONLY

/*
 *  ¢⥸塼Υ쥸
 */
/* å */
#define CCR1        ((VW *)0xFFFC1000)  /* å쥸1 */
#define CCR2        ((VW *)0xFFFC1004)  /* å쥸2 */

/* åȯ (CPG) */
#define FRQCR       ((VH *)0xFFFE0010)  /* ȿ쥸 */

/* Хơȥȥ (BSC) */
#define CMNCR       ((VW *)0xFFFC0000)  /* ̥ȥ쥸 */
#define CS0BCR      ((VW *)0xFFFC0004)  /* ꥢ0 Хȥ쥸 */
#define CS1BCR      ((VW *)0xFFFC0008)  /* ꥢ1 Хȥ쥸 */
#define CS2BCR      ((VW *)0xFFFC000C)  /* ꥢ2 Хȥ쥸 */
#define CS3BCR      ((VW *)0xFFFC0010)  /* ꥢ3 Хȥ쥸 */
#define CS4BCR      ((VW *)0xFFFC0014)  /* ꥢ4 Хȥ쥸 */
#define CS5BCR      ((VW *)0xFFFC0018)  /* ꥢ5 Хȥ쥸 */
#define CS6BCR      ((VW *)0xFFFC001C)  /* ꥢ6 Хȥ쥸 */
#define CS7BCR      ((VW *)0xFFFC0020)  /* ꥢ7 Хȥ쥸 */
#define CS0WCR      ((VW *)0xFFFC0028)  /* ꥢ0 ȥȥ쥸 */
#define CS1WCR      ((VW *)0xFFFC002C)  /* ꥢ1 ȥȥ쥸 */
#define CS2WCR      ((VW *)0xFFFC0030)  /* ꥢ2 ȥȥ쥸 */
#define CS3WCR      ((VW *)0xFFFC0034)  /* ꥢ3 ȥȥ쥸 */
#define CS4WCR      ((VW *)0xFFFC0038)  /* ꥢ4 ȥȥ쥸 */
#define CS5WCR      ((VW *)0xFFFC003C)  /* ꥢ5 ȥȥ쥸 */
#define CS6WCR      ((VW *)0xFFFC0040)  /* ꥢ6 ȥȥ쥸 */
#define CS7WCR      ((VW *)0xFFFC0044)  /* ꥢ7 ȥȥ쥸 */
#define SDCR        ((VW *)0xFFFC004C)  /* SDRAMȥ쥸 */
#define RTCSR       ((VW *)0xFFFC0050)  /* եå奿ޥȥ/ơ쥸 */
#define RTCNT       ((VW *)0xFFFC0054)  /* եå奿ޥ */
#define RTCOR       ((VW *)0xFFFC0058)  /* եå奿ॳ󥹥ȥ쥸 */
#define ACSWR       ((VW *)0xFFFC180C)  /* ACڤؤ쥸 */
#define ACKEYR      ((VB *)0xFFFC1BFC)  /* ACڤؤ쥸 */

/* ߥȥ (INTC) */
#define ICR0        ((VH *)0xFFFE0800)  /* ߥȥ쥸0 */
#define ICR1        ((VH *)0xFFFE0802)  /* ߥȥ쥸1 */
#define ICR2        ((VH *)0xFFFE0804)  /* ߥȥ쥸2 */
#define IRQRR       ((VH *)0xFFFE0806)  /* IRQ ׵쥸 */
#define PINTER      ((VH *)0xFFFE0808)  /* PINT ߥ֥͡쥸 */
#define PIRR        ((VH *)0xFFFE080A)  /* PINT ׵쥸 */
#define IBCR        ((VH *)0xFFFE080C)  /* Х󥯥ȥ쥸 */
#define IBNR        ((VH *)0xFFFE080E)  /* Хֹ쥸 */
#define IPR01       ((VH *)0xFFFE0818)  /* ͥ٥쥸01 */
#define IPR02       ((VH *)0xFFFE081A)  /* ͥ٥쥸02 */
#define IPR05       ((VH *)0xFFFE0820)  /* ͥ٥쥸05 */
#define IPR06       ((VH *)0xFFFE0C00)  /* ͥ٥쥸06 */
#define IPR07       ((VH *)0xFFFE0C02)  /* ͥ٥쥸07 */
#define IPR08       ((VH *)0xFFFE0C04)  /* ͥ٥쥸08 */
#define IPR09       ((VH *)0xFFFE0C06)  /* ͥ٥쥸09 */
#define IPR10       ((VH *)0xFFFE0C08)  /* ͥ٥쥸10 */
#define IPR11       ((VH *)0xFFFE0C0A)  /* ͥ٥쥸11 */
#define IPR12       ((VH *)0xFFFE0C0C)  /* ͥ٥쥸12 */
#define IPR13       ((VH *)0xFFFE0C0E)  /* ͥ٥쥸13 */
#define IPR14       ((VH *)0xFFFE0C10)  /* ͥ٥쥸14 */
#define IPR16       ((VH *)0xFFFE0C12)  /* ͥ٥쥸15 */
#define IPR15       ((VH *)0xFFFE0C14)  /* ͥ٥쥸16 */
#define IPR17       ((VH *)0xFFFE0C16)  /* ͥ٥쥸17 */
#define IPR18       ((VH *)0xFFFE0C18)  /* ͥ٥쥸18 */
#define IPR19       ((VH *)0xFFFE0C1A)  /* ͥ٥쥸19 */
#define IPR20       ((VH *)0xFFFE0C1C)  /* ͥ٥쥸20 */
#define IPR21       ((VH *)0xFFFE0C1E)  /* ͥ٥쥸21 */
#define IPR22       ((VH *)0xFFFE0C20)  /* ͥ٥쥸22 */

/* ڥޥå (CMT) */
#define CMSTR       ((VH *)0xFFFEC000)  /* ڥޥåޥȥ쥸 */
#define CMCSR_0     ((VH *)0xFFFEC002)  /* ͥ0 ڥޥå󥿥ȥ/ơ쥸 */
#define CMCNT_0     ((VH *)0xFFFEC004)  /* ͥ0 ڥޥå */
#define CMCOR_0     ((VH *)0xFFFEC006)  /* ͥ0 ڥޥå󥹥ȥ쥸 */
#define CMCSR_1     ((VH *)0xFFFEC008)  /* ͥ1 ڥޥå󥿥ȥ/ơ쥸 */
#define CMCNT_1     ((VH *)0xFFFEC00A)  /* ͥ1 ڥޥå */
#define CMCOR_1     ((VH *)0xFFFEC00C)  /* ͥ1 ڥޥå󥹥ȥ쥸 */

/* ԥե󥯥󥳥ȥ (PFC), I/Oݡ */
#define PAIOR0      ((VH *)0xFFFE3812)  /* ݡA IO쥸0 */
#define PADR1       ((VH *)0xFFFE3814)  /* ݡA ǡ쥸1 */
#define PADR0       ((VH *)0xFFFE3816)  /* ݡA ǡ쥸0 */
#define PAPR0       ((VH *)0xFFFE381A)  /* ݡA ݡȥ쥸0 */
#define PBCR5       ((VH *)0xFFFE3824)  /* ݡB ȥ쥸5 */
#define PBCR4       ((VH *)0xFFFE3826)  /* ݡB ȥ쥸4 */
#define PBCR3       ((VH *)0xFFFE3828)  /* ݡB ȥ쥸3 */
#define PBCR2       ((VH *)0xFFFE382A)  /* ݡB ȥ쥸2 */
#define PBCR1       ((VH *)0xFFFE382C)  /* ݡB ȥ쥸1 */
#define PBCR0       ((VH *)0xFFFE382E)  /* ݡB ȥ쥸0 */
#define PBIOR1      ((VH *)0xFFFE3830)  /* ݡB IO쥸1 */
#define PBIOR0      ((VH *)0xFFFE3832)  /* ݡB IO쥸0 */
#define PBDR1       ((VH *)0xFFFE3834)  /* ݡB ǡ쥸1 */
#define PBDR0       ((VH *)0xFFFE3836)  /* ݡB ǡ쥸0 */
#define PBPR1       ((VH *)0xFFFE3838)  /* ݡB ݡȥ쥸1 */
#define PBPR0       ((VH *)0xFFFE383A)  /* ݡB ݡȥ쥸1 */
#define PCCR2       ((VH *)0xFFFE384A)  /* ݡC ȥ쥸2 */
#define PCCR1       ((VH *)0xFFFE384C)  /* ݡC ȥ쥸1 */
#define PCCR0       ((VH *)0xFFFE384E)  /* ݡC ȥ쥸0 */
#define PCIOR0      ((VH *)0xFFFE3852)  /* ݡC IO쥸0 */
#define PCDR0       ((VH *)0xFFFE3856)  /* ݡC ǡ쥸0 */
#define PCPR0       ((VH *)0xFFFE385A)  /* ݡC ݡȥ쥸1 */
#define PDCR3       ((VH *)0xFFFE3868)  /* ݡD ȥ쥸3 */
#define PDCR2       ((VH *)0xFFFE386A)  /* ݡD ȥ쥸2 */
#define PDCR1       ((VH *)0xFFFE386C)  /* ݡD ȥ쥸1 */
#define PDCR0       ((VH *)0xFFFE386E)  /* ݡD ȥ쥸0 */
#define PDIOR0      ((VH *)0xFFFE3872)  /* ݡD IO쥸0 */
#define PDDR0       ((VH *)0xFFFE3876)  /* ݡD ǡ쥸0 */
#define PDPR0       ((VH *)0xFFFE387A)  /* ݡD ݡȥ쥸1 */
#define PECR1       ((VH *)0xFFFE388C)  /* ݡD ȥ쥸1 */
#define PECR0       ((VH *)0xFFFE388E)  /* ݡD ȥ쥸0 */
#define PEIOR0      ((VH *)0xFFFE3892)  /* ݡD IO쥸0 */
#define PEDR0       ((VH *)0xFFFE3896)  /* ݡD ǡ쥸0 */
#define PEPR0       ((VH *)0xFFFE389A)  /* ݡD ݡȥ쥸1 */
#define PFCR3       ((VH *)0xFFFE38A8)  /* ݡF ȥ쥸3 */
#define PFCR2       ((VH *)0xFFFE38AA)  /* ݡF ȥ쥸2 */
#define PFCR1       ((VH *)0xFFFE38AC)  /* ݡF ȥ쥸1 */
#define PFCR0       ((VH *)0xFFFE38AE)  /* ݡF ȥ쥸0 */
#define PFIOR0      ((VH *)0xFFFE38B2)  /* ݡF IO쥸0 */
#define PFDR0       ((VH *)0xFFFE38B6)  /* ݡF ǡ쥸0 */
#define PFPR0       ((VH *)0xFFFE38BA)  /* ݡF ݡȥ쥸1 */
#define PGCR7       ((VH *)0xFFFE38C0)  /* ݡG ȥ쥸5 */
#define PGCR6       ((VH *)0xFFFE38C2)  /* ݡG ȥ쥸5 */
#define PGCR5       ((VH *)0xFFFE38C4)  /* ݡG ȥ쥸5 */
#define PGCR4       ((VH *)0xFFFE38C6)  /* ݡG ȥ쥸4 */
#define PGCR3       ((VH *)0xFFFE38C8)  /* ݡG ȥ쥸3 */
#define PGCR2       ((VH *)0xFFFE38CA)  /* ݡG ȥ쥸2 */
#define PGCR1       ((VH *)0xFFFE38CC)  /* ݡG ȥ쥸1 */
#define PGCR0       ((VH *)0xFFFE38CE)  /* ݡG ȥ쥸0 */
#define PGIOR1      ((VH *)0xFFFE38D0)  /* ݡG IO쥸1 */
#define PGIOR0      ((VH *)0xFFFE38D2)  /* ݡG IO쥸0 */
#define PGDR1       ((VH *)0xFFFE38D4)  /* ݡG ǡ쥸1 */
#define PGDR0       ((VH *)0xFFFE38D6)  /* ݡG ǡ쥸0 */
#define PGPR1       ((VH *)0xFFFE38D8)  /* ݡG ݡȥ쥸1 */
#define PGPR0       ((VH *)0xFFFE38DA)  /* ݡG ݡȥ쥸1 */
#define PHCR1       ((VH *)0xFFFE38EC)  /* ݡH ȥ쥸1 */
#define PHCR0       ((VH *)0xFFFE38EE)  /* ݡH ȥ쥸0 */
#define PHPR0       ((VH *)0xFFFE38FA)  /* ݡH ݡȥ쥸1 */
#define PJCR2       ((VH *)0xFFFE390A)  /* ݡJ ȥ쥸2 */
#define PJCR1       ((VH *)0xFFFE390C)  /* ݡJ ȥ쥸1 */
#define PJCR0       ((VH *)0xFFFE390E)  /* ݡJ ȥ쥸0 */
#define PJIOR0      ((VH *)0xFFFE3912)  /* ݡJ IO쥸0 */
#define PJDR0       ((VH *)0xFFFE3916)  /* ݡJ ǡ쥸0 */
#define PJPR0       ((VH *)0xFFFE391A)  /* ݡJ ݡȥ쥸1 */
#define PKCR2       ((VH *)0xFFFE392A)  /* ݡK ȥ쥸2 */
#define PKCR1       ((VH *)0xFFFE392C)  /* ݡK ȥ쥸1 */
#define PKCR0       ((VH *)0xFFFE392E)  /* ݡK ȥ쥸0 */
#define PKIOR0      ((VH *)0xFFFE3932)  /* ݡK IO쥸0 */
#define PKDR0       ((VH *)0xFFFE3936)  /* ݡK ǡ쥸0 */
#define PKPR0       ((VH *)0xFFFE393A)  /* ݡK ݡȥ쥸1 */

/* ϥ⡼ */
#define STBCR1      ((VB *)0xFFFE0014)  /* Хȥ쥸1 */
#define STBCR2      ((VB *)0xFFFE0018)  /* Хȥ쥸2 */
#define STBCR3      ((VB *)0xFFFE0408)  /* Хȥ쥸3 */
#define STBCR4      ((VB *)0xFFFE040C)  /* Хȥ쥸4 */
#define STBCR5      ((VB *)0xFFFE0410)  /* Хȥ쥸5 */
#define STBCR6      ((VB *)0xFFFE0414)  /* Хȥ쥸6 */
#define STBCR7      ((VB *)0xFFFE0418)  /* Хȥ쥸7 */
#define STBCR8      ((VB *)0xFFFE041C)  /* Хȥ쥸8 */
#define SWRSTCR     ((VB *)0xFFFE0430)  /* եȥꥻåȥȥ쥸8 */
#define SYSCR1      ((VB *)0xFFFE0400)  /* ƥॳȥ쥸1 */
#define SYSCR2      ((VB *)0xFFFE0404)  /* ƥॳȥ쥸2 */
#define SYSCR3      ((VB *)0xFFFE0420)  /* ƥॳȥ쥸3 */
#define SYSCR4      ((VB *)0xFFFE0424)  /* ƥॳȥ쥸4 */
#define SYSCR5      ((VB *)0xFFFE0428)  /* ƥॳȥ쥸5 */
#define RRAMKP      ((VB *)0xFFFE6800)  /* ݻ¢RAM ݻꥢ쥸 */
#define DSCTR       ((VB *)0xFFFE6802)  /* ǥץХȥ쥸 */
#define DSSSR       ((VH *)0xFFFE6804)  /* ǥץХװ쥯ȥ쥸 */
#define DSESR       ((VH *)0xFFFE6806)  /* ǥץХå쥯ȥ쥸 */
#define DSFR        ((VH *)0xFFFE6808)  /* ǥץХװե饰쥸 */
#define XTALCTR     ((VB *)0xFFFE6810)  /* XTAL徽ȯ沈󥳥ȥ쥸 */

/* FIFOդꥢ륳ߥ˥󥤥󥿡ե (SCIF) */

#define SCIF0_BASE  ((UW)0xFFFE8000)    /* ͥ0 쥸١ɥ쥹 */
#define SCIF1_BASE  ((UW)0xFFFE8800)    /* ͥ1 쥸١ɥ쥹 */
#define SCIF2_BASE  ((UW)0xFFFE9000)    /* ͥ2 쥸١ɥ쥹 */
#define SCIF3_BASE  ((UW)0xFFFE9800)    /* ͥ3 쥸١ɥ쥹 */
#define SCIF4_BASE  ((UW)0xFFFEA000)    /* ͥ4 쥸١ɥ쥹 */
#define SCIF5_BASE  ((UW)0xFFFEA800)    /* ͥ5 쥸١ɥ쥹 */
#define SCIF6_BASE  ((UW)0xFFFEB000)    /* ͥ6 쥸١ɥ쥹 */
#define SCIF7_BASE  ((UW)0xFFFEB800)    /* ͥ7 쥸١ɥ쥹 */

/*
 * ߥȥν
 */
Inline void sh2_init_intcontorller(void)
{
	/* Хֹ쥸 */
	sil_wrh_mem(IBNR, 0x0000);		/* BE=00, BOVE=0                         */
									/*  ٤ƤγߤǥХ󥯻Ѷػ     */
									/*  쥸Х󥯥Сե㳰ػ */
	/* ͥ٥쥸 */
	sil_wrh_mem (IPR01, 0x0000);
	sil_wrh_mem (IPR02, 0x0000);
	sil_wrh_mem (IPR05, 0x0000);
	sil_wrh_mem (IPR06, 0x0000);
	sil_wrh_mem (IPR07, 0x0000);
	sil_wrh_mem (IPR08, 0x0000);
	sil_wrh_mem (IPR09, 0x0000);
	sil_wrh_mem (IPR10, 0x0000);
	sil_wrh_mem (IPR11, 0x0000);
	sil_wrh_mem (IPR12, 0x0000);
	sil_wrh_mem (IPR13, 0x0000);
	sil_wrh_mem (IPR14, 0x0000);
	sil_wrh_mem (IPR15, 0x0000);
	sil_wrh_mem (IPR16, 0x0000);
	sil_wrh_mem (IPR17, 0x0000);
	sil_wrh_mem (IPR18, 0x0000);
	sil_wrh_mem (IPR19, 0x0000);
	sil_wrh_mem (IPR20, 0x0000);
	sil_wrh_mem (IPR21, 0x0000);
	sil_wrh_mem (IPR22, 0x0000);
}

#endif /* _MACRO_ONLY */

#endif /* _SH7262_H_ */
