/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */

/*
 *	åȰ¸ޥ⥸塼D70F3716GC ¢ѡ
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>

#ifndef _MACRO_ONLY

/* ƥॿޡTMM0 */
#define	TIMER_INT_PRIORITY		0		/* ͥ(0ǹ7) */
#define	TIMER_COMPAREVALUE		((CPU_CLOCK>>1)/1000)		/* fx/21msec */


#define WAIT __asm("nop;nop;nop;nop;nop");

/*
 *  ޳ߥϥɥΥ٥ֹ
 */
#define	INHNO_TIMER	       (0x28)

/*
 *  ͤɽη
 */
typedef UW	CLOCK;

#define TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)      ((clock) * 1000 / TIMER_CLOCK)

/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
hw_timer_initialize(void)
{
	/* ޽ */
	sil_wrb_mem((VP)TM0CTL0, sil_reb_mem((VP)TM0CTL0) | ~0x80);	/* Stop */
	sil_wrb_mem((VP)TM0CTL0, 1);		/* fx/2 */
	sil_wrh_mem((VP)TM0CMP0, TIMER_COMPAREVALUE);
	sil_wrb_mem((VP)TM0CTL0, 0x80 | sil_reb_mem((VP)TM0CTL0));	/* Start */

	/* ׵ĤġߵĤˤơͥ٤ꤹ */
	sil_wrb_mem((VP)TM0EQIC0, TIMER_INT_PRIORITY);
}

/*
 *  ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear(void)
{
}

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
Inline void
hw_timer_terminate(void)
{
	/* ߤޥ */
	sil_wrb_mem((VP)TM0EQIC0, sil_reb_mem((VP)TM0EQIC0) | 0x40);
	sil_wrb_mem((VP)TM0CTL0, (~0x08) & sil_reb_mem((VP)TM0CTL0));	/* Stop */
}

/*
 *  ޤθͤɽФ
 */
Inline CLOCK
hw_timer_get_current(void)
{
	return 0;
}

/*
 *  ޳׵Υå
 */
Inline BOOL
hw_timer_fetch_interrupt(void)
{
	return (sil_reb_mem((VP)TM0EQIC0) & 0x80) != 0;
}

#endif /* _MACRO_ONLY */

#endif /* _HW_TIMER_H_ */
