/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2002 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005 by Freelines CO.,Ltd 
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.2 2007/01/05 02:10:17 honda Exp $
 */

/*
 *	åȰ¸ޥ⥸塼V850ES/SG2¢P-ch0(TMP0)ѡ
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>

#ifndef _MACRO_ONLY

/* ƥॿޡTMP0 */
#define	TIMER_INT_PRIORITY		0		/* ͥ(0ǹ7) */
#define TIMER_CLKDIV			1		/* fx/2=10MHz */
#define	TIMER_COMPAREVALUE		(10000-1)	/* fx/21msec */

/*
 *  ޳ߥϥɥΥ٥ֹ
 */
#define	INHNO_TIMER	       (0x17)

/*
 *  ͤɽη
 */
typedef UW	CLOCK;

#define TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)      ((clock) * 1000 / TIMER_CLOCK)

/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
hw_timer_initialize(void)
{
	/* ޽ */
	sil_wrb_mem((VP)TP0CTL0, 1);		/* fx/2 (count stop) */
	sil_wrb_mem((VP)TP0CTL1, 0);		/* interval mode */
	sil_wrb_mem((VP)TP0IOC0, 1);		/* TOP00 clock out */
	sil_wrh_mem((VP)TP0CCR0, TIMER_COMPAREVALUE);
	sil_wrb_mem((VP)TP0CTL0, 0x81);		/* Count Start */

	/* ׵ĤġߵĤˤơͥ٤ꤹ */
	sil_wrb_mem((VP)TP0CCIC0, TIMER_INT_PRIORITY);
}

/*
 *  ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear(void)
{
}

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
Inline void
hw_timer_terminate(void)
{
	/* ߤޥ */
	sil_wrb_mem((VP)TP0CCIC0, sil_reb_mem((VP)TP0CCIC0) | 0x47);
}

/*
 *  ޤθͤɽФ
 */
Inline CLOCK
hw_timer_get_current(void)
{
	return sil_rew_mem((VP)TP0CNT);
}

/*
 *  ޳׵Υå
 */
Inline BOOL
hw_timer_fetch_interrupt(void)
{
	return (sil_reb_mem((VP)TP0CCIC0) & 0x80) != 0;
}

#endif /* _MACRO_ONLY */

#endif /* _HW_TIMER_H_ */
