/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_serial.h,v 1.9 2003/12/15 07:19:22 takayuki Exp $
 */



/*
 *  TOPPERS/JSP for Windows - ꥢ륨ߥ졼
 */

#ifndef __HW_SERIAL_H
#define __HW_SERIAL_H

#include <s_services.h>

/*
 *  Хå롼μֹ
 *  OPB_UARTLITE ϡߤʬƤʤᡤ̣Ϥʤ
 */
#define SIO_ERDY_SND    1u              /* ǽХå */
#define SIO_ERDY_RCV    2u              /* ΥХå */

	/* ǥХ򳫤¦ */
#define SIO_MOD_MASK		0x80000000
#define SIO_MOD(x)			((x) & SIO_MOD_MASK)
#define SIO_MOD_SERVER		0x80000000
#define SIO_MOD_CLIENT		0x00000000

	/* ǥХμ */
#define SIO_TYP_MASK		0x000000ff
#define SIO_TYP(x)			((x) & SIO_TYP_MASK)
#define SIO_TYP_CONSOLE		0x00000001			/* ɥ󥽡  */
#define SIO_TYP_TTY			0x00000002			/* WindowsΥ󥽡 */
#define SIO_TYP_SCRBUF		0x00000003			/* ꡼Хåե    */
#define SIO_TYP_RAWSIO		0x00000004			/* ꥢ              */

	/* ǥХξ */
#define SIO_STA_MASK		0x0fff0000
#define SIO_STA(x)			((x) & SIO_STA_MASK)
#define SIO_STA_OPEN		0x00010000
#define SIO_STA_INTRCV		0x00020000
#define SIO_STA_INTSND		0x00040000

#define INHNO_SERIAL	3

#define TNUM_PORT		1

#ifndef _MACRO_ONLY

typedef struct serial_port_descriptor
{
	int					Flag;
	HANDLE				Handle;
	volatile int		ReceiveBuffer;
	void *				versatile;
	VP_INT              exinf;
} SIOPCB;

extern SIOPCB siopcb_table[TNUM_PORT];

/*
 *  SIOɥ饤Фν롼
 */
extern void	sio_initialize(void);

/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB * sio_opn_por(ID siopid, VP_INT exinf);

/*
 *  ꥢI/OݡȤΥ
 */
extern void	sio_cls_por(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤؤʸ
 */
extern BOOL	sio_snd_chr(SIOPCB *siopcb, INT chr);

/*
 *  ꥢI/OݡȤؤʸ
 */
extern INT	sio_rcv_chr(SIOPCB *siopcb);

/*
 *  SIOγߥӥ롼
 */
extern void	sio_isr(void);

/*
 *  ꥢI/OݡȤΥХåε
 */
extern void sio_ena_cbr(SIOPCB * siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void sio_dis_cbr(SIOPCB * siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤؤʸλХå
 */
extern void sio_ierdy_snd(VP_INT exinf);

/*
 *  ꥢI/OݡȤؤʸλХå
 */
extern void sio_ierdy_rcv(VP_INT exinf);

/*
 *  ꥢI/OݡȤʸΥХå
 */
extern void	sio_ercv_chr(ID siopid, INT chr);

/*
 *  ꥢI/Oݡȳߥϥɥ
 */
extern void	sio_handler(void);

#endif

#endif

