/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003      by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣѡ
 *  ۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ǤǺۤˤϡۤȼɥȡѼԥ
 *      ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ̵
 *      ڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ǤʤǺۤˤϡΤ줫ξȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡޤ
 *      ܥեȥΥ桼ޤϥɥ桼Τʤͳ˴
 *      ᤫ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪФ
 *  ŬޤơʤݾڤԤʤޤܥեȥ
 *  ˤľŪޤϴŪʤ»˴ؤƤ⡤Ǥ
 *  ʤ
 */

/*
 *  ꥢI/OǥХSIO˥ɥ饤СXstormy16ѡ
 */

#include <kernel.h>
#include <s_services.h>
#include <hw_serial.h>
#include <cpu_sfrs.h>

/*
 *  ƱǤTxReadyΥॢ
 */
#define TXREADY_TIMEOUT 400

/*
 *  SIOPCB*åΤΥޥå
 */
#define MAGIC_SIOPCB 0xabcd

/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 */
static SIOPCB siopcb_table[TNUM_PORT] = {
    { MAGIC_SIOPCB, __U0CR, 0x1400 },
    { MAGIC_SIOPCB, __U1CR, 0x4800 },
} ;

/*
 *  SIOɥ饤Фν롼
 */
void sio_initialize(void)
{
    /* nothing to do here */
}

/*
 *  ꥢI/OݡȤΥץ
 */
SIOPCB *sio_opn_por(ID siopid, VP_INT exinf)
{
    SIOPCB* siopcb ;
    UH uhBase ;
                                /*
                                 *  ץݡȤΥå
                                 */
    if ( siopid < 1 || siopid > TNUM_PORT ) return NULL ;
    siopcb = &siopcb_table[siopid-1] ;
    if ( siopcb->bNotExist ) return NULL ;
                                /*
                                 *  ˥ץѤߤξ
                                 */
    if ( siopcb->bOpened ) {
        siopcb->vpiExinf = exinf ;
        return siopcb ;
    }
                                /*
                                 *  SIOν¸ߤΥå
                                 */
    uhBase = siopcb->uhBase ;
    __SFR(uhBase) = __UxCR_RUN|__UxCR_TXEMPTY ;
    if ( ( __SFR(uhBase) &
        ( __UxCR_RUN|__UxCR_BAUDRATE|__UxCR_PARITY|__UxCR_TXIE|
        __UxCR_RXIE) ) != __UxCR_RUN ) {
        siopcb->bNotExist = TRUE ;
        return NULL ;
    }
                                /*
                                 *  ơ֥ν
                                 */
    siopcb->vpiExinf = exinf ;
    siopcb->bOpened = TRUE ;
    siopcb->bTxIe = FALSE ;
    siopcb->bRxIe = FALSE ;
    siopcb->bLastIsCr = FALSE ;
                                /*
                                 *  ߥϥɥϿȵ
                                 */
    define_inh( INHNO_SIO, sio_handler ) ;
    __UNLOCK_EXCP() ;
    __SFRW(__EXCPL) |= siopcb->uhExcpMask ;
    __LOCK_EXCP() ;
    return siopcb ;
}

/*
 *  ꥢI/OݡȤΥ
 */
void sio_cls_por(SIOPCB *siopcb)
{
                                /*
                                 *  ݡȤΥå
                                 */
    if ( !siopcb || siopcb->uhMagic != MAGIC_SIOPCB ||
        siopcb->bNotExist || !siopcb->bOpened ) return ;
                                /*
                                 *  ơ֥ѹ
                                 */
    siopcb->bOpened = FALSE ;
                                /*
                                 *  ߤζػ
                                 */
    __UNLOCK_EXCP() ;
    __SFRW(__EXCPL) &= ~siopcb->uhExcpMask ;
    __LOCK_EXCP() ;
                                /*
                                 *  SIO
                                 */
    __SFR(siopcb->uhBase) = 0 ;
}

/*
 *  SIOγߥϥɥ
 */
void sio_handler(void)
{
                                /*
                                 *  ƤΥݡȤˤĤƥå
                                 */
    ID portid ;
    for ( portid = 0 ; portid < TNUM_PORT ; portid++ ) {
        SIOPCB *siopcb = &siopcb_table[portid] ;
        UH uhBase = siopcb->uhBase ;
                                /*
                                 *  λߤ
                                 */
        if ( ( __SFR(uhBase) & ( __UxCR_TXIE | __UxCR_TXEMPTY ) ) ==
            ( __UxCR_TXIE | __UxCR_TXEMPTY ) ) {
            sio_ierdy_snd( siopcb->vpiExinf ) ;
        }
                                /*
                                 *  ߤ
                                 */
        if ( ( __SFR(uhBase) & ( __UxCR_RXIE | __UxCR_RXREADY ) ) ==
            ( __UxCR_RXIE | __UxCR_RXREADY ) ) {
            sio_ierdy_rcv( siopcb->vpiExinf ) ;
        }
    }
}

/*
 *  ꥢI/OݡȤؤʸ
 */
BOOL sio_snd_chr(SIOPCB *siopcb, char c)
{
    UH uhBase ;
                                /*
                                 *  ͭʥݡȤɤΥå
                                 */
    if ( !siopcb || siopcb->uhMagic != MAGIC_SIOPCB ||
        siopcb->bNotExist || !siopcb->bOpened ) return FALSE ;
    uhBase = siopcb->uhBase ;
                                /*
                                 *  ǽɤΥå
                                 */
    if ( ! ( __SFR(uhBase) & __UxCR_TXEMPTY ) ) return FALSE ;
                                /*
                                 *  ǡν񤭹
                                 */
    __SFRW(uhBase+4) = __UxTX_STOPBIT | c ;
    return TRUE ;
}

/*
 *  ꥢI/OݡȤʸ
 */
INT sio_rcv_chr(SIOPCB *siopcb)
{
    UH uhBase ;
                                /*
                                 *  ͭʥݡȤɤΥå
                                 */
    if ( !siopcb || siopcb->uhMagic != MAGIC_SIOPCB ||
        siopcb->bNotExist || !siopcb->bOpened ) return -1 ;
    uhBase = siopcb->uhBase ;
                                /*
                                 *  ǡ̵ͭΥå
                                 */
    if ( ! ( __SFR(uhBase) & __UxCR_RXREADY ) ) return -1 ;
                                /*
                                 *  ǡμФ
                                 */
    return __SFRW(uhBase+2) & 0xff ;
}

/*
 *  ꥢI/OݡȤΥХåε
 */
void sio_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    UH uhBase ;
                                /*
                                 *  ͭʥݡȤɤΥå
                                 */
    if ( !siopcb || siopcb->uhMagic != MAGIC_SIOPCB ||
        siopcb->bNotExist || !siopcb->bOpened ) return ;
    uhBase = siopcb->uhBase ;
                                /*
                                 *  ߤε
                                 */
    if ( cbrtn == SIO_ERDY_SND ) {
        __SFR(uhBase) |= __UxCR_TXIE ;
        siopcb->bTxIe = TRUE ;
    }
                                /*
                                 *  ߤε
                                 */
    if ( cbrtn == SIO_ERDY_RCV ) {
        __SFR(uhBase) |= __UxCR_RXIE ;
        siopcb->bRxIe = TRUE ;
    }
}

/*
 *  ꥢI/OݡȤΥХåζػ
 */
void sio_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    UH uhBase ;
                                /*
                                 *  ͭʥݡȤɤΥå
                                 */
    if ( !siopcb || siopcb->uhMagic != MAGIC_SIOPCB ||
        siopcb->bNotExist || !siopcb->bOpened ) return ;
    uhBase = siopcb->uhBase ;
                                /*
                                 *  ߤζػ
                                 */
    if ( cbrtn == SIO_ERDY_SND ) {
        __SFR(uhBase) &= ~__UxCR_TXIE ;
        siopcb->bTxIe = FALSE ;
    }
                                /*
                                 *  ߤζػ
                                 */
    if ( cbrtn == SIO_ERDY_RCV ) {
        __SFR(uhBase) &= ~__UxCR_RXIE ;
        siopcb->bRxIe = FALSE ;
    }
}

/*
 *  ǥեȤǽХå
 */
void sio_ierdy_snd(VP_INT exinf) __attribute__((__weak__)) ;
void sio_ierdy_snd(VP_INT exinf)
{
}

/*
 *  ǥեȤμΥХå
 */
void sio_ierdy_rcv(VP_INT exinf) __attribute__((__weak__)) ;
void sio_ierdy_rcv(VP_INT exinf)
{
}

/*
 *  ꥢI/OݡȤؤƱʸ
 */
void sio_asnd_chr( INT c )
{
    SIOPCB* siopcb ;
    UH uhBase ;
    int i ;
                                /*
                                 *  CPUå֤ˤ
                                 */
    BOOL bLocked ;
    if ( sns_loc() ) bLocked = TRUE ;
    else {
        bLocked = FALSE ;
        if ( sns_ctx() ) iloc_cpu() ;
        else loc_cpu() ;
    }
                                /*
                                 *  ƱѥݡȤ򳫤
                                 */
    if ( ( siopcb = sio_opn_por( LOGTASK_PORTID,
        siopcb_table[LOGTASK_PORTID-1].vpiExinf ) ) != NULL ) {
        uhBase = siopcb->uhBase ;
                                /*
                                 *  LFʤޤCR
                                 */
        if ( c == '\n' ) {
            for ( i = 0 ; i < TXREADY_TIMEOUT ; i++ ) {
                if ( __SFR(uhBase) & __UxCR_TXEMPTY ) break ;
            }
            if ( i < TXREADY_TIMEOUT ) {
                __SFRW(uhBase+4) = __UxTX_STOPBIT | '\r' ;
            }
        }
                                /*
                                 *  ǡ
                                 */
        for ( i = 0 ; i < TXREADY_TIMEOUT ; i++ ) {
            if ( __SFR(uhBase) & __UxCR_TXEMPTY ) break ;
        }
        if ( i < TXREADY_TIMEOUT ) {
            __SFRW(uhBase+4) = __UxTX_STOPBIT | c ;
        }
    }
                                /*
                                 *  CPUå򸵤᤹
                                 */
    if ( !bLocked ) {
        if ( sns_ctx() ) iunl_cpu() ;
        else unl_cpu() ;
    }
}

/*
 *  ꥢI/OݡȤƱʸ
 */
INT sio_arcv_chr( void )
{
    SIOPCB* siopcb ;
    UH uhBase ;
    INT c = -1 ;
                                /*
                                 *  ƥȤΤ߻Ѳ
                                 */
    if ( sns_ctx() || sns_loc() || sns_dsp() ) return -1 ;
                                /*
                                 *  CPUå֤ˤ
                                 */
    loc_cpu() ;
                                /*
                                 *  ƱѥݡȤ򳫤
                                 */
    if ( ( siopcb = sio_opn_por( LOGTASK_PORTID,
        siopcb_table[LOGTASK_PORTID-1].vpiExinf ) ) != NULL ) {
        uhBase = siopcb->uhBase ;
                                /*
                                 *  Ԥ
                                 */
        while(1) {
            if ( __SFR(uhBase) & __UxCR_RXREADY ) {
                c = __SFRW(uhBase+2) & 0xff ;
                if ( c == '\r' ) {
                    c = '\n' ;
                    siopcb->bLastIsCr = TRUE ;
                }
                else {
                    if ( c == '\n' && siopcb->bLastIsCr ) c = -1 ;
                    siopcb->bLastIsCr = FALSE ;
                }
            }
            if ( c != -1 ) break ;
            unl_cpu() ;
            dly_tsk( 50 ) ;
            loc_cpu() ;
        }
    }
                                /*
                                 *  CPUå
                                 */
    unl_cpu() ;
    return c ;
}

