#! /usr/bin/perl
#
#  TOPPERS/JSP Kernel
#      Toyohashi Open Platform for Embedded Real-Time Systems/
#      Just Standard Profile Kernel
# 
#  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
#                              Toyohashi Univ. of Technology, JAPAN
#  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
#              Graduate School of Information Science, Nagoya Univ., JAPAN
#  Copyright (C) 2005-2007 by Industrial Technology Institute,
#                              Miyagi Prefectural Government, JAPAN
# 
#  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
#  ˤäƸɽƤ GNU General Public License  Version 2 ˵
#  ҤƤ˸¤ꡤܥեȥܥեȥ
#  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
#  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
#  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
#      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
#      ˴ޤޤƤ뤳ȡ
#  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
#      ѤǤǺۤˤϡۤȼɥȡ
#      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
#      ̵ݾڵǺܤ뤳ȡ
#  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
#      ѤǤʤǺۤˤϡΤ줫ξ
#      ȡ
#    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
#        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
#    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
#        𤹤뤳ȡ
#  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
#      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
# 
#  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
#  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
#  ޤơʤݾڤԤʤޤܥեȥѤˤľ
#  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
# 

#
#  jsp/kernelˤ륽ɤAPI˥ԡ롣
#  ʴؿñ̤ǥ󥯤Ǥ褦ˤ
#  ԡݤˡեƬ#define __tskiniʤɤΥޥɲä롣
#  
#  Ȥ
#  perl copy_kernel_source.pl src_path dst_path
#  
#  src_pathjsp/kernelؤХѥ
#  dst_pathեΥԡؤХѥ


$src_path = $ARGV[0];
$dst_path = $ARGV[1];

# ˤʤ륽ե̾ɲäޥ̾
%hash_array = (
 "task.c"
	=> [qw(tskini tsksched tskrun tsknrun tskdmt tskact tskext tskpri tskrot tsktex)],
 "wait.c"
	=> [qw(waimake waicmp waitmo waitmook waican wairel wobjwai wobjwaitmo wobjpri)],
 "time_event.c"
	=> [qw(tmeini tmeup tmedown tmeins tmedel isig_tim)],
 "syslog.c"
	=> [qw(logini vwri_log vrea_log vmsk_log logter)],
 "task_manage.c"
	=> [qw(act_tsk iact_tsk can_act ext_tsk ter_tsk chg_pri get_pri)],
 "task_sync.c"
	=> [qw(slp_tsk tslp_tsk wup_tsk iwup_tsk can_wup rel_wai irel_wai sus_tsk rsm_tsk frsm_tsk dly_tsk)],
 "task_except.c"
	=> [qw(ras_tex iras_tex dis_tex ena_tex sns_tex)],
 "semaphore.c"
	=> [qw(semini sig_sem isig_sem wai_sem pol_sem twai_sem)],
 "eventflag.c"
	=> [qw(flgini flgcnd set_flg iset_flg clr_flg wai_flg pol_flg twai_flg)],
 "dataqueue.c"
	=> [qw(dtqini dtqenq dtqfenq dtqdeq dtqsnd dtqrcv snd_dtq psnd_dtq ipsnd_dtq tsnd_dtq fsnd_dtq ifsnd_dtq rcv_dtq prcv_dtq trcv_dtq)],
 "mailbox.c"
	=> [qw(mbxini snd_mbx rcv_mbx prcv_mbx trcv_mbx)],
 "mempfix.c"
	=> [qw(mpfini mpfget get_mpf pget_mpf tget_mpf rel_mpf)],
 "time_manage.c"
	=> [qw(set_tim get_tim vxget_tim)],
 "cyclic.c"
	=> [qw(cycini cycenq sta_cyc stp_cyc cyccal)],
 "sys_manage.c"
	=> [qw(rot_rdq irot_rdq get_tid iget_tid loc_cpu iloc_cpu unl_cpu iunl_cpu dis_dsp ena_dsp sns_ctx sns_loc sns_dsp sns_dpn vsns_ini)],
 "interrupt.c"
	=> [qw(inhini)],
 "exception.c"
	=> [qw(excini vxsns_ctx vxsns_loc vxsns_dsp vxsns_dpn vxsns_tex)]
);

#
#ᥤν
#
foreach $file (keys(%hash_array)) {
	@array = @{$hash_array{$file}};
	foreach $api (@array) {
		&copy_file($file, $api);
	}
}


#
#1ˤʤ륽ɤΥե̾ʥѥޤޤ
#2拾ѥѤΥޥɲäAPIؿ̾
#Ϥե̾ͤƤ롣
#
sub copy_file {
	my($filename, $api) = @_;
	open(OUTFILE, ">$dst_path/$api.c") || die "Cannot open $dst_path/$api.c";
	
	# APIΥޥɲ
	print OUTFILE "#define __$api\n";
	
	# jsp/kernelե򥳥ԡ
	open(INFILE, "$src_path/$filename") || die "Cannot open $src_path/$filename";
	while ($line = <INFILE>) {
		print OUTFILE $line;
	}
	
	close(INFILE);
	close(OUTFILE);
}
