/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import java.io.Serializable;

public final class REMatch
implements Serializable,
Cloneable {
    private String matchedText;
    int eflags;
    int offset;
    int anchor;
    int index;
    int[] start;
    int[] end;
    REMatch next;

    public Object clone() {
        try {
            REMatch copy = (REMatch)super.clone();
            copy.next = null;
            copy.start = (int[])this.start.clone();
            copy.end = (int[])this.end.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new Error();
        }
    }

    void assignFrom(REMatch other) {
        this.start = other.start;
        this.end = other.end;
        this.index = other.index;
        this.next = other.next;
    }

    REMatch(int subs, int anchor, int eflags) {
        this.start = new int[subs + 1];
        this.end = new int[subs + 1];
        this.anchor = anchor;
        this.eflags = eflags;
        this.clear(anchor);
    }

    void finish(CharIndexed text) {
        int i;
        this.start[0] = 0;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < this.end[0]; ++i) {
            sb.append(text.charAt(i));
        }
        this.matchedText = sb.toString();
        for (i = 0; i < this.start.length; ++i) {
            if (!(this.start[i] == -1 ^ this.end[i] == -1)) continue;
            this.start[i] = -1;
            this.end[i] = -1;
        }
        this.next = null;
    }

    void clear(int index) {
        this.offset = index;
        this.index = 0;
        for (int i = 0; i < this.start.length; ++i) {
            this.end[i] = -1;
            this.start[i] = -1;
        }
        this.next = null;
    }

    public String toString() {
        return this.matchedText;
    }

    public int getStartIndex() {
        return this.offset + this.start[0];
    }

    public int getEndIndex() {
        return this.offset + this.end[0];
    }

    public String toString(int sub) {
        if (sub >= this.start.length || this.start[sub] == -1) {
            return "";
        }
        return this.matchedText.substring(this.start[sub], this.end[sub]);
    }

    public int getSubStartIndex(int sub) {
        if (sub >= this.start.length) {
            return -1;
        }
        int x = this.start[sub];
        return x == -1 ? x : this.offset + x;
    }

    public int getStartIndex(int sub) {
        if (sub >= this.start.length) {
            return -1;
        }
        int x = this.start[sub];
        return x == -1 ? x : this.offset + x;
    }

    public int getSubEndIndex(int sub) {
        if (sub >= this.start.length) {
            return -1;
        }
        int x = this.end[sub];
        return x == -1 ? x : this.offset + x;
    }

    public int getEndIndex(int sub) {
        if (sub >= this.start.length) {
            return -1;
        }
        int x = this.end[sub];
        return x == -1 ? x : this.offset + x;
    }

    public String substituteInto(String input) {
        int pos;
        StringBuffer output = new StringBuffer();
        for (pos = 0; pos < input.length() - 1; ++pos) {
            if (input.charAt(pos) == '$' && Character.isDigit(input.charAt(pos + 1))) {
                int val;
                if ((val = Character.digit(input.charAt(++pos), 10)) >= this.start.length) continue;
                output.append(this.toString(val));
                continue;
            }
            output.append(input.charAt(pos));
        }
        if (pos < input.length()) {
            output.append(input.charAt(pos));
        }
        return output.toString();
    }
}

