/*
 * Decompiled with CFR 0.152.
 */
package sourceview;

import gnu.regexp.CharIndexed;
import gnu.regexp.RE;
import gnu.regexp.REMatch;
import gnu.regexp.RESyntax;

public class RESearchMatcher {
    public static final RESyntax RE_SYNTAX_JEDIT = new RESyntax(RESyntax.RE_SYNTAX_PERL5).set(2).setLineSeparator("\n");
    private String m_replace;
    private RE m_re;
    private int[] m_returnValue;

    public RESearchMatcher(String search, String replace, boolean ignoreCase) throws Exception {
        this.m_replace = RESearchMatcher.escapesToChars(replace);
        this.m_re = new RE(search, (ignoreCase ? 2 : 0) | 8, RE_SYNTAX_JEDIT);
        this.m_returnValue = new int[2];
    }

    public int[] nextMatch(CharIndexed text, boolean start, boolean end2, boolean firstTime, boolean reverse) {
        REMatch match;
        int flags = 0;
        if (!start) {
            flags |= 0x10;
        }
        if (!end2) {
            flags |= 0x20;
        }
        if ((match = this.m_re.getMatch(text, 0, flags)) == null) {
            return null;
        }
        int _start = match.getStartIndex();
        int _end = match.getEndIndex();
        if (!firstTime && _start == 0 && _end == 0) {
            text.move(1);
            if (text.charAt(0) == '\uffff') {
                return null;
            }
            match = this.m_re.getMatch(text, 0, flags | 0x10);
            if (match == null) {
                return null;
            }
            _start = match.getStartIndex() + 1;
            _end = match.getEndIndex() + 1;
        }
        this.m_returnValue[0] = _start;
        this.m_returnValue[1] = _end;
        return this.m_returnValue;
    }

    public String substitute(String text) throws Exception {
        REMatch match = this.m_re.getMatch(text);
        if (match == null) {
            return null;
        }
        return match.substituteInto(this.m_replace);
    }

    private static String escapesToChars(String str) {
        StringBuffer buf = new StringBuffer();
        block7: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\\': {
                    if (i == str.length() - 1) {
                        buf.append('\\');
                        continue block7;
                    }
                    c = str.charAt(++i);
                    switch (c) {
                        case 'n': {
                            buf.append('\n');
                            continue block7;
                        }
                        case 't': {
                            buf.append('\t');
                            continue block7;
                        }
                    }
                    buf.append(c);
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }
}

