/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import net.sourceforge.jsxe.ActionSet;
import net.sourceforge.jsxe.EBListener;
import net.sourceforge.jsxe.EBMessage;
import net.sourceforge.jsxe.EditBus;
import net.sourceforge.jsxe.LocalizedAction;
import net.sourceforge.jsxe.gui.GUIUtilities;
import net.sourceforge.jsxe.gui.KeyEventTranslator;
import net.sourceforge.jsxe.jsXe;
import net.sourceforge.jsxe.msg.PropertyChanged;
import net.sourceforge.jsxe.util.Log;

public class ActionManager {
    public static final String CUT_SUFFIX = ".cut";
    public static final String COPY_SUFFIX = ".copy";
    public static final String PASTE_SUFFIX = ".paste";
    public static final String FIND_SUFFIX = ".find";
    private static HashMap m_keyBindingMap = new HashMap();
    private static HashMap m_actionMap = new HashMap();
    private static ArrayList m_actionSets = new ArrayList();
    private static boolean initialized = false;
    static /* synthetic */ Class class$net$sourceforge$jsxe$ActionManager;

    public static void addActionSet(ActionSet set) {
        m_actionSets.add(set);
    }

    public static LocalizedAction getLocalizedAction(String name) {
        for (int i = 0; i < m_actionSets.size(); ++i) {
            LocalizedAction action = ((ActionSet)m_actionSets.get(i)).getAction(name);
            if (action == null) continue;
            return action;
        }
        Log.log(7, class$net$sourceforge$jsxe$ActionManager == null ? (class$net$sourceforge$jsxe$ActionManager = ActionManager.class$("net.sourceforge.jsxe.ActionManager")) : class$net$sourceforge$jsxe$ActionManager, "Unknown action: " + name);
        return null;
    }

    public static Action getAction(String name) {
        Action action = (Action)m_actionMap.get(name);
        if (action == null) {
            LocalizedAction editAction = ActionManager.getLocalizedAction(name);
            if (editAction != null) {
                action = new Wrapper(name);
                String dispName = editAction.getLabel();
                String keyBinding = jsXe.getProperty(name + ".shortcut");
                action.putValue("Name", dispName);
                if (keyBinding != null) {
                    action.putValue("AcceleratorKey", KeyEventTranslator.getKeyStroke(keyBinding));
                }
                m_actionMap.put(name, action);
            } else {
                Log.log(7, class$net$sourceforge$jsxe$ActionManager == null ? (class$net$sourceforge$jsxe$ActionManager = ActionManager.class$("net.sourceforge.jsxe.ActionManager")) : class$net$sourceforge$jsxe$ActionManager, "Unknown action: " + name);
            }
        }
        return action;
    }

    public static ArrayList getActionSets() {
        return m_actionSets;
    }

    public static void invokeAction(String name, ActionEvent evt) {
        ActionManager.invokeAction(ActionManager.getLocalizedAction(name), evt);
    }

    public static void initKeyBindings() {
        Log.log(5, class$net$sourceforge$jsxe$ActionManager == null ? (class$net$sourceforge$jsxe$ActionManager = ActionManager.class$("net.sourceforge.jsxe.ActionManager")) : class$net$sourceforge$jsxe$ActionManager, "Loading key bindings.");
        if (!initialized) {
            EditBus.addToBus(new EBListener(){

                public void handleMessage(EBMessage message) {
                    PropertyChanged msg;
                    if (message instanceof PropertyChanged && (msg = (PropertyChanged)message).getKey().endsWith(".shortcut")) {
                        String actionName = msg.getKey().substring(0, msg.getKey().lastIndexOf("."));
                        String keyBinding = jsXe.getProperty(msg.getKey());
                        if (keyBinding != null) {
                            ActionManager.addKeyBinding(keyBinding, actionName);
                        } else {
                            ActionManager.removeKeyBinding(msg.getOldValue());
                        }
                    }
                }
            });
            Iterator itr = m_actionSets.iterator();
            while (itr.hasNext()) {
                ActionSet set = (ActionSet)itr.next();
                LocalizedAction[] actions = set.getActions();
                for (int i = 0; i < actions.length; ++i) {
                    String actionName = actions[i].getName();
                    String keyBinding = jsXe.getProperty(actionName + ".shortcut");
                    if (keyBinding == null) continue;
                    ActionManager.addKeyBinding(keyBinding, actions[i]);
                    Log.log(5, class$net$sourceforge$jsxe$ActionManager == null ? ActionManager.class$("net.sourceforge.jsxe.ActionManager") : class$net$sourceforge$jsxe$ActionManager, "Loaded key binding for " + actionName + ": " + keyBinding);
                }
            }
            initialized = true;
        }
    }

    public static void addKeyBinding(String keyBinding, String action) {
        ActionManager.addKeyBinding(keyBinding, ActionManager.getLocalizedAction(action));
    }

    public static void addKeyBinding(String keyBinding, LocalizedAction action) {
        if (action != null && keyBinding != null) {
            Action wrapper = ActionManager.getAction(action.getName());
            KeyEventTranslator.Key key = KeyEventTranslator.parseKey(keyBinding);
            m_keyBindingMap.put(key, wrapper);
            wrapper.putValue("AcceleratorKey", KeyEventTranslator.getKeyStroke(keyBinding));
        }
    }

    public static void removeKeyBinding(String keyBinding) {
        ActionManager.removeKeyBinding(KeyEventTranslator.parseKey(keyBinding));
    }

    public static void removeAllKeyBindings() {
        Iterator itr = m_keyBindingMap.keySet().iterator();
        while (itr.hasNext()) {
            ActionManager.removeKeyBinding((KeyEventTranslator.Key)itr.next());
        }
    }

    public static void handleKey(KeyEvent event) {
        KeyEventTranslator.Key key = KeyEventTranslator.translateKeyEvent(event);
        Action action = (Action)m_keyBindingMap.get(key);
        if (action != null) {
            Log.log(1, class$net$sourceforge$jsxe$ActionManager == null ? (class$net$sourceforge$jsxe$ActionManager = ActionManager.class$("net.sourceforge.jsxe.ActionManager")) : class$net$sourceforge$jsxe$ActionManager, "Key mapping match for " + ((Wrapper)action).getName());
            action.actionPerformed(ActionManager.translateKeyEvent(event));
            event.consume();
        }
    }

    public static boolean isDocViewSpecific(String actionName) {
        return actionName.endsWith(CUT_SUFFIX) || actionName.endsWith(COPY_SUFFIX) || actionName.endsWith(PASTE_SUFFIX) || actionName.endsWith(FIND_SUFFIX);
    }

    private static void invokeAction(LocalizedAction action, ActionEvent evt) {
        if (action != null) {
            Log.log(3, class$net$sourceforge$jsxe$ActionManager == null ? (class$net$sourceforge$jsxe$ActionManager = ActionManager.class$("net.sourceforge.jsxe.ActionManager")) : class$net$sourceforge$jsxe$ActionManager, "Invoking action " + action.getName());
            action.invoke(GUIUtilities.getView((Component)evt.getSource()), evt);
        }
    }

    private ActionManager() {
    }

    private static void removeKeyBinding(KeyEventTranslator.Key key) {
        Action action = (Action)m_keyBindingMap.get(key);
        if (action != null) {
            Log.log(1, class$net$sourceforge$jsxe$ActionManager == null ? (class$net$sourceforge$jsxe$ActionManager = ActionManager.class$("net.sourceforge.jsxe.ActionManager")) : class$net$sourceforge$jsxe$ActionManager, "removing key binding: " + key.toString());
            action.putValue("AcceleratorKey", null);
            m_keyBindingMap.remove(key);
        }
    }

    private static ActionEvent translateKeyEvent(KeyEvent evt) {
        ActionEvent event = new ActionEvent(evt.getSource(), 8, "", evt.getModifiers());
        return event;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Wrapper
    extends AbstractAction {
        private LocalizedAction m_action;

        public Wrapper(String name) {
            this(ActionManager.getLocalizedAction(name));
        }

        public Wrapper(LocalizedAction action) {
            this.m_action = action;
            this.putValue("Name", action.getLabel());
        }

        public void actionPerformed(ActionEvent evt) {
            ActionManager.invokeAction(this.m_action, evt);
        }

        public String getName() {
            return this.m_action.getName();
        }
    }
}

