/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.jsxe.DocumentBuffer;
import net.sourceforge.jsxe.dom.DOMOutput;
import net.sourceforge.jsxe.dom.DOMSerializer;
import net.sourceforge.jsxe.dom.DOMSerializerConfiguration;
import net.sourceforge.jsxe.jsXe;
import net.sourceforge.jsxe.util.Log;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BufferHistory {
    private ArrayList m_history = new ArrayList();
    private static ArrayList m_excludeKeys = new ArrayList();

    public BufferHistoryEntry getEntry(String path) {
        Iterator historyItr = this.m_history.iterator();
        while (historyItr.hasNext()) {
            BufferHistoryEntry nextEntry = (BufferHistoryEntry)historyItr.next();
            if (!nextEntry.getPath().equals(path)) continue;
            return nextEntry;
        }
        return null;
    }

    public ArrayList getEntries() {
        return this.m_history;
    }

    public void setEntry(DocumentBuffer buffer, String viewName) {
        if (!buffer.isUntitled()) {
            try {
                String path = buffer.getFile().getCanonicalPath();
                this.setEntry(path, viewName, buffer.getProperties());
            }
            catch (IOException ioe) {
                Log.log(9, this, ioe);
            }
        }
    }

    public void setEntry(String path, String viewName, Properties properties) {
        BufferHistoryEntry entry = new BufferHistoryEntry(path, viewName, properties);
        this.setEntry(entry);
    }

    public void setEntry(BufferHistoryEntry entry) {
        if (!this.m_history.contains(entry)) {
            String path = entry.getPath();
            BufferHistoryEntry previousEntry = this.getEntry(path);
            if (previousEntry != null) {
                this.m_history.remove(previousEntry);
            }
            this.m_history.add(0, entry);
            try {
                int maxRecentFiles = Integer.parseInt(jsXe.getProperty("max.recent.files"));
            }
            catch (NumberFormatException nfe) {
                try {
                    int maxRecentFiles = Integer.parseInt(jsXe.getDefaultProperty("max.recent.files"));
                }
                catch (NumberFormatException nfe2) {
                    // empty catch block
                }
            }
        }
    }

    public void load(File file) throws IOException, SAXException, ParserConfigurationException {
        Log.log(5, this, "Loading buffer history: " + file.getName());
        this.m_history = new ArrayList();
        if (file.exists()) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                parser.parse(file, (DefaultHandler)new BufferHistoryHandler());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void save(File file) throws IOException {
        try {
            Log.log(5, this, "Saving buffer history: " + file.getName());
            String lineSep = System.getProperty("line.separator");
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Node recent = document.appendChild(document.createElement("recent"));
            int maxRecentFiles = 20;
            try {
                maxRecentFiles = Integer.parseInt(jsXe.getProperty("max.recent.files"));
            }
            catch (NumberFormatException nfe) {
                try {
                    maxRecentFiles = Integer.parseInt(jsXe.getDefaultProperty("max.recent.files"));
                }
                catch (NumberFormatException nfe2) {
                    // empty catch block
                }
            }
            int index = 0;
            Iterator historyItr = this.m_history.iterator();
            while (historyItr.hasNext() && index < maxRecentFiles) {
                ++index;
                BufferHistoryEntry entry = (BufferHistoryEntry)historyItr.next();
                Node entryNode = recent.appendChild(document.createElement("entry"));
                String path = entry.getPath();
                Node pathNode = entryNode.appendChild(document.createElement("path"));
                pathNode.appendChild(document.createCDATASection(path));
                String viewName = entry.getViewName();
                Node view = entryNode.appendChild(document.createElement("view"));
                view.appendChild(document.createTextNode(viewName));
                Properties props = entry.getProperties();
                Enumeration<Object> propertyItr = props.keys();
                while (propertyItr.hasMoreElements()) {
                    String key = propertyItr.nextElement().toString();
                    if (m_excludeKeys.contains(key)) continue;
                    try {
                        String value = props.getProperty(key);
                        Element property = (Element)entryNode.appendChild(document.createElement("property"));
                        property.setAttribute("name", key);
                        property.setAttribute("value", value);
                    }
                    catch (ClassCastException e) {
                        Log.log(9, this, e);
                    }
                }
            }
            DOMSerializerConfiguration config = new DOMSerializerConfiguration();
            config.setFeature("soft-tabs", true);
            config.setParameter("indent", new Integer(2));
            config.setFeature("format-pretty-print", true);
            config.setParameter("error-handler", new DOMErrorHandler(){

                public boolean handleError(DOMError error) {
                    Log.log(9, this, error.getMessage());
                    return true;
                }
            });
            DOMSerializer serializer = new DOMSerializer(config);
            serializer.setNewLine(lineSep);
            serializer.write(document, new DOMOutput(out));
            out.close();
        }
        catch (ParserConfigurationException e) {
            Log.log(9, this, e);
        }
    }

    static {
        m_excludeKeys.add("line-separator");
    }

    private class BufferHistoryHandler
    extends DefaultHandler {
        Properties m_m_properties;
        String m_m_charData;
        String m_m_path;
        String m_m_viewName;

        private BufferHistoryHandler() {
        }

        public void characters(char[] ch, int start, int length) {
            this.m_m_charData = new String(ch, start, length);
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.equals("entry")) {
                Log.log(3, this, "Loading buffer history entry: " + this.m_m_path);
                BufferHistory.this.m_history.add(new BufferHistoryEntry(this.m_m_path, this.m_m_viewName, this.m_m_properties));
            }
            if (qName.equals("path")) {
                this.m_m_path = this.m_m_charData;
            }
            if (qName.equals("view")) {
                this.m_m_viewName = this.m_m_charData;
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("entry")) {
                this.m_m_properties = new Properties();
            }
            if (qName.equals("property")) {
                int length = attributes.getLength();
                String propName = null;
                String propValue = null;
                for (int i = 0; i < length; ++i) {
                    String name = attributes.getQName(i);
                    if (name.equals("name")) {
                        propName = attributes.getValue(i);
                    }
                    if (!name.equals("value")) continue;
                    propValue = attributes.getValue(i);
                }
                if (!m_excludeKeys.contains(propName) && propName != null && propValue != null) {
                    this.m_m_properties.setProperty(propName, propValue);
                }
            }
        }
    }

    public static class BufferHistoryEntry {
        private String m_path;
        private String m_viewName;
        private Properties m_properties;

        public BufferHistoryEntry(String path, String viewName, Properties properties) {
            this.m_path = path;
            this.m_viewName = viewName;
            this.m_properties = properties;
        }

        public String getPath() {
            return this.m_path;
        }

        public String getViewName() {
            return this.m_viewName;
        }

        public Properties getProperties() {
            return this.m_properties;
        }
    }
}

