/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.sourceforge.jsxe.CatalogManager;
import net.sourceforge.jsxe.DocumentBufferListener;
import net.sourceforge.jsxe.EditBus;
import net.sourceforge.jsxe.dom.AdapterNode;
import net.sourceforge.jsxe.dom.XMLDocument;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.gui.TabbedView;
import net.sourceforge.jsxe.gui.jsxeFileDialog;
import net.sourceforge.jsxe.jsXe;
import net.sourceforge.jsxe.msg.DocumentBufferUpdate;
import net.sourceforge.jsxe.options.AbstractOptionPane;
import net.sourceforge.jsxe.options.OptionPane;
import net.sourceforge.jsxe.util.Log;
import net.sourceforge.jsxe.util.MiscUtilities;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentBuffer
extends XMLDocument {
    public static final int DIRTY = 1;
    private String m_name;
    private File m_file;
    private ArrayList m_listeners = new ArrayList();
    private boolean m_dirty = false;
    private OptionPane m_optionPane;
    static /* synthetic */ Class class$net$sourceforge$jsxe$DocumentBuffer;

    DocumentBuffer() throws IOException {
        this(jsXe.getDefaultDocument());
    }

    DocumentBuffer(File file) throws IOException {
        super(file.toURI(), new FileInputStream(file));
        this.setEntityResolver(new DocumentBufferResolver());
        this.m_file = file;
        this.m_name = file.getName();
        EditBus.send(new DocumentBufferUpdate(this, DocumentBufferUpdate.LOADED));
    }

    DocumentBuffer(InputStream stream) throws IOException {
        super(null, stream);
        this.setEntityResolver(new DocumentBufferResolver());
        this.m_file = null;
        this.m_name = this.getUntitledLabel();
        EditBus.send(new DocumentBufferUpdate(this, DocumentBufferUpdate.LOADED));
    }

    DocumentBuffer(File file, Properties properties) throws IOException {
        super(file.toURI(), new FileInputStream(file), null, properties);
        this.setEntityResolver(new DocumentBufferResolver());
        this.m_file = file;
        this.m_name = file.getName();
        EditBus.send(new DocumentBufferUpdate(this, DocumentBufferUpdate.LOADED));
    }

    public boolean close(TabbedView view, boolean confirmClose) throws IOException {
        boolean reallyClose = true;
        if (this.getStatus(1) && confirmClose) {
            int messageType;
            int optionType;
            String title;
            String msg = Messages.getMessage("DocumentBuffer.Close.Message", new String[]{this.getName()});
            int returnVal = JOptionPane.showConfirmDialog(view, msg, title = Messages.getMessage("DocumentBuffer.Close.Message.Title"), optionType = 1, messageType = 2);
            if (returnVal == 0) {
                reallyClose = this.save(view);
            } else {
                boolean bl = reallyClose = returnVal != 2;
            }
        }
        if (reallyClose) {
            EditBus.send(new DocumentBufferUpdate(this, DocumentBufferUpdate.CLOSED));
        }
        return reallyClose;
    }

    public void addDocumentBufferListener(DocumentBufferListener listener) {
        if (listener != null && !this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    public void removeDocumentBufferListener(DocumentBufferListener listener) {
        if (listener != null) {
            this.m_listeners.remove(this.m_listeners.indexOf(listener));
        }
    }

    public String getName() {
        return this.m_name;
    }

    public File getFile() {
        return this.m_file;
    }

    public boolean getStatus(int statusType) {
        boolean status = false;
        if (statusType == 1) {
            status = this.m_dirty;
        }
        return status;
    }

    public boolean isUntitled() {
        return this.m_file == null;
    }

    public boolean reload(TabbedView view) throws IOException {
        boolean stillReload = true;
        if (this.getStatus(1)) {
            int messageType;
            int optionType;
            String title;
            String msg = Messages.getMessage("DocumentBuffer.Reload.Message", new String[]{this.getName()});
            int returnVal = JOptionPane.showConfirmDialog(view, msg, title = Messages.getMessage("DocumentBuffer.Reload.Message.Title"), optionType = 0, messageType = 2);
            stillReload = returnVal == 0;
        }
        if (stillReload) {
            Log.log(5, this, "Reloading " + this.getName());
            if (this.isUntitled()) {
                InputStream stream = jsXe.getDefaultDocument();
                this.setModel(stream);
                stream.close();
            } else {
                FileInputStream reader = new FileInputStream(this.m_file);
                this.setModel(reader);
                reader.close();
            }
            this.setDirty(false);
            EditBus.send(new DocumentBufferUpdate(this, DocumentBufferUpdate.LOADED));
            return true;
        }
        return false;
    }

    public boolean save(TabbedView view) throws IOException {
        return this.saveAs(view, this.getFile());
    }

    public boolean saveAs(TabbedView view) throws IOException {
        jsxeFileDialog saveDialog = new jsxeFileDialog(this.getFile());
        saveDialog.setSelectedFile(new File(this.getName()));
        int returnVal = ((JFileChooser)saveDialog).showSaveDialog(view);
        if (returnVal == 0) {
            int messageType;
            int optionType;
            String title;
            String msg;
            File selectedFile = saveDialog.getSelectedFile();
            Log.log(5, class$net$sourceforge$jsxe$DocumentBuffer == null ? (class$net$sourceforge$jsxe$DocumentBuffer = DocumentBuffer.class$("net.sourceforge.jsxe.DocumentBuffer")) : class$net$sourceforge$jsxe$DocumentBuffer, "366 : " + selectedFile.getName());
            boolean reallySave = true;
            if (selectedFile.exists() && (returnVal = JOptionPane.showConfirmDialog(view, msg = Messages.getMessage("DocumentBuffer.SaveAs.Message", new String[]{selectedFile.getName()}), title = Messages.getMessage("DocumentBuffer.SaveAs.Message.Title"), optionType = 0, messageType = 2)) != 0) {
                reallySave = false;
            }
            if (reallySave) {
                DocumentBuffer buffer = jsXe.getOpenBuffer(selectedFile);
                if (buffer != null && !this.equalsOnDisk(buffer)) {
                    jsXe.closeDocumentBuffer(view, buffer);
                    return this.saveAs(view, selectedFile);
                }
                return this.saveAs(view, selectedFile);
            }
        }
        return false;
    }

    public boolean saveAs(TabbedView view, File file) throws IOException {
        if (file != null) {
            try {
                Log.log(5, this, "Saving file " + this.getName());
                EditBus.send(new DocumentBufferUpdate(this, DocumentBufferUpdate.SAVING));
                FileOutputStream out = new FileOutputStream(file);
                this.serialize(out);
                if (!this.getName().equals(file.getName())) {
                    this.setName(file.getName());
                }
                this.m_file = file;
                this.setURI(this.m_file.toURI());
                this.setDirty(false);
                this.fireBufferSaved();
                return true;
            }
            catch (SecurityException se) {
                throw new IOException(se.getMessage());
            }
        }
        return this.saveAs(view);
    }

    public boolean equalsOnDisk(File file) throws IOException {
        if (this.getFile() != null && file != null) {
            boolean caseInsensitiveFilesystem;
            boolean bl = caseInsensitiveFilesystem = File.separatorChar == '\\' || File.separatorChar == ':';
            if (caseInsensitiveFilesystem ? file.getCanonicalPath().equalsIgnoreCase(this.getFile().getCanonicalPath()) : file.getCanonicalPath().equals(this.getFile().getCanonicalPath())) {
                return true;
            }
        }
        return false;
    }

    public boolean equalsOnDisk(DocumentBuffer buffer) throws IOException {
        return this.equalsOnDisk(buffer.getFile());
    }

    public OptionPane getOptionPane() {
        if (this.m_optionPane == null) {
            this.m_optionPane = new DocumentBufferOptionPane();
        }
        return this.m_optionPane;
    }

    protected void fireStructureChanged(AdapterNode location) {
        this.setDirty(true);
        super.fireStructureChanged(location);
    }

    private void setDirty(boolean dirty) {
        if (dirty != this.m_dirty) {
            boolean oldDirty = this.m_dirty;
            this.m_dirty = dirty;
            this.fireStatusChanged(1, oldDirty);
            EditBus.send(new DocumentBufferUpdate(this, DocumentBufferUpdate.DIRTY_CHANGED));
        }
    }

    private void setName(String name) {
        this.m_name = name;
        this.fireNameChanged();
    }

    private String getUntitledLabel() {
        DocumentBuffer[] buffers = jsXe.getDocumentBuffers();
        int untitledNo = 0;
        for (int i = 0; i < buffers.length; ++i) {
            if (!buffers[i].getName().startsWith("Untitled-")) continue;
            try {
                untitledNo = Math.max(untitledNo, Integer.parseInt(buffers[i].getName().substring(9)));
                continue;
            }
            catch (NumberFormatException nf) {
                // empty catch block
            }
        }
        return "Untitled-" + Integer.toString(untitledNo + 1);
    }

    private void fireNameChanged() {
        ListIterator iterator = this.m_listeners.listIterator();
        while (iterator.hasNext()) {
            DocumentBufferListener listener = (DocumentBufferListener)iterator.next();
            listener.nameChanged(this, this.getName());
        }
    }

    private void fireBufferSaved() {
        EditBus.send(new DocumentBufferUpdate(this, DocumentBufferUpdate.SAVED));
        ListIterator iterator = this.m_listeners.listIterator();
        while (iterator.hasNext()) {
            DocumentBufferListener listener = (DocumentBufferListener)iterator.next();
            listener.bufferSaved(this);
        }
    }

    private void fireStatusChanged(int status, boolean oldStatus) {
        ListIterator iterator = this.m_listeners.listIterator();
        while (iterator.hasNext()) {
            DocumentBufferListener listener = (DocumentBufferListener)iterator.next();
            listener.statusChanged(this, status, oldStatus);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DocumentBufferResolver
    implements EntityResolver {
        private DocumentBufferResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            try {
                if (DocumentBuffer.this.isUntitled()) {
                    return CatalogManager.resolve(null, publicId, systemId);
                }
                return CatalogManager.resolve(DocumentBuffer.this.getFile().toURI().toString(), publicId, systemId);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    private class DocumentBufferOptionPane
    extends AbstractOptionPane {
        private DocumentBuffer m_buffer;
        private JCheckBox m_m_softTabsCheckBox;
        private JComboBox encodingComboBox;
        private JComboBox m_m_lineSeparatorComboBox;
        private JComboBox indentComboBox;
        private JCheckBox whitespaceCheckBox;
        private JCheckBox m_m_validatingCheckBox;
        private final HashMap m_m_lineSeparators = new HashMap(3);
        private JCheckBox formatCheckBox;

        public DocumentBufferOptionPane() {
            super("documentbuffer");
        }

        protected void _init() {
            this.m_m_lineSeparators.put("Unix (\\n)", "\n");
            this.m_m_lineSeparators.put("DOS/Windows (\\r\\n)", "\r\n");
            this.m_m_lineSeparators.put("MacOS (\\r)", "\r");
            this.m_m_lineSeparatorComboBox = new JComboBox(new Vector(this.m_m_lineSeparators.keySet()));
            this.m_m_lineSeparatorComboBox.setName("LineSeparatorComboBox");
            String lineSep = DocumentBuffer.this.getProperty("line-separator");
            if (lineSep.equals("\r\n")) {
                this.m_m_lineSeparatorComboBox.setSelectedItem("DOS/Windows (\\r\\n)");
            } else if (lineSep.equals("\r")) {
                this.m_m_lineSeparatorComboBox.setSelectedItem("MacOS (\\r)");
            } else {
                this.m_m_lineSeparatorComboBox.setSelectedItem("Unix (\\n)");
            }
            this.addComponent(Messages.getMessage("Document.Options.Line.Separator"), (JComponent)this.m_m_lineSeparatorComboBox, Messages.getMessage("Document.Options.Line.Separator.ToolTip"));
            String[] encodings = MiscUtilities.getSupportedEncodings();
            this.encodingComboBox = new JComboBox<String>(encodings);
            this.encodingComboBox.setName("EncodingComboBox");
            this.encodingComboBox.setEditable(false);
            for (int i = 0; i < encodings.length; ++i) {
                if (!DocumentBuffer.this.getProperty("encoding").equals(encodings[i])) continue;
                this.encodingComboBox.setSelectedItem(encodings[i]);
            }
            this.addComponent(Messages.getMessage("Document.Options.Encoding"), (JComponent)this.encodingComboBox, Messages.getMessage("Document.Options.Encoding.ToolTip"));
            Vector<String> sizes = new Vector<String>(3);
            sizes.add("2");
            sizes.add("4");
            sizes.add("8");
            this.indentComboBox = new JComboBox(sizes);
            this.indentComboBox.setName("IndentComboBox");
            this.indentComboBox.setEditable(true);
            this.indentComboBox.setSelectedItem(DocumentBuffer.this.getProperty("indent"));
            this.addComponent(Messages.getMessage("Document.Options.Indent.Width"), (JComponent)this.indentComboBox, Messages.getMessage("Document.Options.Indent.Width.ToolTip"));
            boolean formatOutput = Boolean.valueOf(DocumentBuffer.this.getProperty("format-pretty-print", "false"));
            this.formatCheckBox = new JCheckBox(Messages.getMessage("Document.Options.Format.XML"), formatOutput);
            this.addComponent(this.formatCheckBox, Messages.getMessage("Document.Options.Format.XML.ToolTip"));
            boolean validating = Boolean.valueOf(DocumentBuffer.this.getProperty("validating", "false"));
            this.m_m_validatingCheckBox = new JCheckBox(Messages.getMessage("Document.Options.Validate"), validating);
            this.addComponent(this.m_m_validatingCheckBox, Messages.getMessage("Document.Options.Validate.ToolTip"));
            boolean softTabs = Boolean.valueOf(DocumentBuffer.this.getProperty("soft-tabs", "false"));
            this.m_m_softTabsCheckBox = new JCheckBox(Messages.getMessage("Document.Options.Soft.Tabs"), softTabs);
            this.addComponent(this.m_m_softTabsCheckBox, Messages.getMessage("Document.Options.Soft.Tabs.ToolTip"));
        }

        protected void _save() {
            if (!this.m_m_lineSeparators.get(this.m_m_lineSeparatorComboBox.getSelectedItem()).toString().equals(DocumentBuffer.this.getProperty("line-separator"))) {
                DocumentBuffer.this.setDirty(true);
                DocumentBuffer.this.setProperty("line-separator", this.m_m_lineSeparators.get(this.m_m_lineSeparatorComboBox.getSelectedItem()).toString());
            }
            if (!String.valueOf(this.formatCheckBox.isSelected()).equals(DocumentBuffer.this.getProperty("format-pretty-print"))) {
                DocumentBuffer.this.setDirty(true);
                DocumentBuffer.this.setProperty("format-pretty-print", String.valueOf(this.formatCheckBox.isSelected()));
            }
            if (!String.valueOf(this.m_m_softTabsCheckBox.isSelected()).equals(DocumentBuffer.this.getProperty("soft-tabs"))) {
                DocumentBuffer.this.setDirty(true);
                DocumentBuffer.this.setProperty("soft-tabs", String.valueOf(this.m_m_softTabsCheckBox.isSelected()));
            }
            if (!String.valueOf(this.m_m_validatingCheckBox.isSelected()).equals(DocumentBuffer.this.getProperty("validating"))) {
                DocumentBuffer.this.setProperty("validating", String.valueOf(this.m_m_validatingCheckBox.isSelected()));
            }
            if (!this.encodingComboBox.getSelectedItem().toString().equals(DocumentBuffer.this.getProperty("encoding"))) {
                DocumentBuffer.this.setDirty(true);
                DocumentBuffer.this.setProperty("encoding", this.encodingComboBox.getSelectedItem().toString());
            }
            if (!DocumentBuffer.this.getProperty("indent").equals(this.indentComboBox.getSelectedItem().toString())) {
                try {
                    DocumentBuffer.this.setProperty("indent", new Integer(this.indentComboBox.getSelectedItem().toString()).toString());
                    if (MiscUtilities.isTrue(DocumentBuffer.this.getProperty("format-pretty-print")) && MiscUtilities.isTrue(DocumentBuffer.this.getProperty("soft-tabs"))) {
                        DocumentBuffer.this.setDirty(true);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public String getName() {
            return "documentbuffer";
        }

        public String getTitle() {
            return Messages.getMessage("Document.Options.Title");
        }
    }
}

