/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.dom;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import net.sourceforge.jsxe.util.Log;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;

public class DOMSerializerConfiguration
implements DOMConfiguration {
    public static final String CANONICAL_FORM = "canonical-form";
    public static final String CDATA_SECTIONS = "cdata-sections";
    public static final String CHAR_NORMALIZATION = "check-character-normalization";
    public static final String COMMENTS = "comments";
    public static final String DATATYPE_NORMALIZATION = "datatype-normalization";
    public static final String ENTITIES = "entities";
    public static final String ERROR_HANDLER = "error-handler";
    public static final String INFOSET = "infoset";
    public static final String NAMESPACES = "namespaces";
    public static final String NAMESPACE_DECLARATIONS = "namespace-declarations";
    public static final String NORMALIZE_CHARS = "normalize-characters";
    public static final String SPLIT_CDATA = "split-cdata-sections";
    public static final String VALIDATE_XML = "validate";
    public static final String VALIDATE_IF_SCHEMA = "validate-if-schema";
    public static final String WELL_FORMED = "well-formed";
    public static final String WS_IN_ELEMENT_CONTENT = "element-content-whitespace";
    public static final String DISCARD_DEFAULT_CONTENT = "discard-default-content";
    public static final String FORMAT_XML = "format-pretty-print";
    public static final String IGNORE_UNKNOWN_CHAR_DENORM = "ignore-unknown-character-denormalizations";
    public static final String XML_DECLARATION = "xml-declaration";
    public static final String SOFT_TABS = "soft-tabs";
    public static final String INDENT = "indent";
    public static final String XML_ENCODING = "encoding";
    private static ArrayList m_supportedParameters = null;
    private Hashtable m_parameters = new Hashtable(16);

    public DOMSerializerConfiguration() {
        this.setFeature(CANONICAL_FORM, false);
        this.setFeature(CDATA_SECTIONS, true);
        this.setFeature(CHAR_NORMALIZATION, false);
        this.setFeature(COMMENTS, true);
        this.setFeature(DATATYPE_NORMALIZATION, false);
        this.setFeature(ENTITIES, true);
        this.setFeature(NAMESPACES, true);
        this.setFeature(NAMESPACE_DECLARATIONS, true);
        this.setFeature(NORMALIZE_CHARS, true);
        this.setFeature(SPLIT_CDATA, true);
        this.setFeature(VALIDATE_XML, false);
        this.setFeature(VALIDATE_IF_SCHEMA, false);
        this.setFeature(WELL_FORMED, true);
        this.setFeature(WS_IN_ELEMENT_CONTENT, true);
        this.setFeature(DISCARD_DEFAULT_CONTENT, true);
        this.setFeature(FORMAT_XML, false);
        this.setFeature(IGNORE_UNKNOWN_CHAR_DENORM, true);
        this.setFeature(XML_DECLARATION, true);
        this.setFeature(SOFT_TABS, false);
        this.setParameter(INDENT, new Integer(4));
        this.setParameter(XML_ENCODING, null);
    }

    public DOMSerializerConfiguration(DOMConfiguration config) throws DOMException {
        this();
        Iterator iterator = m_supportedParameters.iterator();
        while (iterator.hasNext()) {
            String param = iterator.next().toString();
            this.setParameter(param, config.getParameter(param));
        }
    }

    public boolean canSetParameter(String name, Object value) {
        if (value == null) {
            return m_supportedParameters.indexOf(name) != -1;
        }
        if (value instanceof Boolean) {
            boolean booleanValue = (Boolean)value;
            if (name.equals(CANONICAL_FORM)) {
                return !booleanValue;
            }
            if (name.equals(CDATA_SECTIONS)) {
                return true;
            }
            if (name.equals(CHAR_NORMALIZATION)) {
                return !booleanValue;
            }
            if (name.equals(COMMENTS)) {
                return true;
            }
            if (name.equals(DATATYPE_NORMALIZATION)) {
                return true;
            }
            if (name.equals(ENTITIES)) {
                return true;
            }
            if (name.equals(WELL_FORMED)) {
                return true;
            }
            if (name.equals(INFOSET)) {
                return true;
            }
            if (name.equals(NAMESPACES)) {
                return true;
            }
            if (name.equals(NAMESPACE_DECLARATIONS)) {
                return true;
            }
            if (name.equals(NORMALIZE_CHARS)) {
                return true;
            }
            if (name.equals(SPLIT_CDATA)) {
                return true;
            }
            if (name.equals(VALIDATE_XML)) {
                return !booleanValue;
            }
            if (name.equals(VALIDATE_IF_SCHEMA)) {
                return !booleanValue;
            }
            if (name.equals(WS_IN_ELEMENT_CONTENT)) {
                return true;
            }
            if (name.equals(DISCARD_DEFAULT_CONTENT)) {
                return true;
            }
            if (name.equals(FORMAT_XML)) {
                return true;
            }
            if (name.equals(IGNORE_UNKNOWN_CHAR_DENORM)) {
                return booleanValue;
            }
            if (name.equals(XML_DECLARATION)) {
                return true;
            }
            return name.equals(SOFT_TABS);
        }
        if (name.equals(ERROR_HANDLER) && value instanceof DOMErrorHandler) {
            return true;
        }
        if (name.equals(INDENT) && value instanceof Integer) {
            return true;
        }
        return name.equals(XML_ENCODING) && value instanceof String;
    }

    public Object getParameter(String name) throws DOMException {
        if (m_supportedParameters.indexOf(name) != -1) {
            if (name.equals(INFOSET)) {
                boolean namespaceDeclarations = this.getFeature(NAMESPACE_DECLARATIONS);
                boolean validateIfSchema = this.getFeature(VALIDATE_IF_SCHEMA);
                boolean entities = this.getFeature(ENTITIES);
                boolean datatypeNormalization = this.getFeature(DATATYPE_NORMALIZATION);
                boolean cdataSections = this.getFeature(CDATA_SECTIONS);
                boolean whitespace = this.getFeature(WS_IN_ELEMENT_CONTENT);
                boolean comments = this.getFeature(COMMENTS);
                boolean namespaces = this.getFeature(NAMESPACES);
                return !namespaceDeclarations && !validateIfSchema && !entities && !datatypeNormalization && !cdataSections && whitespace && comments && namespaces;
            }
            return this.m_parameters.get(name);
        }
        throw new DOMException(8, "NOT_FOUND_ERR: Parameter " + name + " not recognized");
    }

    public DOMStringList getParameterNames() {
        return new DOMStringListImpl(m_supportedParameters);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setParameter(String name, Object value) throws DOMException {
        if (value instanceof String && (value.toString().equalsIgnoreCase("true") || value.toString().equalsIgnoreCase("false"))) {
            Log.log(7, this, "Possibly setting XML serializer config boolean feature " + name + " with string value");
        }
        if (m_supportedParameters.indexOf(name) == -1) throw new DOMException(8, "Parameter " + name + " is not recognized.");
        if (value != null) {
            if (!this.canSetParameter(name, value)) throw new DOMException(9, "Parameter " + name + " and value " + value.toString() + " not supported.");
            if (name.equals(INFOSET)) {
                this.setFeature(NAMESPACE_DECLARATIONS, false);
                this.setFeature(VALIDATE_IF_SCHEMA, false);
                this.setFeature(ENTITIES, false);
                this.setFeature(DATATYPE_NORMALIZATION, false);
                this.setFeature(CDATA_SECTIONS, false);
                this.setFeature(WS_IN_ELEMENT_CONTENT, true);
                this.setFeature(COMMENTS, true);
                this.setFeature(NAMESPACES, true);
                return;
            }
            if (name.equals(FORMAT_XML) && ((Boolean)value).booleanValue()) {
                this.setFeature(CANONICAL_FORM, false);
            }
            this.m_parameters.put(name, value);
            return;
        } else {
            this.m_parameters.remove(name);
        }
    }

    public boolean getFeature(String name) throws DOMException {
        Object parameter = this.getParameter(name);
        if (name.equals(ERROR_HANDLER) || name.equals(INDENT) || !(parameter instanceof Boolean)) {
            throw new DOMException(8, "NOT_FOUND_ERR: " + name + " is not a feature.");
        }
        return (Boolean)parameter;
    }

    public void setFeature(String name, boolean value) throws DOMException {
        this.setParameter(name, value);
    }

    static {
        m_supportedParameters = new ArrayList(22);
        m_supportedParameters.add(CANONICAL_FORM);
        m_supportedParameters.add(CDATA_SECTIONS);
        m_supportedParameters.add(CHAR_NORMALIZATION);
        m_supportedParameters.add(COMMENTS);
        m_supportedParameters.add(DATATYPE_NORMALIZATION);
        m_supportedParameters.add(ENTITIES);
        m_supportedParameters.add(ERROR_HANDLER);
        m_supportedParameters.add(INFOSET);
        m_supportedParameters.add(NAMESPACES);
        m_supportedParameters.add(NAMESPACE_DECLARATIONS);
        m_supportedParameters.add(NORMALIZE_CHARS);
        m_supportedParameters.add(SPLIT_CDATA);
        m_supportedParameters.add(VALIDATE_XML);
        m_supportedParameters.add(VALIDATE_IF_SCHEMA);
        m_supportedParameters.add(WELL_FORMED);
        m_supportedParameters.add(WS_IN_ELEMENT_CONTENT);
        m_supportedParameters.add(DISCARD_DEFAULT_CONTENT);
        m_supportedParameters.add(FORMAT_XML);
        m_supportedParameters.add(IGNORE_UNKNOWN_CHAR_DENORM);
        m_supportedParameters.add(XML_DECLARATION);
        m_supportedParameters.add(SOFT_TABS);
        m_supportedParameters.add(INDENT);
        m_supportedParameters.add(XML_ENCODING);
    }

    private static class DOMStringListImpl
    implements DOMStringList {
        private ArrayList m_list;

        public DOMStringListImpl(ArrayList list) {
            this.m_list = list;
        }

        public boolean contains(String str) {
            for (int i = 0; i < this.m_list.size(); ++i) {
                if (!this.m_list.get(i).toString().equals(str)) continue;
                return true;
            }
            return false;
        }

        public int getLength() {
            return this.m_list.size();
        }

        public String item(int index) {
            return this.m_list.get(index).toString();
        }
    }
}

