/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.dom.completion;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.jsxe.dom.completion.CompletionInfo;
import net.sourceforge.jsxe.util.MiscUtilities;

public class ElementDecl {
    public CompletionInfo completionInfo;
    public String name;
    public boolean empty;
    public boolean any;
    private List attributes;
    private Map attributeHash;
    public Set content;

    public ElementDecl(CompletionInfo completionInfo, String name, String content) {
        this.completionInfo = completionInfo;
        this.name = name;
        if (content != null) {
            this.setContent(content);
        }
        this.attributes = new ArrayList();
        this.attributeHash = new HashMap();
    }

    public ElementDecl(CompletionInfo completionInfo, String name, boolean empty, boolean any, List attributes, Map attributeHash, Set content) {
        this.completionInfo = completionInfo;
        this.name = name;
        this.empty = empty;
        this.any = any;
        this.attributes = attributes;
        this.attributeHash = attributeHash;
        this.content = content;
    }

    public void setContent(String content) {
        if (content.equals("EMPTY")) {
            this.empty = true;
        } else if (content.equals("ANY")) {
            this.any = true;
        } else {
            this.content = new HashSet();
            StringTokenizer st = new StringTokenizer(content, "(?*+|,) \t\n");
            while (st.hasMoreTokens()) {
                String element = st.nextToken();
                if (element.equals("#PCDATA")) continue;
                this.content.add(element);
            }
        }
    }

    public ElementDecl withPrefix(String prefix) {
        if (prefix == null || prefix.equals("")) {
            return this;
        }
        return new ElementDecl(this.completionInfo, prefix + ':' + this.name, this.empty, this.any, this.attributes, this.attributeHash, this.content);
    }

    public List getChildElements(String prefix) {
        ArrayList<ElementDecl> children;
        block4: {
            block3: {
                children = new ArrayList<ElementDecl>(100);
                if (!this.any) break block3;
                for (int i = 0; i < this.completionInfo.elements.size(); ++i) {
                    children.add(((ElementDecl)this.completionInfo.elements.get(i)).withPrefix(prefix));
                }
                break block4;
            }
            for (int i = 0; i < this.completionInfo.elementsAllowedAnywhere.size(); ++i) {
                children.add(((ElementDecl)this.completionInfo.elementsAllowedAnywhere.get(i)).withPrefix(prefix));
            }
            if (this.content == null) break block4;
            Iterator iter = this.content.iterator();
            while (iter.hasNext()) {
                ElementDecl decl = this.completionInfo.getElement(iter.next().toString());
                if (decl == null) continue;
                children.add(decl.withPrefix(prefix));
            }
        }
        return children;
    }

    public AttributeDecl getAttribute(String name) {
        return (AttributeDecl)this.attributeHash.get(name);
    }

    public void addAttribute(AttributeDecl attribute) {
        this.attributeHash.put(attribute.name, attribute);
        for (int i = 0; i < this.attributes.size(); ++i) {
            AttributeDecl attr = (AttributeDecl)this.attributes.get(i);
            if (attr.name.compareTo(attribute.name) <= 0) continue;
            this.attributes.add(i, attribute);
            return;
        }
        this.attributes.add(attribute);
    }

    public List getAttributes() {
        return this.attributes;
    }

    public String getRequiredAttributesString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.attributes.size(); ++i) {
            AttributeDecl attr = (AttributeDecl)this.attributes.get(i);
            if (!attr.required) continue;
            buf.append(' ');
            buf.append(attr.name);
            buf.append("=\"");
            if (attr.value != null) {
                buf.append(attr.value);
            }
            buf.append('\"');
        }
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<element name=\"");
        buf.append(this.name);
        buf.append('\"');
        buf.append("\ncontent=\"");
        if (this.empty) {
            buf.append("EMPTY");
        } else if (this.content != null) {
            buf.append('(');
            Iterator iter = this.content.iterator();
            while (iter.hasNext()) {
                buf.append(iter.next());
                if (!iter.hasNext()) continue;
                buf.append('|');
            }
            buf.append(')');
        }
        buf.append('\"');
        if (this.attributes.size() == 0) {
            buf.append(" />");
        } else {
            buf.append(">\n");
            for (int i = 0; i < this.attributes.size(); ++i) {
                buf.append(this.attributes.get(i));
                buf.append('\n');
            }
            buf.append("</element>");
        }
        return buf.toString();
    }

    public static class Compare
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            return MiscUtilities.compareStrings(((ElementDecl)obj1).name, ((ElementDecl)obj2).name, true);
        }
    }

    public static class AttributeDecl {
        public String name;
        public String value;
        public ArrayList values;
        public String type;
        public boolean required;

        public AttributeDecl(String name, String value, ArrayList values, String type, boolean required) {
            this.name = name;
            this.value = value;
            this.values = values;
            this.type = type;
            this.required = required;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("<attribute name=\"");
            buf.append(this.name);
            buf.append('\"');
            if (this.value != null) {
                buf.append(" value=\"");
                buf.append(this.value);
                buf.append('\"');
            }
            buf.append(" type=\"");
            buf.append(this.type);
            buf.append('\"');
            if (this.required) {
                buf.append(" required=\"true\"");
            }
            buf.append(" />");
            return buf.toString();
        }
    }
}

