/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.sourceforge.jsxe.DocumentBuffer;
import net.sourceforge.jsxe.gui.EnhancedDialog;
import net.sourceforge.jsxe.gui.GridPanel;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.gui.TabbedView;
import net.sourceforge.jsxe.gui.VariableGridLayout;
import net.sourceforge.jsxe.options.OptionPane;

public class DocumentOptionsDialog
extends EnhancedDialog {
    private static final String DIALOG_NAME = "Document.Options";
    private TabbedView m_view;
    private JButton m_okButton;
    private JButton m_cancelButton;
    private OptionPane m_optionPane;

    public DocumentOptionsDialog(TabbedView parent) {
        super(parent, Messages.getMessage("Document.Options.Title"), true);
        this.m_view = parent;
        DocumentBuffer buffer = this.m_view.getDocumentBuffer();
        this.m_optionPane = buffer.getOptionPane();
        this.m_optionPane.init();
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        GridPanel panel = new GridPanel();
        panel.addComponent(DocumentOptionsDialog.createMultilineLabel(Messages.getMessage("Document.Options.Message")));
        panel.addSeparator();
        panel.addComponent(this.m_optionPane.getComponent());
        this.getContentPane().add((Component)panel, "Center");
        Box buttons = new Box(0);
        buttons.add(Box.createGlue());
        this.m_okButton = new JButton(Messages.getMessage("common.ok"));
        this.m_okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentOptionsDialog.this.ok();
            }
        });
        buttons.add(this.m_okButton);
        this.m_cancelButton = new JButton(Messages.getMessage("common.cancel"));
        this.m_cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentOptionsDialog.this.cancel();
            }
        });
        buttons.add(this.m_cancelButton);
        buttons.add(Box.createGlue());
        this.getContentPane().add((Component)buttons, "South");
        DocumentOptionsDialog.loadGeometry(this, DIALOG_NAME);
        this.setVisible(true);
    }

    public void ok() {
        this.m_optionPane.save();
        this.cancel();
    }

    public void cancel() {
        DocumentOptionsDialog.saveGeometry(this, DIALOG_NAME);
        this.dispose();
    }

    public static JComponent createMultilineLabel(String str) {
        int index;
        JPanel panel = new JPanel(new VariableGridLayout(2, 1, 1, 1));
        int lastOffset = 0;
        while ((index = str.indexOf(10, lastOffset)) != -1) {
            panel.add(new JLabel(str.substring(lastOffset, index)));
            lastOffset = index + 1;
        }
        if (lastOffset != str.length()) {
            panel.add(new JLabel(str.substring(lastOffset)));
        }
        return panel;
    }
}

