/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import net.sourceforge.jsxe.OperatingSystem;
import net.sourceforge.jsxe.jsXe;

public abstract class EnhancedDialog
extends JDialog {
    protected KeyHandler keyHandler;

    public EnhancedDialog(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this._init();
    }

    public EnhancedDialog(Dialog parent, String title, boolean modal) {
        super(parent, title, modal);
        this._init();
    }

    public static void loadGeometry(Window win, String name) {
        int y;
        int x;
        Dimension size = win.getSize();
        Dimension screen = win.getToolkit().getScreenSize();
        int width = jsXe.getIntegerProperty(name + ".width", size.width);
        int height = jsXe.getIntegerProperty(name + ".height", size.height);
        Container parent = win.getParent();
        if (parent == null) {
            x = (screen.width - width) / 2;
            y = (screen.height - height) / 2;
        } else {
            Rectangle bounds = parent.getBounds();
            x = bounds.x + (bounds.width - width) / 2;
            y = bounds.y + (bounds.height - height) / 2;
        }
        x = jsXe.getIntegerProperty(name + ".x", x);
        y = jsXe.getIntegerProperty(name + ".y", y);
        Rectangle osbounds = OperatingSystem.getScreenBounds();
        if (x < osbounds.x || x + width > osbounds.width) {
            if (width > osbounds.width) {
                width = osbounds.width;
            }
            x = (osbounds.width - width) / 2;
        }
        if (y < osbounds.y || y + height > osbounds.height) {
            if (height >= osbounds.height) {
                height = osbounds.height;
            }
            y = (osbounds.height - height) / 2;
        }
        Rectangle desired = new Rectangle(x, y, width, height);
        win.setBounds(desired);
        if (win instanceof Frame) {
            int extState = jsXe.getIntegerProperty(name + ".extendedState", 0);
            ((Frame)win).setExtendedState(extState);
        }
    }

    public static void saveGeometry(Window win, String name) {
        if (win instanceof Frame) {
            int extState = ((Frame)win).getExtendedState();
            jsXe.setIntegerProperty(name + ".extendedState", extState);
            if (extState != 0) {
                return;
            }
        }
        Rectangle bounds = win.getBounds();
        jsXe.setIntegerProperty(name + ".x", bounds.x);
        jsXe.setIntegerProperty(name + ".y", bounds.y);
        jsXe.setIntegerProperty(name + ".width", bounds.width);
        jsXe.setIntegerProperty(name + ".height", bounds.height);
    }

    public abstract void ok();

    public abstract void cancel();

    private void _init() {
        this.getLayeredPane().addContainerListener(new ContainerHandler());
        this.getContentPane().addContainerListener(new ContainerHandler());
        this.keyHandler = new KeyHandler();
        this.addKeyListener(this.keyHandler);
        this.addWindowListener(new WindowHandler());
        this.setResizable(true);
        this.setDefaultCloseOperation(0);
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            EnhancedDialog.this.cancel();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            if (evt.getKeyCode() == 10) {
                for (Component comp = EnhancedDialog.this.getFocusOwner(); comp != null; comp = comp.getParent()) {
                    Object selected;
                    if (!(comp instanceof JComboBox)) continue;
                    JComboBox combo = (JComboBox)comp;
                    if (!combo.isEditable() || (selected = combo.getEditor().getItem()) == null) break;
                    combo.setSelectedItem(selected);
                    break;
                }
                EnhancedDialog.this.ok();
                evt.consume();
            } else if (evt.getKeyCode() == 27) {
                EnhancedDialog.this.cancel();
                evt.consume();
            }
        }
    }

    class ContainerHandler
    extends ContainerAdapter {
        ContainerHandler() {
        }

        public void componentAdded(ContainerEvent evt) {
            this.componentAdded(evt.getChild());
        }

        public void componentRemoved(ContainerEvent evt) {
            this.componentRemoved(evt.getChild());
        }

        private void componentAdded(Component comp) {
            comp.addKeyListener(EnhancedDialog.this.keyHandler);
            if (comp instanceof Container) {
                Container cont = (Container)comp;
                cont.addContainerListener(this);
                Component[] comps = cont.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    this.componentAdded(comps[i]);
                }
            }
        }

        private void componentRemoved(Component comp) {
            comp.removeKeyListener(EnhancedDialog.this.keyHandler);
            if (comp instanceof Container) {
                Container cont = (Container)comp;
                cont.removeContainerListener(this);
                Component[] comps = cont.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    this.componentRemoved(comps[i]);
                }
            }
        }
    }
}

