/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.gui;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.sourceforge.jsxe.gui.GUIUtilities;
import net.sourceforge.jsxe.gui.KeyEventTranslator;
import net.sourceforge.jsxe.gui.KeyEventWorkaround;
import net.sourceforge.jsxe.gui.Messages;

public class GrabKeyDialog
extends JDialog {
    private InputPane shortcut;
    private JLabel assignedTo;
    private JButton ok;
    private JButton remove;
    private JButton cancel;
    private JButton clear;
    private boolean isOK;
    private KeyBinding binding;
    private Vector allBindings;

    public static String toString(KeyEvent evt) {
        String id;
        switch (evt.getID()) {
            case 401: {
                id = "KEY_PRESSED";
                break;
            }
            case 402: {
                id = "KEY_RELEASED";
                break;
            }
            case 400: {
                id = "KEY_TYPED";
                break;
            }
            default: {
                id = "unknown type";
            }
        }
        return id + ",keyCode=0x" + Integer.toString(evt.getKeyCode(), 16) + ",keyChar=0x" + Integer.toString(evt.getKeyChar(), 16) + ",modifiers=0x" + Integer.toString(evt.getModifiers(), 16);
    }

    public GrabKeyDialog(Dialog parent, KeyBinding binding, Vector allBindings) {
        super(parent, Messages.getMessage("Grab.Key.title"), true);
        this.init(binding, allBindings);
    }

    public GrabKeyDialog(Frame parent, KeyBinding binding, Vector allBindings) {
        super(parent, Messages.getMessage("Grab.Key.title"), true);
        this.init(binding, allBindings);
    }

    public String getShortcut() {
        if (this.isOK) {
            KeyEventTranslator.Key key = this.shortcut.getKey();
            if (key != null) {
                return key.getInternalShortcut();
            }
            return null;
        }
        return null;
    }

    public boolean isOK() {
        return this.isOK;
    }

    public boolean isManagingFocus() {
        return false;
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    protected void processKeyEvent(KeyEvent evt) {
        this.shortcut.processKeyEvent(evt);
    }

    private void init(KeyBinding binding, Vector allBindings) {
        this.binding = binding;
        this.allBindings = allBindings;
        this.enableEvents(8L);
        JPanel content = new JPanel(new GridLayout(0, 1, 0, 6)){

            public boolean isManagingFocus() {
                return false;
            }

            public boolean getFocusTraversalKeysEnabled() {
                return false;
            }
        };
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        JLabel label = new JLabel(Messages.getMessage("Grab.Key.caption", new String[]{binding.label}));
        Box input = Box.createHorizontalBox();
        this.shortcut = new InputPane();
        input.add(this.shortcut);
        input.add(Box.createHorizontalStrut(12));
        this.clear = new JButton(Messages.getMessage("Grab.Key.clear"));
        this.clear.addActionListener(new ActionHandler());
        input.add(this.clear);
        this.assignedTo = new JLabel();
        this.updateAssignedTo(null);
        Box buttons = Box.createHorizontalBox();
        buttons.add(Box.createGlue());
        this.ok = new JButton(Messages.getMessage("common.ok"));
        this.ok.addActionListener(new ActionHandler());
        buttons.add(this.ok);
        buttons.add(Box.createHorizontalStrut(12));
        if (binding.isAssigned()) {
            this.remove = new JButton(Messages.getMessage("Grab.Key.remove"));
            this.remove.addActionListener(new ActionHandler());
            buttons.add(this.remove);
            buttons.add(Box.createHorizontalStrut(12));
        }
        this.cancel = new JButton(Messages.getMessage("common.cancel"));
        this.cancel.addActionListener(new ActionHandler());
        buttons.add(this.cancel);
        buttons.add(Box.createGlue());
        content.add(label);
        content.add(input);
        content.add(this.assignedTo);
        content.add(buttons);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
        this.setVisible(true);
    }

    private void updateAssignedTo(String shortcut) {
        String text = Messages.getMessage("Grab.Key.assigned-to.none");
        KeyBinding kb = this.getKeyBinding(shortcut);
        if (kb != null) {
            text = kb.label;
        }
        if (this.ok != null) {
            this.ok.setEnabled(kb == null);
        }
        this.assignedTo.setText(Messages.getMessage("Grab.Key.assigned-to", new String[]{text}));
    }

    private KeyBinding getKeyBinding(String shortcut) {
        if (shortcut == null || shortcut.length() == 0) {
            return null;
        }
        Enumeration e = this.allBindings.elements();
        while (e.hasMoreElements()) {
            KeyBinding kb = (KeyBinding)e.nextElement();
            if (!kb.isAssigned() || !shortcut.equals(kb.shortcut)) continue;
            return kb;
        }
        return null;
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == GrabKeyDialog.this.ok) {
                if (this.canClose()) {
                    GrabKeyDialog.this.dispose();
                }
            } else if (evt.getSource() == GrabKeyDialog.this.remove) {
                GrabKeyDialog.this.shortcut.setText(null);
                GrabKeyDialog.this.isOK = true;
                GrabKeyDialog.this.dispose();
            } else if (evt.getSource() == GrabKeyDialog.this.cancel) {
                GrabKeyDialog.this.dispose();
            } else if (evt.getSource() == GrabKeyDialog.this.clear) {
                GrabKeyDialog.this.shortcut.setText(null);
                GrabKeyDialog.this.updateAssignedTo(null);
                GrabKeyDialog.this.shortcut.requestFocus();
            }
        }

        private boolean canClose() {
            KeyBinding other;
            String shortcutString = GrabKeyDialog.this.shortcut.getText();
            if (shortcutString.length() == 0 && GrabKeyDialog.this.binding.isAssigned()) {
                int answer = GUIUtilities.confirm(GrabKeyDialog.this, "Grab.Key.remove-ask", null, 0, 3);
                if (answer == 0) {
                    GrabKeyDialog.this.shortcut.setText(null);
                    GrabKeyDialog.this.isOK = true;
                } else {
                    return false;
                }
            }
            if ((other = GrabKeyDialog.this.getKeyBinding(shortcutString)) == null || other == GrabKeyDialog.this.binding) {
                GrabKeyDialog.this.isOK = true;
                return true;
            }
            if (other.name == ((GrabKeyDialog)GrabKeyDialog.this).binding.name) {
                GUIUtilities.error(GrabKeyDialog.this, "Grab.Key.duplicate-alt-shortcut", null);
                return false;
            }
            int answer = GUIUtilities.confirm(GrabKeyDialog.this, "Grab.Key.duplicate-shortcut", new Object[]{other.label}, 0, 3);
            if (answer == 0) {
                if (other.shortcut != null && shortcutString.startsWith(other.shortcut)) {
                    other.shortcut = null;
                }
                GrabKeyDialog.this.isOK = true;
                return true;
            }
            return false;
        }
    }

    private class InputPane
    extends JTextField {
        private KeyEventTranslator.Key m_key = null;

        private InputPane() {
        }

        public boolean getFocusTraversalKeysEnabled() {
            return false;
        }

        protected void processKeyEvent(KeyEvent _evt) {
            KeyEvent evt = KeyEventWorkaround.processKeyEvent(_evt);
            if (evt == null) {
                return;
            }
            evt.consume();
            KeyEventTranslator.Key key = KeyEventTranslator.translateKeyEvent(evt);
            if (key == null) {
                return;
            }
            String internalShortcut = key.getInternalShortcut();
            if (internalShortcut == null) {
                return;
            }
            this.setText(key.toString());
            GrabKeyDialog.this.updateAssignedTo(internalShortcut);
            this.m_key = key;
        }

        public KeyEventTranslator.Key getKey() {
            return this.m_key;
        }
    }

    public static class KeyBinding {
        public String name;
        public String label;
        public String shortcut;

        public KeyBinding(String name, String label, String shortcut) {
            this.name = name;
            this.label = label;
            this.shortcut = shortcut;
        }

        public boolean isAssigned() {
            return this.shortcut != null && this.shortcut.length() > 0;
        }
    }
}

