/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.sourceforge.jsxe.gui.EnhancedDialog;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.jsXe;
import net.sourceforge.jsxe.options.OptionGroup;
import net.sourceforge.jsxe.options.OptionPane;

public abstract class OptionsDialog
extends EnhancedDialog
implements ActionListener,
TreeSelectionListener {
    private String name;
    private JSplitPane splitter;
    private JTree paneTree;
    private JPanel cardPanel;
    private JLabel currentLabel;
    private JButton ok;
    private JButton cancel;
    private JButton apply;
    private String currentPane;
    private String firstPane;
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    public OptionsDialog(Frame frame, String name, String title, String pane) {
        super(frame, title, true);
        this.init(name, pane);
    }

    public OptionsDialog(Dialog dialog, String name, String title, String pane) {
        super(dialog, title, true);
        this.init(name, pane);
    }

    public void addOptionGroup(OptionGroup group) {
        this.addOptionGroup(group, this.getDefaultGroup());
    }

    public void addOptionPane(OptionPane pane) {
        this.addOptionPane(pane, this.getDefaultGroup());
    }

    public void ok() {
        jsXe.setProperty(this.name + ".last", this.currentPane);
        this.ok(true);
    }

    public void cancel() {
        jsXe.setProperty(this.name + ".last", this.currentPane);
        OptionsDialog.saveGeometry(this, this.name);
        jsXe.setIntegerProperty(this.name + ".splitter", this.splitter.getDividerLocation());
        this.dispose();
    }

    public void ok(boolean dispose) {
        OptionTreeModel m = (OptionTreeModel)this.paneTree.getModel();
        ((OptionGroup)m.getRoot()).save();
        OptionsDialog.saveGeometry(this, this.name);
        jsXe.setIntegerProperty(this.name + ".splitter", this.splitter.getDividerLocation());
        if (dispose) {
            this.dispose();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.ok) {
            this.ok();
        } else if (source == this.cancel) {
            this.cancel();
        } else if (source == this.apply) {
            this.ok(false);
        }
    }

    public void valueChanged(TreeSelectionEvent evt) {
        int i;
        TreePath path = evt.getPath();
        if (path == null || !(path.getLastPathComponent() instanceof OptionPane)) {
            return;
        }
        Object[] nodes = path.getPath();
        StringBuffer buf = new StringBuffer();
        OptionPane optionPane = null;
        String name = null;
        int lastIdx = nodes.length - 1;
        int n = i = this.paneTree.isRootVisible() ? 0 : 1;
        while (i <= lastIdx) {
            block11: {
                String label;
                block10: {
                    block9: {
                        label = null;
                        if (!(nodes[i] instanceof OptionPane)) break block9;
                        optionPane = (OptionPane)nodes[i];
                        name = optionPane.getName();
                        label = optionPane.getTitle();
                        break block10;
                    }
                    if (!(nodes[i] instanceof OptionGroup)) break block11;
                    OptionGroup group = (OptionGroup)nodes[i];
                    name = group.getName();
                    label = group.getTitle();
                }
                if (name != null) {
                    if (label == null) {
                        buf.append(name);
                    } else {
                        buf.append(label);
                    }
                }
                if (i != lastIdx) {
                    buf.append(": ");
                }
            }
            ++i;
        }
        this.currentLabel.setText(buf.toString());
        optionPane.init();
        ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, name);
        this.addNotify();
        this.updateSize();
        this.currentPane = name;
    }

    protected abstract OptionTreeModel createOptionTreeModel();

    protected abstract OptionGroup getDefaultGroup();

    protected void addOptionGroup(OptionGroup child, OptionGroup parent) {
        Enumeration members = child.getMembers();
        while (members.hasMoreElements()) {
            Object elem = members.nextElement();
            if (elem instanceof OptionPane) {
                this.addOptionPane((OptionPane)elem, child);
                continue;
            }
            if (!(elem instanceof OptionGroup)) continue;
            this.addOptionGroup((OptionGroup)elem, child);
        }
        parent.addOptionGroup(child);
    }

    protected void addOptionPane(OptionPane pane, OptionGroup parent) {
        String name = pane.getName();
        if (this.firstPane == null) {
            this.firstPane = name;
        }
        this.cardPanel.add(pane.getComponent(), name);
        parent.addOptionPane(pane);
    }

    private void init(String name, String pane) {
        this.name = name;
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        JPanel stage = new JPanel(new BorderLayout(6, 6));
        this.currentLabel = new JLabel();
        this.currentLabel.setHorizontalAlignment(2);
        stage.add((Component)this.currentLabel, "North");
        this.cardPanel = new JPanel(new CardLayout());
        stage.add((Component)this.cardPanel, "Center");
        this.paneTree = new JTree(this.createOptionTreeModel());
        this.paneTree.setVisibleRowCount(1);
        this.paneTree.setCellRenderer(new PaneNameRenderer());
        this.paneTree.setShowsRootHandles(true);
        this.paneTree.setRootVisible(false);
        JScrollPane scroller = new JScrollPane(this.paneTree, 22, 30);
        this.splitter = new JSplitPane(1, scroller, stage);
        this.splitter.setDividerLocation(scroller.getPreferredSize().width);
        content.add((Component)this.splitter, "Center");
        Box buttons = new Box(0);
        buttons.add(Box.createGlue());
        this.ok = new JButton(Messages.getMessage("common.ok"));
        this.ok.addActionListener(this);
        buttons.add(this.ok);
        buttons.add(Box.createHorizontalStrut(6));
        this.getRootPane().setDefaultButton(this.ok);
        this.cancel = new JButton(Messages.getMessage("common.cancel"));
        this.cancel.addActionListener(this);
        buttons.add(this.cancel);
        buttons.add(Box.createHorizontalStrut(6));
        this.apply = new JButton(Messages.getMessage("common.apply"));
        this.apply.addActionListener(this);
        buttons.add(this.apply);
        buttons.add(Box.createGlue());
        content.add((Component)buttons, "South");
        this.paneTree.getSelectionModel().addTreeSelectionListener(this);
        OptionGroup rootNode = (OptionGroup)this.paneTree.getModel().getRoot();
        for (int i = 0; i < rootNode.getMemberCount(); ++i) {
            this.paneTree.expandPath(new TreePath(new Object[]{rootNode, rootNode.getMember(i)}));
        }
        if (pane == null || !this.selectPane(rootNode, pane)) {
            this.selectPane(rootNode, this.firstPane);
        }
        OptionsDialog.loadGeometry(this, name);
        int dividerLocation = jsXe.getIntegerProperty(name + ".splitter", 300);
        if (dividerLocation != -1) {
            this.splitter.setDividerLocation(dividerLocation);
        }
        this.updateSize();
        this.setVisible(true);
    }

    private boolean selectPane(OptionGroup node, String name) {
        return this.selectPane(node, name, new ArrayList());
    }

    private boolean selectPane(OptionGroup node, String name, ArrayList path) {
        path.add(node);
        Enumeration members = node.getMembers();
        while (members.hasMoreElements()) {
            Object obj = members.nextElement();
            if (obj instanceof OptionGroup) {
                OptionGroup grp = (OptionGroup)obj;
                if (grp.getName().equals(name)) {
                    path.add(grp);
                    path.add(grp.getMember(0));
                    TreePath treePath = new TreePath(path.toArray());
                    this.paneTree.scrollPathToVisible(treePath);
                    this.paneTree.setSelectionPath(treePath);
                    return true;
                }
                if (!this.selectPane((OptionGroup)obj, name, path)) continue;
                return true;
            }
            OptionPane pane = (OptionPane)obj;
            if (!pane.getName().equals(name)) continue;
            path.add(pane);
            TreePath treePath = new TreePath(path.toArray());
            this.paneTree.scrollPathToVisible(treePath);
            this.paneTree.setSelectionPath(treePath);
            return true;
        }
        path.remove(node);
        return false;
    }

    private void updateSize() {
        Dimension currentSize = this.getSize();
        Dimension requestedSize = this.getPreferredSize();
        Dimension newSize = new Dimension(Math.max(currentSize.width, requestedSize.width), Math.max(currentSize.height, requestedSize.height));
        if (newSize.width < 300) {
            newSize.width = 300;
        }
        if (newSize.height < 200) {
            newSize.height = 200;
        }
        this.setSize(newSize);
        this.validate();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class OptionTreeModel
    implements TreeModel {
        private OptionGroup root = new OptionGroup(null, null);
        private EventListenerList listenerList = new EventListenerList();

        public void addTreeModelListener(TreeModelListener l) {
            this.listenerList.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = OptionsDialog.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
        }

        public void removeTreeModelListener(TreeModelListener l) {
            this.listenerList.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = OptionsDialog.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
        }

        public Object getChild(Object parent, int index) {
            if (parent instanceof OptionGroup) {
                return ((OptionGroup)parent).getMember(index);
            }
            return null;
        }

        public int getChildCount(Object parent) {
            if (parent instanceof OptionGroup) {
                return ((OptionGroup)parent).getMemberCount();
            }
            return 0;
        }

        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof OptionGroup) {
                return ((OptionGroup)parent).getMemberIndex(child);
            }
            return -1;
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object node) {
            return node instanceof OptionPane;
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        protected void fireNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? OptionsDialog.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
                if (modelEvent == null) {
                    modelEvent = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesChanged(modelEvent);
            }
        }

        protected void fireNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? OptionsDialog.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
                if (modelEvent == null) {
                    modelEvent = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesInserted(modelEvent);
            }
        }

        protected void fireNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? OptionsDialog.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
                if (modelEvent == null) {
                    modelEvent = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(modelEvent);
            }
        }

        protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? OptionsDialog.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
                if (modelEvent == null) {
                    modelEvent = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeStructureChanged(modelEvent);
            }
        }
    }

    static class PaneNameRenderer
    extends DefaultTreeCellRenderer {
        private Font paneFont = UIManager.getFont("Tree.font");
        private Font groupFont = this.paneFont.deriveFont(1);

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            String name = null;
            String label = null;
            if (value instanceof OptionGroup) {
                OptionGroup group = (OptionGroup)value;
                name = group.getName();
                label = group.getTitle();
                this.setFont(this.groupFont);
            } else if (value instanceof OptionPane) {
                OptionPane pane = (OptionPane)value;
                label = pane.getTitle();
                name = pane.getName();
                this.setFont(this.paneFont);
            }
            if (name == null) {
                this.setText(null);
            } else {
                if (!(value instanceof OptionPane)) {
                    label = value instanceof OptionGroup ? ((OptionGroup)value).getTitle() : value.toString();
                }
                if (label == null) {
                    this.setText("NO TITLE: " + name);
                } else {
                    this.setText(label);
                }
            }
            this.setIcon(null);
            return this;
        }
    }
}

