/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.sourceforge.jsxe.DocumentBuffer;
import net.sourceforge.jsxe.EBListener;
import net.sourceforge.jsxe.EBMessage;
import net.sourceforge.jsxe.EditBus;
import net.sourceforge.jsxe.OperatingSystem;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.msg.DocumentBufferUpdate;

public class StatusBar
extends JPanel
implements EBListener {
    private JLabel m_centerLabel;
    private JLabel m_leftLabel;
    private JPanel m_mainPanel;

    public StatusBar() {
        super(new BorderLayout());
        this.setBorder(new CompoundBorder(new EmptyBorder(4, 0, 0, OperatingSystem.isMacOS() ? 18 : 0), UIManager.getBorder("TextField.border")));
        this.m_centerLabel = new JLabel(" ");
        this.m_leftLabel = new JLabel(" ");
        this.m_mainPanel = new JPanel(new BorderLayout());
        this.m_mainPanel.add("Center", this.m_centerLabel);
        this.m_mainPanel.add("West", this.m_leftLabel);
        this.m_mainPanel.setBackground(Color.WHITE);
        this.m_mainPanel.setForeground(Color.BLACK);
        this.m_centerLabel.setBackground(Color.WHITE);
        this.m_centerLabel.setForeground(Color.BLACK);
        this.add("Center", this.m_mainPanel);
        EditBus.addToBus(this);
    }

    public void setCenterMessage(String message) {
        this.m_centerLabel.setText(message);
    }

    public String getCenterMessage() {
        return this.m_centerLabel.getText();
    }

    public void setLeftMessage(String message) {
        this.m_leftLabel.setText(message);
    }

    public String getLeftMessage() {
        return this.m_leftLabel.getText();
    }

    public void handleMessage(EBMessage message) {
        if (message instanceof DocumentBufferUpdate) {
            Object what = ((DocumentBufferUpdate)message).getWhat();
            DocumentBuffer source = (DocumentBuffer)message.getSource();
            if (!source.isUntitled()) {
                String msgName;
                if (what.equals(DocumentBufferUpdate.SAVED)) {
                    msgName = "DocumentBuffer.Saved.Message";
                    this.setCenterMessage(Messages.getMessage(msgName, new String[]{source.getName()}));
                }
                if (what.equals(DocumentBufferUpdate.LOADED)) {
                    msgName = "DocumentBuffer.Loaded.Message";
                    this.setCenterMessage(Messages.getMessage(msgName, new String[]{source.getName()}));
                }
                if (what.equals(DocumentBufferUpdate.CLOSED)) {
                    msgName = "DocumentBuffer.Closed.Message";
                    this.setCenterMessage(Messages.getMessage(msgName, new String[]{source.getName()}));
                }
            }
        }
    }
}

