/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.jsxe.ActionManager;
import net.sourceforge.jsxe.ActionPlugin;
import net.sourceforge.jsxe.ActionSet;
import net.sourceforge.jsxe.BufferHistory;
import net.sourceforge.jsxe.DocumentBuffer;
import net.sourceforge.jsxe.DocumentBufferListener;
import net.sourceforge.jsxe.EBListener;
import net.sourceforge.jsxe.EBMessage;
import net.sourceforge.jsxe.EditBus;
import net.sourceforge.jsxe.UnrecognizedPluginException;
import net.sourceforge.jsxe.ViewPlugin;
import net.sourceforge.jsxe.action.ActivityLogAction;
import net.sourceforge.jsxe.action.CopyAction;
import net.sourceforge.jsxe.action.CutAction;
import net.sourceforge.jsxe.action.DocumentOptionsAction;
import net.sourceforge.jsxe.action.FileCloseAction;
import net.sourceforge.jsxe.action.FileCloseAllAction;
import net.sourceforge.jsxe.action.FileExitAction;
import net.sourceforge.jsxe.action.FileNewAction;
import net.sourceforge.jsxe.action.FileOpenAction;
import net.sourceforge.jsxe.action.FileReloadAction;
import net.sourceforge.jsxe.action.FileSaveAction;
import net.sourceforge.jsxe.action.FileSaveAsAction;
import net.sourceforge.jsxe.action.FindAction;
import net.sourceforge.jsxe.action.OpenRecentFileAction;
import net.sourceforge.jsxe.action.PasteAction;
import net.sourceforge.jsxe.action.ToolsOptionsAction;
import net.sourceforge.jsxe.action.ToolsPluginManagerAction;
import net.sourceforge.jsxe.action.ValidationErrorsAction;
import net.sourceforge.jsxe.gui.DocumentView;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.gui.StatusBar;
import net.sourceforge.jsxe.gui.jsxeAboutDialog;
import net.sourceforge.jsxe.gui.menu.WrappingMenu;
import net.sourceforge.jsxe.jsXe;
import net.sourceforge.jsxe.msg.DocumentBufferUpdate;
import net.sourceforge.jsxe.msg.PropertyChanged;
import net.sourceforge.jsxe.util.Log;

public class TabbedView
extends JFrame {
    private static final String _WIDTH = "tabbedview.width";
    private static final String _HEIGHT = "tabbedview.height";
    private static final String _X = "tabbedview.x";
    private static final String _Y = "tabbedview.y";
    private static final ImageIcon m_cleanIcon = new ImageIcon((class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = TabbedView.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe).getResource("/net/sourceforge/jsxe/icons/clean.png"), "clean");
    private static final ImageIcon m_dirtyIcon = new ImageIcon((class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = TabbedView.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe).getResource("/net/sourceforge/jsxe/icons/dirty.png"), "dirty");
    private JMenu m_fileMenu;
    private JMenu m_viewMenu;
    private JMenu m_toolsMenu;
    private JMenu m_helpMenu;
    private WrappingMenu m_recentFilesMenu;
    private ArrayList m_documentViews = new ArrayList();
    private JTabbedPane tabbedPane = new JTabbedPane(1);
    private StatusBar m_statusBar = new StatusBar();
    private JPanel panel;
    private DocumentBufferListener m_docBufListener = new DocumentBufferListener(){

        public void propertiesChanged(DocumentBuffer source, String propertyKey) {
        }

        public void nameChanged(DocumentBuffer source, String newName) {
            TabbedView.this.updateTitle();
            DocumentBuffer[] buffers = jsXe.getDocumentBuffers();
            for (int i = 0; i < buffers.length; ++i) {
                if (buffers[i] != source) continue;
                TabbedView.this.tabbedPane.setTitleAt(i, source.getName());
            }
        }

        public void bufferSaved(DocumentBuffer source) {
        }

        public void statusChanged(DocumentBuffer source, int status, boolean oldStatus) {
            if (status == 1) {
                DocumentBuffer[] buffers = jsXe.getDocumentBuffers();
                for (int i = 0; i < buffers.length; ++i) {
                    if (buffers[i] != source) continue;
                    TabbedView.this.tabbedPane.setIconAt(i, TabbedView.this.getTabIcon(source));
                    return;
                }
            }
        }
    };
    private KeyHandler m_keyHandler = new KeyHandler();
    private ContainerHandler m_containerHandler = new ContainerHandler();
    static /* synthetic */ Class class$net$sourceforge$jsxe$jsXe;

    public TabbedView(DocumentBuffer buffer) throws IOException {
        this.init();
        this.addDocumentBuffer(buffer);
    }

    public TabbedView(DocumentBuffer buffer, String documentViewName) throws IOException, UnrecognizedPluginException {
        this.init();
        this.addDocumentBuffer(buffer, documentViewName);
    }

    public DocumentBuffer getDocumentBuffer() {
        return this.getDocumentView().getDocumentBuffer();
    }

    public DocumentView getDocumentView() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index >= 0) {
            return (DocumentView)this.m_documentViews.get(index);
        }
        return null;
    }

    public DocumentView getDocumentView(DocumentBuffer buffer) {
        if (buffer != null) {
            int docViewCount = this.m_documentViews.size();
            for (int i = 0; i < docViewCount; ++i) {
                DocumentView docView = (DocumentView)this.m_documentViews.get(i);
                if (docView.getDocumentBuffer() != buffer) continue;
                return docView;
            }
        }
        return null;
    }

    public void addDocumentBuffer(DocumentBuffer buffer, String documentViewName) throws IOException, UnrecognizedPluginException {
        ViewPlugin plugin = jsXe.getPluginLoader().getViewPlugin(documentViewName);
        if (plugin == null) {
            throw new UnrecognizedPluginException(documentViewName);
        }
        DocumentView newDocView = plugin.newDocumentView(buffer);
        buffer.addDocumentBufferListener(this.m_docBufListener);
        this.m_documentViews.add(newDocView);
        Component comp = newDocView.getDocumentViewComponent();
        this.addKeyHandler(comp);
        this.tabbedPane.addTab(buffer.getName(), this.getTabIcon(buffer), comp);
        this.tabbedPane.setSelectedComponent(comp);
        this.updateTitle();
    }

    public void addDocumentBuffer(DocumentBuffer buffer) throws IOException {
        if (buffer != null) {
            Iterator types = jsXe.getPluginLoader().getViewPluginNames().iterator();
            StringBuffer buf = new StringBuffer();
            while (types.hasNext()) {
                String viewName = types.next().toString();
                try {
                    this.addDocumentBuffer(buffer, viewName);
                    return;
                }
                catch (IOException ioe) {
                    buf.append(buffer.getName() + ": " + ioe.getMessage() + "\n");
                }
            }
            String msg = Messages.getMessage("DocumentView.Open.Message");
            String error = buf.toString();
            if (!error.equals("")) {
                msg = msg + "\n\n" + error;
            }
            throw new IOException(msg);
        }
    }

    public boolean setDocumentBuffer(DocumentBuffer buffer) throws IOException {
        boolean success = true;
        if (buffer != null) {
            DocumentBuffer[] buffers = jsXe.getDocumentBuffers();
            for (int i = 0; i < buffers.length; ++i) {
                if (buffers[i] != buffer) continue;
                this.tabbedPane.setSelectedIndex(i);
                success = true;
            }
            this.updateTitle();
        }
        return success;
    }

    public boolean removeDocumentBuffer(DocumentBuffer buffer) {
        if (buffer != null) {
            int docViewCount = this.m_documentViews.size();
            for (int i = 0; i < docViewCount; ++i) {
                DocumentView docView = (DocumentView)this.m_documentViews.get(i);
                if (docView.getDocumentBuffer() != buffer || !docView.close()) continue;
                buffer.removeDocumentBufferListener(this.m_docBufListener);
                this.tabbedPane.remove(i);
                this.m_documentViews.remove(docView);
                if (i != docViewCount - 1) {
                    this.updateTitle();
                    this.updateMenuBar();
                }
                return true;
            }
        }
        return false;
    }

    public void reload() throws IOException {
        DocumentBuffer buffer = this.getDocumentBuffer();
        ViewPlugin plugin = this.getDocumentView().getViewPlugin();
        StringBuffer buf = new StringBuffer();
        buffer.reload(this);
        try {
            DocumentView view = plugin.newDocumentView(buffer);
            this.setDocumentView(view);
            return;
        }
        catch (IOException ioe) {
            buf.append(buffer.getName() + ": " + ioe.getMessage() + "\n");
            Iterator types = jsXe.getPluginLoader().getViewPlugins().iterator();
            while (types.hasNext()) {
                plugin = (ViewPlugin)types.next();
                try {
                    DocumentView view = plugin.newDocumentView(buffer);
                    this.setDocumentView(view);
                    return;
                }
                catch (IOException ioe2) {
                    buf.append(buffer.getName() + ": " + ioe.getMessage() + "\n");
                }
            }
            String msg = Messages.getMessage("DocumentView.Open.Message");
            String error = buf.toString();
            if (!error.equals("")) {
                msg = msg + "\n\n" + error;
            }
            throw new IOException(msg);
        }
    }

    public int getBufferCount() {
        return this.tabbedPane.getTabCount();
    }

    public StatusBar getStatusBar() {
        return this.m_statusBar;
    }

    public boolean close() throws IOException {
        Object currentDocView = null;
        if (!jsXe.closeAllDocumentBuffers(this)) {
            return false;
        }
        Rectangle bounds = this.getBounds();
        jsXe.setProperty(_WIDTH, Integer.toString((int)bounds.getWidth()));
        jsXe.setProperty(_HEIGHT, Integer.toString((int)bounds.getHeight()));
        jsXe.setProperty(_X, Integer.toString((int)bounds.getX()));
        jsXe.setProperty(_Y, Integer.toString((int)bounds.getY()));
        return true;
    }

    protected void processKeyEvent(KeyEvent e) {
        ActionManager.handleKey(e);
    }

    private void updateTitle() {
        DocumentView currentDocView = this.getDocumentView();
        if (currentDocView != null) {
            DocumentBuffer buffer = this.getDocumentBuffer();
            String name = "";
            if (buffer != null) {
                name = buffer.getName();
            }
            this.setTitle(jsXe.getAppTitle() + " - " + name);
        } else {
            this.setTitle(jsXe.getAppTitle());
        }
    }

    private void updateMenuBar() {
        JMenuBar menubar = new JMenuBar();
        DocumentView currentDocView = this.getDocumentView();
        if (currentDocView != null) {
            this.updateRecentFilesMenu();
            menubar.add(this.m_fileMenu);
            JMenu[] menus = currentDocView.getMenus();
            if (menus != null) {
                for (int i = 0; i < menus.length; ++i) {
                    menubar.add(menus[i]);
                }
            }
            menubar.add(this.m_viewMenu);
            menubar.add(this.m_toolsMenu);
            menubar.add(this.m_helpMenu);
            this.setJMenuBar(menubar);
            this.getRootPane().revalidate();
        }
    }

    private void updateRecentFilesMenu() {
        this.m_recentFilesMenu.removeAll();
        ArrayList historyEntries = jsXe.getBufferHistory().getEntries();
        int index = 0;
        WrappingMenu addMenu = this.m_recentFilesMenu;
        Iterator historyItr = historyEntries.iterator();
        while (historyItr.hasNext()) {
            BufferHistory.BufferHistoryEntry entry = (BufferHistory.BufferHistoryEntry)historyItr.next();
            ((JMenu)addMenu).add(new JMenuItem(new OpenRecentFileAction(this, entry)));
            ++index;
        }
        if (addMenu.getItemCount() == 0) {
            JMenuItem nullItem = new JMenuItem(Messages.getMessage("File.Recent.None"));
            nullItem.setEnabled(false);
            ((JMenu)addMenu).add(nullItem);
        }
    }

    private void init() {
        this.tabbedPane.setName("TabbedView");
        int width = jsXe.getIntegerProperty(_WIDTH, -1);
        int height = jsXe.getIntegerProperty(_HEIGHT, -1);
        int x = jsXe.getIntegerProperty(_X, -1);
        int y = jsXe.getIntegerProperty(_Y, -1);
        ActionSet set = new ActionSet("Built-In Commands");
        set.addAction(new FileNewAction());
        set.addAction(new FileOpenAction());
        set.addAction(new FileSaveAction());
        set.addAction(new FileSaveAsAction());
        set.addAction(new FileReloadAction());
        set.addAction(new FileCloseAction());
        set.addAction(new FileCloseAllAction());
        set.addAction(new FileExitAction());
        set.addAction(new DocumentOptionsAction());
        set.addAction(new ToolsOptionsAction());
        set.addAction(new ToolsPluginManagerAction());
        set.addAction(new jsxeAboutDialog());
        set.addAction(new ActivityLogAction());
        set.addAction(new ValidationErrorsAction());
        set.addAction(new CutAction());
        set.addAction(new CopyAction());
        set.addAction(new PasteAction());
        set.addAction(new FindAction());
        ActionManager.addActionSet(set);
        this.createDefaultMenuItems();
        this.updateMenuBar();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TabbedView.this.updateMenuBar();
                TabbedView.this.updateTitle();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.getContentPane().add((Component)this.m_statusBar, "South");
        this.pack();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler());
        this.setIconImage(jsXe.getIcon().getImage());
        this.setBounds(new Rectangle(x, y, width, height));
        EditBus.addToBus(new EBListener(){

            public void handleMessage(EBMessage message) {
                EBMessage msg;
                if (message instanceof PropertyChanged && ((PropertyChanged)(msg = (PropertyChanged)message)).getKey().endsWith(".shortcut")) {
                    TabbedView.this.createDefaultMenuItems();
                    TabbedView.this.updateMenuBar();
                }
                if (!(message instanceof DocumentBufferUpdate) || DocumentBufferUpdate.LOADED.equals(((DocumentBufferUpdate)(msg = (DocumentBufferUpdate)message)).getWhat())) {
                    // empty if block
                }
            }
        });
    }

    private void createDefaultMenuItems() {
        this.m_fileMenu = new JMenu(Messages.getMessage("File.Menu"));
        this.m_fileMenu.setMnemonic('F');
        JMenuItem menuItem = new JMenuItem(ActionManager.getAction("new-file"));
        this.m_fileMenu.add(menuItem);
        menuItem = new JMenuItem(ActionManager.getAction("open-file"));
        this.m_fileMenu.add(menuItem);
        this.m_recentFilesMenu = new WrappingMenu(Messages.getMessage("File.Recent"), jsXe.getIntegerProperty("menu.spill.over", 20));
        this.m_fileMenu.add(this.m_recentFilesMenu);
        this.m_fileMenu.addSeparator();
        menuItem = new JMenuItem(ActionManager.getAction("save-file"));
        this.m_fileMenu.add(menuItem);
        menuItem = new JMenuItem(ActionManager.getAction("save-as"));
        this.m_fileMenu.add(menuItem);
        this.m_fileMenu.addSeparator();
        menuItem = new JMenuItem(ActionManager.getAction("reload-file"));
        this.m_fileMenu.add(menuItem);
        this.m_fileMenu.addSeparator();
        menuItem = new JMenuItem(ActionManager.getAction("close-file"));
        this.m_fileMenu.add(menuItem);
        menuItem = new JMenuItem(ActionManager.getAction("close-all"));
        this.m_fileMenu.add(menuItem);
        menuItem = new JMenuItem(ActionManager.getAction("exit"));
        this.m_fileMenu.add(menuItem);
        this.m_viewMenu = new JMenu(Messages.getMessage("View.Menu"));
        this.m_viewMenu.setMnemonic('V');
        ArrayList views = jsXe.getPluginLoader().getViewPlugins();
        for (int i = 0; i < views.size(); ++i) {
            try {
                menuItem = new JMenuItem(new SetViewAction((ViewPlugin)views.get(i)));
                this.m_viewMenu.add(menuItem);
                continue;
            }
            catch (UnrecognizedPluginException e) {
                jsXe.exiterror(this, e.getMessage(), 1);
            }
        }
        this.m_toolsMenu = new JMenu(Messages.getMessage("Tools.Menu"));
        this.m_toolsMenu.setMnemonic('T');
        menuItem = new JMenuItem(ActionManager.getAction("document-options"));
        this.m_toolsMenu.add(menuItem);
        menuItem = new JMenuItem(ActionManager.getAction("general-options"));
        this.m_toolsMenu.add(menuItem);
        menuItem = new JMenuItem(ActionManager.getAction("plugin-manager"));
        this.m_toolsMenu.add(menuItem);
        menuItem = new JMenuItem(ActionManager.getAction("validation-errors"));
        this.m_toolsMenu.add(menuItem);
        ArrayList plugins = jsXe.getPluginLoader().getAllPlugins();
        for (int i = 0; i < plugins.size(); ++i) {
            ActionPlugin plugin = (ActionPlugin)plugins.get(i);
            JMenu pluginMenu = plugin.getPluginMenu();
            if (pluginMenu == null) continue;
            this.m_toolsMenu.add(pluginMenu);
        }
        this.m_helpMenu = new JMenu(Messages.getMessage("Help.Menu"));
        this.m_helpMenu.setMnemonic('H');
        menuItem = new JMenuItem(ActionManager.getAction("activity-log"));
        this.m_helpMenu.add(menuItem);
        menuItem = new JMenuItem(ActionManager.getAction("about-jsxe"));
        this.m_helpMenu.add(menuItem);
    }

    private void setDocumentView(DocumentView newView) {
        DocumentView oldView = this.getDocumentView();
        int index = this.tabbedPane.getSelectedIndex();
        if (oldView != null) {
            oldView.close();
            DocumentBuffer currentBuffer = this.getDocumentBuffer();
            Component comp = newView.getDocumentViewComponent();
            this.addKeyHandler(comp);
            this.m_documentViews.remove(oldView);
            this.m_documentViews.add(index, newView);
            this.tabbedPane.remove(index);
            this.tabbedPane.add(comp, index);
            this.tabbedPane.setIconAt(index, this.getTabIcon(currentBuffer));
            this.tabbedPane.setTitleAt(index, currentBuffer.getName());
            this.tabbedPane.setSelectedIndex(index);
            this.updateMenuBar();
        }
    }

    private ImageIcon getTabIcon(DocumentBuffer buffer) {
        if (buffer.getStatus(1)) {
            return m_dirtyIcon;
        }
        return m_cleanIcon;
    }

    private void addKeyHandler(Component comp) {
        comp.addKeyListener(this.m_keyHandler);
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            cont.addContainerListener(this.m_containerHandler);
            Component[] comps = cont.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.addKeyHandler(comps[i]);
            }
        }
    }

    private void removeKeyHandler(Component comp) {
        comp.removeKeyListener(this.m_keyHandler);
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            cont.removeContainerListener(this.m_containerHandler);
            Component[] comps = cont.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.removeKeyHandler(comps[i]);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        public void keyPressed(KeyEvent evt) {
            TabbedView.this.processKeyEvent(evt);
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowClosing(WindowEvent e) {
            jsXe.exit(TabbedView.this);
        }
    }

    private class SetViewAction
    extends AbstractAction {
        private ViewPlugin m_view;

        public SetViewAction(ViewPlugin view) throws UnrecognizedPluginException {
            this.m_view = view;
            this.putValue("Name", jsXe.getPluginLoader().getPluginProperty(this.m_view, "jsxe-plugin-human-readable-name"));
        }

        public void actionPerformed(ActionEvent e) {
            DocumentBuffer buffer = TabbedView.this.getDocumentBuffer();
            try {
                DocumentView view = this.m_view.newDocumentView(buffer);
                TabbedView.this.setDocumentView(view);
            }
            catch (IOException ioe) {
                Log.log(7, TabbedView.this, ioe.getMessage());
                JOptionPane.showMessageDialog(TabbedView.this, ioe, Messages.getMessage("IO.Error.title"), 2);
            }
        }
    }

    private class ContainerHandler
    extends ContainerAdapter {
        private ContainerHandler() {
        }

        public void componentAdded(ContainerEvent evt) {
            TabbedView.this.addKeyHandler(evt.getChild());
        }

        public void componentRemoved(ContainerEvent evt) {
            TabbedView.this.removeKeyHandler(evt.getChild());
        }
    }
}

