/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.gui.menu;

import java.awt.Component;
import java.util.HashMap;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.sourceforge.jsxe.gui.Messages;

public class WrappingMenu
extends JMenu {
    private int m_wrapCount = 20;
    private Stack m_addToMenus = new Stack();
    private HashMap m_menuHash = new HashMap();

    public WrappingMenu() {
        this.m_addToMenus.push(this);
    }

    public WrappingMenu(int wrapCount) {
        this.m_wrapCount = wrapCount;
        this.m_addToMenus.push(this);
    }

    public WrappingMenu(String label, int wrapCount) {
        super(label);
        this.m_wrapCount = wrapCount;
        this.m_addToMenus.push(this);
    }

    public JMenuItem add(Action a) {
        this.maybeAddMenu();
        JMenu menu = this.getCurrentMenu();
        JMenuItem r = menu == this ? super.add(a) : menu.add(a);
        this.m_menuHash.put(r, this.getCurrentMenu());
        return r;
    }

    public Component add(Component c) {
        this.maybeAddMenu();
        JMenu menu = this.getCurrentMenu();
        Component r = menu == this ? super.add(c) : menu.add(c);
        this.m_menuHash.put(r, this.getCurrentMenu());
        return r;
    }

    public Component add(Component c, int index) {
        Component r;
        if (index == -1) {
            r = this.add(c);
            this.m_menuHash.put(r, this.getCurrentMenu());
        } else {
            int addIndex = index / this.m_wrapCount;
            int addSubIndex = index % this.m_wrapCount;
            JMenu menu = (JMenu)this.m_addToMenus.get(addIndex);
            r = menu == this ? super.add(c, addSubIndex) : menu.add(c, addSubIndex);
            this.updateSubMenus();
        }
        return r;
    }

    public JMenuItem add(JMenuItem menuItem) {
        JMenu menu;
        if (!(menuItem instanceof MoreMenu)) {
            this.maybeAddMenu();
            this.m_menuHash.put(menuItem, this.getCurrentMenu());
        }
        JMenuItem r = (menu = this.getCurrentMenu()) == this ? super.add(menuItem) : menu.add(menuItem);
        return r;
    }

    public JMenuItem add(String s) {
        this.maybeAddMenu();
        JMenu menu = this.getCurrentMenu();
        JMenuItem r = menu == this ? super.add(s) : menu.add(s);
        this.m_menuHash.put(r, this.getCurrentMenu());
        return r;
    }

    public JMenuItem insert(Action a, int pos) {
        JMenuItem r;
        if (pos == -1) {
            r = this.add(a);
            this.m_menuHash.put(r, this.getCurrentMenu());
        } else {
            int addIndex = pos / this.m_wrapCount;
            int addSubIndex = pos % this.m_wrapCount;
            JMenu menu = (JMenu)this.m_addToMenus.get(addIndex);
            r = menu == this ? super.insert(a, addSubIndex) : menu.insert(a, addSubIndex);
            this.updateSubMenus();
        }
        return r;
    }

    public JMenuItem insert(JMenuItem mi, int pos) {
        JMenuItem r;
        if (pos == -1) {
            r = this.add(mi);
            this.m_menuHash.put(r, this.getCurrentMenu());
        } else {
            int addIndex = pos / this.m_wrapCount;
            int addSubIndex = pos % this.m_wrapCount;
            JMenu menu = (JMenu)this.m_addToMenus.get(addIndex);
            r = menu == this ? super.insert(mi, addSubIndex) : menu.insert(mi, addSubIndex);
            this.updateSubMenus();
        }
        return r;
    }

    public void insert(String s, int pos) {
        if (pos == -1) {
            JMenuItem r = this.add(s);
            this.m_menuHash.put(r, this.getCurrentMenu());
        } else {
            int addIndex = pos / this.m_wrapCount;
            int addSubIndex = pos % this.m_wrapCount;
            JMenu menu = (JMenu)this.m_addToMenus.get(addIndex);
            if (menu == this) {
                super.insert(s, addSubIndex);
            } else {
                menu.insert(s, addSubIndex);
            }
            this.updateSubMenus();
        }
    }

    public void remove(Component c) {
        JMenu menu = (JMenu)this.m_menuHash.get(c);
        if (menu == this) {
            super.remove(c);
        } else {
            menu.remove(c);
        }
        this.m_menuHash.remove(c);
        this.updateSubMenus();
    }

    public void remove(int pos) {
        this.remove(this.getMenuComponent(pos));
    }

    public void remove(JMenuItem item) {
        JMenu menu = (JMenu)this.m_menuHash.get(item);
        if (menu == this) {
            super.remove(item);
        } else {
            menu.remove(item);
        }
        this.m_menuHash.remove(item);
        this.updateSubMenus();
    }

    public void removeAll() {
        this.m_menuHash = new HashMap();
        this.m_addToMenus = new Stack();
        this.m_addToMenus.push(this);
        super.removeAll();
    }

    public Component getMenuComponent(int n) {
        int addIndex = n / this.m_wrapCount;
        int addSubIndex = n % this.m_wrapCount;
        JMenu menu = (JMenu)this.m_addToMenus.get(addIndex);
        if (menu == this) {
            return super.getMenuComponent(addSubIndex);
        }
        return menu.getMenuComponent(addSubIndex);
    }

    public int getMenuComponentCount() {
        return this.m_menuHash.keySet().size();
    }

    protected MoreMenu createMoreMenu() {
        return new MoreMenu();
    }

    private int getTrueMenuItemCount(JMenu menu) {
        if (menu == this) {
            return super.getMenuComponentCount();
        }
        return menu.getMenuComponentCount();
    }

    private JMenu getCurrentMenu() {
        return (JMenu)this.m_addToMenus.peek();
    }

    private void updateSubMenus() {
        for (int i = 0; i < this.m_addToMenus.size(); ++i) {
            JMenu nextMenu;
            JMenu menu = (JMenu)this.m_addToMenus.get(i);
            while (this.getTrueMenuItemCount(menu) > this.m_wrapCount + 1) {
                try {
                    nextMenu = (JMenu)this.m_addToMenus.get(i + 1);
                }
                catch (IndexOutOfBoundsException e) {
                    MoreMenu moreMenu = this.createMoreMenu();
                    menu.add(moreMenu);
                    this.m_addToMenus.push(moreMenu);
                    nextMenu = moreMenu;
                }
                int index = this.getTrueMenuItemCount(menu) - 2;
                Component menuComponent = menu.getComponent(index);
                menu.remove(index);
                nextMenu.add(menuComponent, 0);
            }
            while (this.getTrueMenuItemCount(menu) < this.m_wrapCount + 1 && i + 1 < this.m_addToMenus.size()) {
                nextMenu = (JMenu)this.m_addToMenus.get(i + 1);
                Component menuComponent = nextMenu.getMenuComponent(0);
                nextMenu.remove(0);
                if (menu == this) {
                    super.add(menuComponent, this.getTrueMenuItemCount(this) - 1);
                } else {
                    menu.add(menuComponent, this.getTrueMenuItemCount(menu) - 1);
                }
                if (this.getTrueMenuItemCount(nextMenu) != 0) continue;
                menu.remove(nextMenu);
                this.m_addToMenus.pop();
            }
        }
    }

    private void maybeAddMenu() {
        int componentCount = this.getTrueMenuItemCount(this.getCurrentMenu());
        if (componentCount >= this.m_wrapCount) {
            MoreMenu menu = this.createMoreMenu();
            ((JMenu)this.m_addToMenus.peek()).add(menu);
            this.m_addToMenus.push(menu);
        }
    }

    public static class MoreMenu
    extends JMenu {
        public MoreMenu() {
            super(Messages.getMessage("common.more"));
        }
    }
}

