/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.jsxe.ActionManager;
import net.sourceforge.jsxe.ActionPlugin;
import net.sourceforge.jsxe.BufferHistory;
import net.sourceforge.jsxe.CatalogManager;
import net.sourceforge.jsxe.DocumentBuffer;
import net.sourceforge.jsxe.EditBus;
import net.sourceforge.jsxe.JARClassLoader;
import net.sourceforge.jsxe.OperatingSystem;
import net.sourceforge.jsxe.PluginDependencyException;
import net.sourceforge.jsxe.PluginLoadException;
import net.sourceforge.jsxe.UnrecognizedPluginException;
import net.sourceforge.jsxe.gui.DirtyFilesDialog;
import net.sourceforge.jsxe.gui.ErrorListDialog;
import net.sourceforge.jsxe.gui.GUIUtilities;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.gui.ProgressSplashScreenWindow;
import net.sourceforge.jsxe.gui.TabbedView;
import net.sourceforge.jsxe.gui.jsxeFileDialog;
import net.sourceforge.jsxe.msg.PropertyChanged;
import net.sourceforge.jsxe.options.OptionPane;
import net.sourceforge.jsxe.util.Log;
import net.sourceforge.jsxe.util.MiscUtilities;
import org.apache.xerces.impl.Version;
import org.xml.sax.SAXException;

public class jsXe {
    public static final String MIN_JAVA_VERSION = "1.4.2";
    public static final String MIN_XERCES_VERSION = "Xerces-J 2.8.0";
    private static ArrayList m_buffers = new ArrayList();
    private static final String DefaultDocument = "<?xml version='1.0' encoding='UTF-8'?>\n<default_element>default_node</default_element>";
    private static final ImageIcon jsXeIcon = new ImageIcon((class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe).getResource("/net/sourceforge/jsxe/icons/jsxe.jpg"), "jsXe");
    private static final Properties buildProps = new Properties();
    private static boolean m_exiting = false;
    private static final Properties defaultProps = new Properties();
    private static Properties props = new Properties();
    private static BufferHistory m_bufferHistory;
    private static JARClassLoader m_pluginLoader;
    private static TabbedView m_activeView;
    private static String m_settingsDirectory;
    private static String m_homeDirectory;
    private static String jsXeHome;
    private static OptionPane jsXeOptions;
    static /* synthetic */ Class class$net$sourceforge$jsxe$jsXe;

    public static void main(String[] args) {
        try {
            String pluginsDirectory;
            File _pluginsDirectory;
            long startTime = System.currentTimeMillis();
            String javaVersion = System.getProperty("java.version");
            if (javaVersion.compareTo(MIN_JAVA_VERSION) < 0) {
                System.err.println("jsXe: ERROR: You are running Java version " + javaVersion + ".");
                System.err.println("jsXe: ERROR: jsXe requires Java 1.4.2 or later.");
                System.exit(1);
            }
            m_homeDirectory = System.getProperty("user.home");
            String fileSep = System.getProperty("file.separator");
            m_settingsDirectory = m_homeDirectory + fileSep + ".jsxe";
            File _settingsDirectory = new File(m_settingsDirectory);
            if (!_settingsDirectory.exists()) {
                _settingsDirectory.mkdirs();
            }
            if (!(_pluginsDirectory = new File(pluginsDirectory = m_settingsDirectory + "/jars")).exists()) {
                _pluginsDirectory.mkdirs();
            }
            if ((jsXeHome = System.getProperty("jsxe.home")) == null) {
                String classpath = System.getProperty("java.class.path");
                int index = classpath.toLowerCase().indexOf("jsxe.jar");
                int start = classpath.lastIndexOf(File.pathSeparator, index) + 1;
                jsXeHome = classpath.equalsIgnoreCase("jsxe.jar") ? System.getProperty("user.dir") : (index > start ? classpath.substring(start, index - 1) : System.getProperty("user.dir"));
            }
            jsXe.initDefaultProps();
            Log.init(true, 9, false);
            try {
                BufferedWriter stream = new BufferedWriter(new FileWriter(jsXe.getSettingsDirectory() + fileSep + "jsXe.log"));
                stream.flush();
                stream.write("Log file created on " + new Date());
                stream.write(System.getProperty("line.separator"));
                Log.setLogWriter(stream);
            }
            catch (IOException ioe) {
                Log.log(9, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, ioe);
            }
            Messages.initMessages();
            String viewname = null;
            ArrayList<String> files = new ArrayList<String>();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("--help") || args[i].equals("-h")) {
                    jsXe.printUsage();
                    System.exit(0);
                }
                if (args[i].equals("--version") || args[i].equals("-V")) {
                    System.out.println(jsXe.getVersion());
                    System.exit(0);
                }
                if (args[i].equals("--debug")) {
                    Log.setDebug(true);
                    continue;
                }
                files.add(args[i]);
            }
            ProgressSplashScreenWindow progressScreen = new ProgressSplashScreenWindow();
            int w = progressScreen.getSize().width;
            int h = progressScreen.getSize().height;
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - w) / 2;
            int y = (dim.height - h) / 2;
            progressScreen.setLocation(x, y);
            progressScreen.setVisible(true);
            progressScreen.updateSplashScreenDialog(10);
            String xercesVersion = "0";
            try {
                xercesVersion = Version.getVersion();
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (MiscUtilities.compareStrings(xercesVersion, MIN_XERCES_VERSION, false) < 0) {
                progressScreen.dispose();
                GUIUtilities.error(null, "No.Xerces.Error", new String[]{MIN_XERCES_VERSION});
                System.exit(1);
            }
            progressScreen.updateSplashScreenDialog(20);
            File recentFiles = new File(jsXe.getSettingsDirectory(), "recent.xml");
            m_bufferHistory = new BufferHistory();
            try {
                m_bufferHistory.load(recentFiles);
            }
            catch (IOException ioe) {
                System.err.println(jsXe.getAppTitle() + ": I/O ERROR: Could not open recent files list");
                System.err.println(jsXe.getAppTitle() + ": I/O ERROR: " + ioe.toString());
            }
            catch (SAXException saxe) {
                System.err.println(jsXe.getAppTitle() + ": I/O ERROR: recent.xml not formatted properly");
                System.err.println(jsXe.getAppTitle() + ": I/O ERROR: " + saxe.toString());
            }
            catch (ParserConfigurationException pce) {
                System.err.println(jsXe.getAppTitle() + ": I/O ERROR: Could not parse recent.xml");
                System.err.println(jsXe.getAppTitle() + ": I/O ERROR: " + pce.toString());
            }
            progressScreen.updateSplashScreenDialog(30);
            Log.log(5, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, "Loading plugins");
            m_pluginLoader = new JARClassLoader();
            Log.log(5, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, "Adding to plugin search path: " + pluginsDirectory);
            ArrayList pluginMessages = m_pluginLoader.addDirectory(pluginsDirectory);
            Log.log(5, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, "Adding to plugin search path: " + jsXeHome + fileSep + "jars");
            pluginMessages.addAll(m_pluginLoader.addDirectory(jsXeHome + fileSep + "jars"));
            progressScreen.updateSplashScreenDialog(40);
            Log.log(5, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, "Starting plugins");
            pluginMessages.addAll(m_pluginLoader.startPlugins());
            Vector<String> pluginErrors = new Vector<String>();
            if (pluginMessages.size() != 0) {
                for (int i = 0; i < pluginMessages.size(); ++i) {
                    Object error = pluginMessages.get(i);
                    if (error instanceof IOException || error instanceof PluginDependencyException) {
                        Log.log(9, class$net$sourceforge$jsxe$jsXe == null ? jsXe.class$("net.sourceforge.jsxe.jsXe") : class$net$sourceforge$jsxe$jsXe, ((Exception)error).getMessage());
                        pluginErrors.add(((Exception)error).getMessage());
                        continue;
                    }
                    if (error instanceof PluginLoadException) {
                        Log.log(7, class$net$sourceforge$jsxe$jsXe == null ? jsXe.class$("net.sourceforge.jsxe.jsXe") : class$net$sourceforge$jsxe$jsXe, ((PluginLoadException)error).getMessage());
                        continue;
                    }
                    Log.log(7, class$net$sourceforge$jsxe$jsXe == null ? jsXe.class$("net.sourceforge.jsxe.jsXe") : class$net$sourceforge$jsxe$jsXe, error.toString());
                }
            }
            progressScreen.updateSplashScreenDialog(50);
            Iterator pluginItr = m_pluginLoader.getAllPlugins().iterator();
            while (pluginItr.hasNext()) {
                ActionPlugin plugin = (ActionPlugin)pluginItr.next();
                Properties props = plugin.getProperties();
                Enumeration<?> names = props.propertyNames();
                while (names.hasMoreElements()) {
                    String name = names.nextElement().toString();
                    jsXe.setProperty(name, props.getProperty(name));
                }
                ActionManager.addActionSet(plugin.getActionSet());
                EditBus.addToBus(plugin);
            }
            progressScreen.updateSplashScreenDialog(60);
            File properties = new File(jsXe.getSettingsDirectory(), "properties");
            try {
                FileInputStream filestream = new FileInputStream(properties);
                props.load(filestream);
            }
            catch (FileNotFoundException fnfe) {
                Log.log(3, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, "User has no properties file. Running jsXe for the first time?");
            }
            catch (IOException ioe) {
                System.err.println(jsXe.getAppTitle() + ": I/O ERROR: Could not open settings file");
                System.err.println(jsXe.getAppTitle() + ": I/O ERROR: " + ioe.toString());
            }
            CatalogManager.propertiesChanged();
            progressScreen.updateSplashScreenDialog(70);
            jsXe.initPLAF();
            ActionManager.initKeyBindings();
            Log.log(5, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, "Starting the main window");
            TabbedView tabbedview = null;
            DocumentBuffer defaultBuffer = null;
            try {
                defaultBuffer = new DocumentBuffer();
                m_buffers.add(defaultBuffer);
                if (viewname == null) {
                    tabbedview = new TabbedView(defaultBuffer);
                } else {
                    try {
                        tabbedview = new TabbedView(defaultBuffer, viewname);
                    }
                    catch (UnrecognizedPluginException e) {
                        Log.log(9, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, e.getMessage());
                        System.exit(1);
                    }
                }
            }
            catch (IOException ioe) {
                Log.log(9, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, ioe);
                progressScreen.dispose();
                if (pluginErrors.size() > 0) {
                    new ErrorListDialog(tabbedview, "Plugin Error", "The following plugins could not be loaded:", new Vector(pluginErrors), false);
                }
                JOptionPane.showMessageDialog(null, ioe.getMessage() + ".", Messages.getMessage("IO.Error.title"), 0);
                System.exit(1);
            }
            m_activeView = tabbedview;
            progressScreen.updateSplashScreenDialog(85);
            Log.log(5, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, "Parsing files to open on command line");
            if (files.size() > 0 && jsXe.openXMLDocuments(tabbedview, files.toArray(new String[0]))) {
                try {
                    jsXe.closeDocumentBuffer(tabbedview, defaultBuffer);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            progressScreen.updateSplashScreenDialog(100);
            tabbedview.setVisible(true);
            progressScreen.dispose();
            if (pluginErrors.size() > 0) {
                new ErrorListDialog(tabbedview, Messages.getMessage("Plugin.Error.title"), Messages.getMessage("Plugin.Error.List.message"), new Vector(pluginErrors), false);
            }
            Log.log(5, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, "jsXe started in " + (System.currentTimeMillis() - startTime) + " milliseconds");
        }
        catch (Throwable e) {
            jsXe.exiterror(null, e, 1);
        }
    }

    public static String getBuild() {
        String major = buildProps.getProperty("major.version");
        String minor = buildProps.getProperty("minor.version");
        String beta = buildProps.getProperty("beta.version");
        String bugfix = buildProps.getProperty("build.version");
        if (major.length() == 1) {
            major = "0" + major;
        }
        if (minor.length() == 1) {
            minor = "0" + minor;
        }
        if (beta.length() == 1) {
            beta = "0" + beta;
        }
        if (bugfix.length() == 1) {
            bugfix = "0" + bugfix;
        }
        return major + "." + minor + "." + beta + "." + bugfix;
    }

    public static Date getBuildDate() {
        String buildTime = buildProps.getProperty("build.time");
        try {
            SimpleDateFormat format = new SimpleDateFormat("MM.dd.yyyy HH:mm:ss z");
            return format.parse(buildTime);
        }
        catch (ParseException e) {
            Log.log(9, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, e);
            return null;
        }
    }

    public static String getVersion() {
        return MiscUtilities.buildToVersion(jsXe.getBuild());
    }

    public static ImageIcon getIcon() {
        return jsXeIcon;
    }

    public static String getInstallDirectory() {
        return jsXeHome;
    }

    public static String getHomeDirectory() {
        return m_homeDirectory;
    }

    public static String getSettingsDirectory() {
        return m_settingsDirectory;
    }

    public static String getAppTitle() {
        return buildProps.getProperty("application.name");
    }

    public static TabbedView getActiveView() {
        return m_activeView;
    }

    public static boolean showOpenFileDialog(TabbedView view) throws IOException {
        DocumentBuffer buffer = view.getDocumentBuffer();
        File docFile = buffer.getFile();
        jsxeFileDialog loadDialog = docFile == null ? new jsxeFileDialog(m_homeDirectory) : new jsxeFileDialog(docFile);
        loadDialog.setMultiSelectionEnabled(true);
        int returnVal = ((JFileChooser)loadDialog).showOpenDialog(view);
        if (returnVal == 0) {
            boolean success = false;
            File[] files = loadDialog.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i] == null) continue;
                try {
                    success = jsXe.openXMLDocument(view, files[i]) || success;
                    continue;
                }
                catch (IOException ioe) {
                    Log.log(7, class$net$sourceforge$jsxe$jsXe == null ? jsXe.class$("net.sourceforge.jsxe.jsXe") : class$net$sourceforge$jsxe$jsXe, ioe);
                    JOptionPane.showMessageDialog(view, ioe, Messages.getMessage("IO.Error.title"), 2);
                }
            }
            return success;
        }
        return false;
    }

    public static boolean openXMLDocument(TabbedView view, File file) throws IOException {
        BufferHistory.BufferHistoryEntry entry = m_bufferHistory.getEntry(file.getPath());
        if (entry != null) {
            return jsXe.openXMLDocument(view, file, entry.getProperties(), entry.getViewName());
        }
        return jsXe.openXMLDocument(view, file, new Properties(), null);
    }

    public static boolean openXMLDocument(TabbedView view, File file, Properties properties, String viewName) throws IOException {
        if (file == null) {
            return false;
        }
        DocumentBuffer buffer = jsXe.getOpenBuffer(file);
        if (buffer != null) {
            view.setDocumentBuffer(buffer);
            return true;
        }
        Log.log(5, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, "Loading file " + file.getName());
        try {
            buffer = new DocumentBuffer(file, properties);
            m_buffers.add(buffer);
            if (viewName != null) {
                try {
                    view.addDocumentBuffer(buffer, viewName);
                }
                catch (IOException ioe) {
                    view.addDocumentBuffer(buffer);
                }
                catch (UnrecognizedPluginException e) {
                    view.addDocumentBuffer(buffer);
                }
            } else {
                view.addDocumentBuffer(buffer);
            }
            DocumentBuffer[] buffers = jsXe.getDocumentBuffers();
            if (buffers.length == 2 && buffers[0].isUntitled() && !buffers[0].getStatus(1)) {
                jsXe.closeDocumentBuffer(view, buffers[0]);
            }
            return true;
        }
        catch (IOException ioe) {
            m_buffers.remove(buffer);
            throw ioe;
        }
    }

    public static boolean openXMLDocument(TabbedView view, String doc) throws IOException {
        return jsXe.openXMLDocument(view, new ByteArrayInputStream(doc.getBytes("UTF-8")));
    }

    public static boolean openXMLDocument(TabbedView view, InputStream stream) throws IOException {
        Log.log(5, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, "Loading Untitled Document");
        DocumentBuffer buffer = new DocumentBuffer(stream);
        try {
            m_buffers.add(buffer);
            view.addDocumentBuffer(buffer);
            return true;
        }
        catch (IOException ioe) {
            m_buffers.remove(buffer);
            throw ioe;
        }
    }

    public static DocumentBuffer getOpenBuffer(File file) {
        boolean caseInsensitiveFilesystem = File.separatorChar == '\\' || File.separatorChar == ':';
        for (int i = 0; i < m_buffers.size(); ++i) {
            try {
                DocumentBuffer buffer = (DocumentBuffer)m_buffers.get(i);
                if (!buffer.equalsOnDisk(file)) continue;
                return buffer;
            }
            catch (IOException ioe) {
                jsXe.exiterror(null, ioe, 1);
            }
        }
        return null;
    }

    public static boolean closeDocumentBuffer(TabbedView view, DocumentBuffer buffer) throws IOException {
        return jsXe.closeDocumentBuffer(view, buffer, true);
    }

    public static boolean closeDocumentBuffer(TabbedView view, DocumentBuffer buffer, boolean confirmClose) throws IOException {
        if (m_buffers.contains(buffer)) {
            if (buffer.close(view, confirmClose)) {
                Log.log(5, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, "Closing " + buffer.getName());
                m_bufferHistory.setEntry(buffer, jsXe.getPluginLoader().getPluginProperty(view.getDocumentView().getViewPlugin(), "jsxe-plugin-name"));
                view.removeDocumentBuffer(buffer);
                m_buffers.remove(buffer);
                if (view.getBufferCount() == 0 && !m_exiting) {
                    try {
                        jsXe.openXMLDocument(view, jsXe.getDefaultDocument());
                    }
                    catch (IOException ioe) {
                        jsXe.exiterror(view, "Could not open default document.", 1);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean closeAllDocumentBuffers(TabbedView view) throws IOException {
        DocumentBuffer[] buffers = jsXe.getDocumentBuffers();
        ArrayList<DocumentBuffer> dirtyBufferList = new ArrayList<DocumentBuffer>();
        for (int i = 0; i < buffers.length; ++i) {
            DocumentBuffer db = buffers[i];
            if (!db.getStatus(1)) continue;
            dirtyBufferList.add(db);
        }
        boolean closeFiles = true;
        if (dirtyBufferList.size() > 0) {
            if (dirtyBufferList.size() > 1) {
                DirtyFilesDialog dirtyDialog = new DirtyFilesDialog(view, dirtyBufferList);
                dirtyDialog.setSize(200, 400);
                dirtyDialog.setResizable(true);
                closeFiles = !dirtyDialog.getCancelFlag();
            } else {
                closeFiles = jsXe.closeDocumentBuffer(view, (DocumentBuffer)dirtyBufferList.get(0), true);
            }
        }
        if (closeFiles) {
            buffers = jsXe.getDocumentBuffers();
            for (int i = 0; i < buffers.length; ++i) {
                if (jsXe.closeDocumentBuffer(view, buffers[i], false)) continue;
                return false;
            }
        }
        return closeFiles;
    }

    public static BufferHistory getBufferHistory() {
        return m_bufferHistory;
    }

    public static InputStream getDefaultDocument() {
        try {
            return new ByteArrayInputStream(DefaultDocument.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Log.log(9, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, "Broken JVM doesn't support UTF-8");
            Log.log(9, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, e);
            return null;
        }
    }

    public static DocumentBuffer[] getDocumentBuffers() {
        DocumentBuffer[] buffers = new DocumentBuffer[m_buffers.size()];
        for (int i = 0; i < m_buffers.size(); ++i) {
            buffers[i] = (DocumentBuffer)m_buffers.get(i);
        }
        return buffers;
    }

    public static void exit(TabbedView view) {
        block8: {
            m_exiting = true;
            try {
                if (view.close()) {
                    Log.log(5, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, "Exiting");
                    CatalogManager.save();
                    String settingsDirectory = jsXe.getSettingsDirectory();
                    try {
                        File properties = new File(settingsDirectory, "properties");
                        FileOutputStream filestream = new FileOutputStream(properties);
                        props.store(filestream, "Autogenerated jsXe properties" + System.getProperty("line.separator") + "#This file is not really meant to be edited.");
                    }
                    catch (IOException ioe) {
                        jsXe.exiterror(view, "Could not save jsXe properites.\n" + ioe.toString(), 1);
                    }
                    catch (ClassCastException cce) {
                        jsXe.exiterror(view, "Could not save jsXe properties.\n" + cce.toString(), 1);
                    }
                    try {
                        File recentFiles = new File(settingsDirectory, "recent.xml");
                        m_bufferHistory.save(recentFiles);
                    }
                    catch (IOException ioe) {
                        jsXe.exiterror(view, "Could not save jsXe recent files list.\n" + ioe.toString(), 1);
                    }
                    Log.closeStream();
                    System.exit(0);
                    break block8;
                }
                m_exiting = false;
            }
            catch (IOException ioe) {
                Log.log(9, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, ioe);
                JOptionPane.showMessageDialog(view, ioe, Messages.getMessage("IO.Error.title"), 2);
                m_exiting = false;
            }
        }
    }

    public static void exiterror(Object source, Object error, int errorcode) {
        String errorhdr = "jsXe has encountered a fatal error and is unable to continue.\n";
        errorhdr = errorhdr + "This is most likely a bug and should be reported to the jsXe\n";
        errorhdr = errorhdr + "developers. Please include your jsXe.log in a bug report at\n";
        errorhdr = errorhdr + "http://www.sourceforge.net/projects/jsxe/\n\n";
        Log.log(9, source, errorhdr);
        Log.log(9, source, error);
        if (source != null && source instanceof Component) {
            JOptionPane.showMessageDialog((Component)source, errorhdr + error, "Fatal Error", 2);
        }
        Log.closeStream();
        System.exit(errorcode);
    }

    public static Object setProperty(String key, String value) {
        String oldValue = jsXe.getProperty(key);
        if (oldValue != value) {
            if (value == null) {
                props.remove(key);
            } else {
                props.setProperty(key, value);
            }
            EditBus.send(new PropertyChanged(key, oldValue));
        }
        return oldValue;
    }

    public static final String getDefaultProperty(String key) {
        return defaultProps.getProperty(key);
    }

    public static final String getProperty(String key) {
        return jsXe.getProperty(key, null);
    }

    public static final String getProperty(String key, String defaultValue) {
        return props.getProperty(key, defaultProps.getProperty(key, defaultValue));
    }

    public static final int getIntegerProperty(String key, int defaultValue) {
        int intValue = defaultValue;
        String value = jsXe.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException nf) {
            try {
                return Integer.parseInt(jsXe.getDefaultProperty(key));
            }
            catch (NumberFormatException nf2) {
                return defaultValue;
            }
        }
    }

    public static final void setIntegerProperty(String name, int value) {
        jsXe.setProperty(name, String.valueOf(value));
    }

    public static final boolean getBooleanProperty(String name, boolean defaultValue) {
        boolean booleanValue = defaultValue;
        String value = jsXe.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public static final void setBooleanProperty(String name, boolean value) {
        jsXe.setProperty(name, String.valueOf(value));
    }

    public static final Font getFontProperty(String name) {
        return jsXe.getFontProperty(name, null);
    }

    public static final Font getFontProperty(String name, Font def) {
        int style;
        int size;
        String family = jsXe.getProperty(name);
        String sizeString = jsXe.getProperty(name + "size");
        String styleString = jsXe.getProperty(name + "style");
        if (family == null || sizeString == null || styleString == null) {
            return def;
        }
        try {
            size = Integer.parseInt(sizeString);
        }
        catch (NumberFormatException nf) {
            try {
                size = Integer.parseInt(jsXe.getDefaultProperty(name + "size"));
            }
            catch (NumberFormatException nf2) {
                return def;
            }
        }
        try {
            style = Integer.parseInt(styleString);
        }
        catch (NumberFormatException nf) {
            try {
                style = Integer.parseInt(jsXe.getDefaultProperty(name + "style"));
            }
            catch (NumberFormatException nf2) {
                return def;
            }
        }
        return new Font(family, style, size);
    }

    public static final void setFontProperty(String name, Font value) {
        jsXe.setProperty(name, value.getFamily());
        jsXe.setIntegerProperty(name + "size", value.getSize());
        jsXe.setIntegerProperty(name + "style", value.getStyle());
    }

    public static JARClassLoader getPluginLoader() {
        return m_pluginLoader;
    }

    public static final boolean isExiting() {
        return m_exiting;
    }

    private jsXe() {
    }

    private static String fontStyleToString(int style) {
        if (style == 0) {
            return "PLAIN";
        }
        if (style == 1) {
            return "BOLD";
        }
        if (style == 2) {
            return "ITALIC";
        }
        if (style == 3) {
            return "BOLDITALIC";
        }
        throw new RuntimeException("Invalid style: " + style);
    }

    private static String fontToString(Font font) {
        return font.getFamily() + "-" + jsXe.fontStyleToString(font.getStyle()) + "-" + font.getSize();
    }

    private static void initPLAF() {
        Font secondaryFont;
        Font primaryFont = jsXe.getFontProperty("metal.primary.font");
        if (primaryFont != null) {
            String primaryFontString = jsXe.fontToString(primaryFont);
            System.getProperties().put("swing.plaf.metal.controlFont", primaryFontString);
            System.getProperties().put("swing.plaf.metal.menuFont", primaryFontString);
        }
        if ((secondaryFont = jsXe.getFontProperty("metal.secondary.font")) != null) {
            String secondaryFontString = jsXe.fontToString(secondaryFont);
            System.getProperties().put("swing.plaf.metal.systemFont", secondaryFontString);
            System.getProperties().put("swing.plaf.metal.userFont", secondaryFontString);
        }
        try {
            String lf = jsXe.getProperty("lookAndFeel");
            if (lf != null && lf.length() != 0) {
                UIManager.setLookAndFeel(lf);
            } else if (OperatingSystem.isMacOS()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            Log.log(9, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, e);
        }
    }

    private static boolean openXMLDocuments(TabbedView view, String[] args) {
        boolean success = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            try {
                Log.log(5, class$net$sourceforge$jsxe$jsXe == null ? jsXe.class$("net.sourceforge.jsxe.jsXe") : class$net$sourceforge$jsxe$jsXe, "Trying to open " + args[i]);
                success = jsXe.openXMLDocument(view, new File(args[i])) || success;
                continue;
            }
            catch (IOException ioe) {
                Log.log(7, class$net$sourceforge$jsxe$jsXe == null ? jsXe.class$("net.sourceforge.jsxe.jsXe") : class$net$sourceforge$jsxe$jsXe, ioe);
                JOptionPane.showMessageDialog(view, ioe, Messages.getMessage("IO.Error.title"), 2);
            }
        }
        return success;
    }

    private static void initDefaultProps() {
        InputStream inputstream = (class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe).getResourceAsStream("/net/sourceforge/jsxe/properties");
        try {
            defaultProps.load(inputstream);
        }
        catch (IOException ioe) {
            Log.log(9, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, "**** Could not open default settings file ****");
            Log.log(9, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, "**** jsXe was probably not built correctly ****");
            jsXe.exiterror(null, ioe, 1);
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int windowWidth = (int)(screenSize.getWidth() / 2.0);
        int windowHeight = (int)(3.0 * screenSize.getHeight() / 4.0);
        int x = (int)(screenSize.getWidth() / 4.0);
        int y = (int)(screenSize.getHeight() / 8.0);
        defaultProps.setProperty("tabbedview.height", Integer.toString(windowHeight));
        defaultProps.setProperty("tabbedview.width", Integer.toString(windowWidth));
        defaultProps.setProperty("tabbedview.x", Integer.toString(x));
        defaultProps.setProperty("tabbedview.y", Integer.toString(y));
        inputstream = (class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe).getResourceAsStream("/net/sourceforge/jsxe/build.properties");
        try {
            buildProps.load(inputstream);
        }
        catch (IOException ioe) {
            Log.log(9, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, "**** Could not open build properties file ****");
            Log.log(9, class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = jsXe.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe, "**** jsXe was probably not built correctly ****");
            jsXe.exiterror(null, ioe, 1);
        }
    }

    private static void printUsage() {
        System.out.println("jsXe " + jsXe.getVersion());
        System.out.println("The Java Simple XML Editor");
        System.out.println();
        System.out.println("Copyright 2004 Ian Lewis");
        System.out.println("This is free software; see the source for copying conditions. There is NO");
        System.out.println("warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.");
        System.out.println();
        System.out.println("Usage: jsXe [<options>] [<files>]");
        System.out.println("      --debug               print debug information");
        System.out.println("  -h, --help                display this help and exit");
        System.out.println("  -V, --version             print version information and exit");
        System.out.println();
        System.out.println("Report bugs to <ian_lewis@users.sourceforge.net>");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

