/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.options;

import java.util.Enumeration;
import java.util.Vector;
import net.sourceforge.jsxe.options.OptionPane;
import net.sourceforge.jsxe.util.Log;

public class OptionGroup {
    private String name;
    private String m_title;
    private Vector members;

    public OptionGroup(String name, String title) {
        this.name = name;
        this.members = new Vector();
        this.m_title = title;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void addOptionGroup(OptionGroup group) {
        if (this.members.indexOf(group) != -1) {
            return;
        }
        this.members.addElement(group);
    }

    public void addOptionPane(OptionPane pane) {
        if (this.members.indexOf(pane) != -1) {
            return;
        }
        this.members.addElement(pane);
    }

    public Enumeration getMembers() {
        return this.members.elements();
    }

    public Object getMember(int index) {
        return index >= 0 && index < this.members.size() ? this.members.elementAt(index) : null;
    }

    public int getMemberIndex(Object member) {
        return this.members.indexOf(member);
    }

    public int getMemberCount() {
        return this.members.size();
    }

    public void save() {
        Enumeration elements = this.members.elements();
        while (elements.hasMoreElements()) {
            Object elem = elements.nextElement();
            try {
                if (elem instanceof OptionPane) {
                    ((OptionPane)elem).save();
                    continue;
                }
                if (!(elem instanceof OptionGroup)) continue;
                ((OptionGroup)elem).save();
            }
            catch (Throwable t) {
                Log.log(9, this, t);
            }
        }
    }

    public String toString() {
        return this.getName();
    }
}

