/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ArrayListEnumeration
implements Enumeration,
ListIterator {
    private ArrayList m_list;
    private int m_index = 0;

    public ArrayListEnumeration(ArrayList list) {
        this.m_list = list;
    }

    public boolean hasMoreElements() {
        return this.m_list.size() > this.m_index;
    }

    public Object nextElement() throws NoSuchElementException {
        try {
            if (this.hasMoreElements()) {
                return this.m_list.get(this.m_index++);
            }
            throw new NoSuchElementException("No more elements");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException(e.getMessage());
        }
    }

    public void add(Object o) {
        this.m_list.add(o);
    }

    public boolean hasNext() {
        return this.hasMoreElements();
    }

    public boolean hasPrevious() {
        return this.m_index != 0;
    }

    public Object next() throws NoSuchElementException {
        return this.nextElement();
    }

    public int nextIndex() {
        return this.m_index;
    }

    public Object previous() {
        try {
            if (this.hasPrevious()) {
                return this.m_list.get(--this.m_index);
            }
            throw new NoSuchElementException("No previous elements");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException(e.getMessage());
        }
    }

    public int previousIndex() {
        return this.nextIndex() - 1;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("cannot call remove on this Iterator");
    }

    public void set(Object o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("cannot call set on this Iterator");
    }
}

